/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.Jackson;
import io.cucumber.core.plugin.UTF8OutputStreamWriter;
import io.cucumber.messages.types.Envelope;
import io.cucumber.plugin.ConcurrentEventListener;
import io.cucumber.plugin.event.EventPublisher;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class MessageFormatter
implements ConcurrentEventListener {
    private final Writer writer;

    public MessageFormatter(OutputStream outputStream) {
        this.writer = new UTF8OutputStreamWriter(outputStream);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(Envelope.class, this::writeMessage);
    }

    private void writeMessage(Envelope envelope) {
        try {
            Jackson.OBJECT_MAPPER.writeValue(this.writer, (Object)envelope);
            this.writer.write("\n");
            if (envelope.getTestRunFinished().isPresent()) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

