/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphComponent;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;

public class DependencyGraphPathResolver {
    public static Collection<List<Describable>> calculatePaths(List<DependencyGraphNode> fromNodes, DependencyGraphNode toNode, DomainObjectContext owner) {
        LinkedHashMap shortestPaths = new LinkedHashMap();
        ArrayList<DisplayName> rootPath = new ArrayList<DisplayName>();
        rootPath.add(Describables.of((Object)owner.getDisplayName()));
        shortestPaths.put(toNode.getOwner(), rootPath);
        LinkedHashSet<DependencyGraphComponent> directDependees = new LinkedHashSet<DependencyGraphComponent>();
        for (DependencyGraphNode node : fromNodes) {
            directDependees.add(node.getOwner());
        }
        HashSet<DependencyGraphComponent> seen = new HashSet<DependencyGraphComponent>();
        LinkedList<DependencyGraphComponent> queue = new LinkedList<DependencyGraphComponent>(directDependees);
        while (!queue.isEmpty()) {
            DependencyGraphComponent version = (DependencyGraphComponent)queue.getFirst();
            if (version == toNode.getOwner()) {
                queue.removeFirst();
                continue;
            }
            if (seen.add(version)) {
                for (DependencyGraphComponent dependencyGraphComponent : version.getDependents()) {
                    queue.add(0, dependencyGraphComponent);
                }
                continue;
            }
            queue.remove();
            List shortest = null;
            for (DependencyGraphComponent incomingVersion3 : version.getDependents()) {
                List candidate = (List)shortestPaths.get(incomingVersion3);
                if (candidate == null) continue;
                if (shortest == null) {
                    shortest = candidate;
                    continue;
                }
                if (shortest.size() <= candidate.size()) continue;
                shortest = candidate;
            }
            if (shortest == null) continue;
            ArrayList<DisplayName> arrayList = new ArrayList<DisplayName>(shortest);
            arrayList.add(Describables.of((Object)version.getComponentId().getDisplayName()));
            shortestPaths.put(version, arrayList);
        }
        ArrayList<List<Describable>> paths = new ArrayList<List<Describable>>();
        for (DependencyGraphComponent dependencyGraphComponent : directDependees) {
            List path = (List)shortestPaths.get(dependencyGraphComponent);
            paths.add(path);
        }
        return paths;
    }
}

