/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.util.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PropertiesSplitter
extends BaseSplitter {
    private static final PropertiesSplitter INSTANCE = new PropertiesSplitter();
    @NonNls
    private static final Pattern WORD = Pattern.compile("\\p{L}*");

    public static PropertiesSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
        if (range == null) {
            PropertiesSplitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PropertiesSplitter.$$$reportNull$$$0(1);
        }
        if (text == null || StringUtil.isEmpty((String)text)) {
            return;
        }
        IdentifierSplitter splitter = IdentifierSplitter.getInstance();
        try {
            Matcher matcher = WORD.matcher(PropertiesSplitter.newBombedCharSequence(text, range));
            while (matcher.find()) {
                if (matcher.end() - matcher.start() < 3) continue;
                TextRange found = PropertiesSplitter.matcherRange(range, matcher);
                splitter.split(text, found, consumer);
            }
        }
        catch (BaseSplitter.TooLongBombedMatchingException tooLongBombedMatchingException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/spellchecker/inspections/PropertiesSplitter";
        objectArray[2] = "split";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

