/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.cdbg.EnumType;
import sun.jvm.hotspot.debugger.cdbg.FieldIdentifier;
import sun.jvm.hotspot.debugger.cdbg.IntType;
import sun.jvm.hotspot.debugger.cdbg.ObjectVisitor;
import sun.jvm.hotspot.debugger.cdbg.Type;
import sun.jvm.hotspot.debugger.cdbg.TypeVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicCDebugInfoDataBase;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicIntType;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicType;
import sun.jvm.hotspot.debugger.cdbg.basic.ResolveListener;
import sun.jvm.hotspot.utilities.Assert;

public class BasicEnumType
extends BasicIntType
implements EnumType {
    private Type underlyingType;
    private List enums;

    public BasicEnumType(String name, Type underlyingType) {
        this(name, underlyingType, 0);
    }

    private BasicEnumType(String name, Type underlyingType, int cvAttributes) {
        super(name, 0, false, cvAttributes);
        this.underlyingType = underlyingType;
    }

    @Override
    public EnumType asEnum() {
        return this;
    }

    @Override
    public int getSize() {
        return this.underlyingType.getSize();
    }

    @Override
    public boolean isUnsigned() {
        if (this.underlyingType.isInt()) {
            return ((IntType)this.underlyingType).isUnsigned();
        }
        return false;
    }

    public void addEnum(String name, long val) {
        if (this.enums == null) {
            this.enums = new ArrayList();
        }
        this.enums.add(new Enum(name, val));
    }

    @Override
    public int getNumEnumerates() {
        return this.enums.size();
    }

    @Override
    public String getEnumName(int i) {
        return ((Enum)this.enums.get(i)).getName();
    }

    @Override
    public long getEnumValue(int i) {
        return ((Enum)this.enums.get(i)).getValue();
    }

    @Override
    public String enumNameForValue(long val) {
        if (this.enums == null) {
            return null;
        }
        for (Enum e : this.enums) {
            if (e.getValue() != val) continue;
            return e.getName();
        }
        return null;
    }

    @Override
    Type resolveTypes(BasicCDebugInfoDataBase db, ResolveListener listener) {
        super.resolveTypes(db, listener);
        this.underlyingType = db.resolveType(this, this.underlyingType, listener, "resolving enum type");
        if (Assert.ASSERTS_ENABLED) {
            BasicType b = (BasicType)this.underlyingType;
            Assert.that(b.isLazy() || b.isInt(), "Underlying type of enum must be integer type (or unresolved due to error)");
        }
        return this;
    }

    @Override
    public void iterateObject(Address a, ObjectVisitor v, FieldIdentifier f) {
        long val = a.getCIntegerAt(0L, this.getSize(), this.isUnsigned());
        v.doEnum(f, val, this.enumNameForValue(val));
    }

    @Override
    protected Type createCVVariant(int cvAttributes) {
        BasicEnumType t = new BasicEnumType(this.getName(), this.underlyingType, cvAttributes);
        t.enums = this.enums;
        return t;
    }

    @Override
    public void visit(TypeVisitor v) {
        v.doEnumType(this);
    }

    private static class Enum {
        String name;
        long value;

        Enum(String name, long value) {
            this.name = name;
            this.value = value;
        }

        String getName() {
            return this.name;
        }

        long getValue() {
            return this.value;
        }
    }
}

