/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.paddings;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.DefaultBufferedMultiBlockCipher;
import org.bouncycastle.crypto.internal.InvalidCipherTextException;
import org.bouncycastle.crypto.internal.MultiBlockCipher;
import org.bouncycastle.crypto.internal.OutputLengthException;
import org.bouncycastle.crypto.internal.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public class PaddedBufferedMultiBlockCipher
extends DefaultBufferedMultiBlockCipher {
    BlockCipherPadding padding;

    public PaddedBufferedMultiBlockCipher(MultiBlockCipher multiBlockCipher, BlockCipherPadding blockCipherPadding) {
        super(multiBlockCipher);
        this.padding = blockCipherPadding;
    }

    @Override
    public void init(boolean bl, CipherParameters cipherParameters) throws IllegalArgumentException {
        this.forEncryption = bl;
        this.reset();
        if (cipherParameters instanceof ParametersWithRandom) {
            ParametersWithRandom parametersWithRandom = (ParametersWithRandom)cipherParameters;
            this.padding.init(parametersWithRandom.getRandom());
            this.cipher.init(bl, parametersWithRandom.getParameters());
        } else {
            if (bl) {
                this.padding.init(null);
            }
            this.cipher.init(bl, cipherParameters);
        }
        this.buf = new byte[this.cipher.getMultiBlockSize()];
        this.bufOff = 0;
    }

    @Override
    public int getOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = n2 % this.blockSize;
        if (n3 == 0) {
            if (this.forEncryption) {
                return n2 + this.blockSize;
            }
            return n2;
        }
        return n2 - n3 + this.blockSize;
    }

    @Override
    public int getUpdateOutputSize(int n) {
        int n2 = n + this.bufOff;
        int n3 = n2 % this.blockSize;
        if (!this.forEncryption && n3 == 0) {
            return Math.max(0, n2 - this.blockSize);
        }
        return n2 - n3;
    }

    @Override
    public int processBytes(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws DataLengthException, IllegalStateException {
        if (n2 < 0) {
            throw new IllegalArgumentException("input length cannot be negative");
        }
        int n4 = this.getUpdateOutputSize(n2);
        if (n4 > 0 && n3 + n4 > byArray2.length) {
            throw new OutputLengthException("output buffer too short");
        }
        int n5 = 0;
        int n6 = this.buf.length - this.bufOff;
        if (n2 > n6) {
            int n7;
            if (this.bufOff != 0) {
                System.arraycopy(byArray, n, this.buf, this.bufOff, n6);
                n5 += this.cipher.processBlocks(this.buf, 0, this.buf.length / this.blockSize, byArray2, n3);
                this.bufOff = 0;
                n2 -= n6;
                n += n6;
            }
            if (n2 > this.buf.length && (n7 = this.forEncryption ? n2 / this.blockSize : n2 / this.blockSize - (n2 % this.blockSize == 0 ? 1 : 0)) > 0) {
                n5 += this.cipher.processBlocks(byArray, n, n7, byArray2, n3 + n5);
                int n8 = n7 * this.blockSize;
                n += n8;
                if ((n2 -= n8) == 0) {
                    System.arraycopy(byArray, n - this.blockSize, this.buf, 0, this.blockSize);
                }
            }
        }
        System.arraycopy(byArray, n, this.buf, this.bufOff, n2);
        this.bufOff += n2;
        return n5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException, InvalidCipherTextException {
        int n2 = 0;
        if (this.forEncryption) {
            byte[] byArray2 = new byte[this.blockSize];
            if (this.bufOff == this.cipher.getMultiBlockSize()) {
                if (n + this.cipher.getMultiBlockSize() + this.blockSize > byArray.length) {
                    this.reset();
                    throw new OutputLengthException("output buffer too short");
                }
                System.arraycopy(this.buf, this.bufOff - this.blockSize, byArray2, 0, this.blockSize);
                n2 = this.cipher.processBlocks(this.buf, 0, this.bufOff / this.blockSize, byArray, n);
                this.bufOff = 0;
            } else if (this.bufOff == 0) {
                System.arraycopy(this.buf, 0, byArray2, 0, this.blockSize);
            } else if (this.bufOff > this.blockSize) {
                System.arraycopy(this.buf, (this.bufOff / this.blockSize - 1) * this.blockSize, byArray2, 0, this.blockSize);
            }
            int n3 = this.bufOff % this.blockSize;
            if (n3 != 0) {
                System.arraycopy(this.buf, this.bufOff - n3, byArray2, 0, n3);
            }
            this.padding.addPadding(byArray2, n3);
            if (this.bufOff == 0) {
                System.arraycopy(byArray2, 0, this.buf, 0, this.blockSize);
                this.bufOff += this.blockSize;
            } else {
                System.arraycopy(byArray2, 0, this.buf, this.bufOff / this.blockSize * this.blockSize, this.blockSize);
                this.bufOff += this.blockSize - n3;
            }
            n2 += this.cipher.processBlocks(this.buf, 0, this.bufOff / this.blockSize, byArray, n + n2);
            this.reset();
        } else {
            if (this.bufOff % this.blockSize != 0) {
                this.reset();
                throw new DataLengthException("last block incomplete in decryption");
            }
            n2 = this.cipher.processBlocks(this.buf, 0, this.bufOff / this.blockSize, this.buf, 0);
            try {
                n2 -= this.padding.padCount(Arrays.copyOfRange(this.buf, n2 - this.blockSize, n2));
                System.arraycopy(this.buf, 0, byArray, n, n2);
            }
            finally {
                this.reset();
            }
        }
        return n2;
    }
}

