/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.startree.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.opensearch.search.startree.filter.DimensionFilter;
import org.opensearch.search.startree.filter.ExactMatchDimFilter;
import org.opensearch.search.startree.filter.RangeMatchDimFilter;
import org.opensearch.search.startree.filter.provider.DimensionFilterMapper;

public class DimensionFilterMergerUtils {
    public static DimensionFilter intersect(DimensionFilter filter1, DimensionFilter filter2, DimensionFilterMapper mapper) {
        if (filter1 == null || filter2 == null) {
            return null;
        }
        if (filter1.getDimensionName() == null || filter2.getDimensionName() == null) {
            throw new IllegalArgumentException("Cannot intersect filters with null dimension name");
        }
        if (!filter1.getDimensionName().equals(filter2.getDimensionName())) {
            throw new IllegalArgumentException("Cannot intersect filters for different dimensions: " + filter1.getDimensionName() + " and " + filter2.getDimensionName());
        }
        if (filter1 instanceof RangeMatchDimFilter && filter2 instanceof RangeMatchDimFilter) {
            return DimensionFilterMergerUtils.intersectRangeFilters((RangeMatchDimFilter)filter1, (RangeMatchDimFilter)filter2, mapper);
        }
        if (filter1 instanceof ExactMatchDimFilter && filter2 instanceof ExactMatchDimFilter) {
            return DimensionFilterMergerUtils.intersectExactMatchFilters((ExactMatchDimFilter)filter1, (ExactMatchDimFilter)filter2);
        }
        if (filter1 instanceof RangeMatchDimFilter && filter2 instanceof ExactMatchDimFilter) {
            return DimensionFilterMergerUtils.intersectRangeWithExactMatch((RangeMatchDimFilter)filter1, (ExactMatchDimFilter)filter2, mapper);
        }
        if (filter1 instanceof ExactMatchDimFilter && filter2 instanceof RangeMatchDimFilter) {
            return DimensionFilterMergerUtils.intersectRangeWithExactMatch((RangeMatchDimFilter)filter2, (ExactMatchDimFilter)filter1, mapper);
        }
        throw new IllegalArgumentException("Unsupported filter combination: " + filter1.getClass().getSimpleName() + " and " + filter2.getClass().getSimpleName());
    }

    private static DimensionFilter intersectRangeFilters(RangeMatchDimFilter range1, RangeMatchDimFilter range2, DimensionFilterMapper mapper) {
        boolean includeHigh;
        Object newHigh;
        boolean includeLow;
        Object newLow;
        Object low1 = range1.getLow();
        Object high1 = range1.getHigh();
        Object low2 = range2.getLow();
        Object high2 = range2.getHigh();
        if (low1 == null) {
            newLow = low2;
            includeLow = range2.isIncludeLow();
        } else if (low2 == null) {
            newLow = low1;
            includeLow = range1.isIncludeLow();
        } else {
            int comparison = mapper.compareValues(low1, low2);
            if (comparison > 0) {
                newLow = low1;
                includeLow = range1.isIncludeLow();
            } else if (comparison < 0) {
                newLow = low2;
                includeLow = range2.isIncludeLow();
            } else {
                newLow = low1;
                boolean bl = includeLow = range1.isIncludeLow() && range2.isIncludeLow();
            }
        }
        if (high1 == null) {
            newHigh = high2;
            includeHigh = range2.isIncludeHigh();
        } else if (high2 == null) {
            newHigh = high1;
            includeHigh = range1.isIncludeHigh();
        } else {
            int comparison = mapper.compareValues(high1, high2);
            if (comparison < 0) {
                newHigh = high1;
                includeHigh = range1.isIncludeHigh();
            } else if (comparison > 0) {
                newHigh = high2;
                includeHigh = range2.isIncludeHigh();
            } else {
                newHigh = high1;
                boolean bl = includeHigh = range1.isIncludeHigh() && range2.isIncludeHigh();
            }
        }
        if (newLow != null && newHigh != null && !mapper.isValidRange(newLow, newHigh, includeLow, includeHigh)) {
            return null;
        }
        final String effectiveSubDimension = mapper.resolveUsingSubDimension() ? mapper.getSubDimensionFieldEffective(range1.getSubDimensionName(), range2.getSubDimensionName()) : null;
        return new RangeMatchDimFilter(range1.getDimensionName(), newLow, newHigh, includeLow, includeHigh){

            @Override
            public String getSubDimensionName() {
                return effectiveSubDimension;
            }
        };
    }

    private static DimensionFilter intersectExactMatchFilters(ExactMatchDimFilter exact1, ExactMatchDimFilter exact2) {
        List<Object> values1 = exact1.getRawValues();
        HashSet<Object> values2Set = new HashSet<Object>(exact2.getRawValues());
        ArrayList<Object> intersection = new ArrayList<Object>();
        for (Object value : values1) {
            if (!values2Set.contains(value)) continue;
            intersection.add(value);
        }
        if (intersection.isEmpty()) {
            return null;
        }
        return new ExactMatchDimFilter(exact1.getDimensionName(), intersection);
    }

    private static DimensionFilter intersectRangeWithExactMatch(RangeMatchDimFilter range, ExactMatchDimFilter exact, DimensionFilterMapper mapper) {
        ArrayList<Object> validValues = new ArrayList<Object>();
        for (Object value : exact.getRawValues()) {
            if (!DimensionFilterMergerUtils.isValueInRange(value, range, mapper)) continue;
            validValues.add(value);
        }
        if (validValues.isEmpty()) {
            return null;
        }
        return new ExactMatchDimFilter(exact.getDimensionName(), validValues);
    }

    private static boolean isValueInRange(Object value, RangeMatchDimFilter range, DimensionFilterMapper mapper) {
        return mapper.isValueInRange(value, range.getLow(), range.getHigh(), range.isIncludeLow(), range.isIncludeHigh());
    }
}

