/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.io.exporter.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeFormat;
import org.gephi.io.exporter.plugin.NormalizationHelper;
import org.gephi.io.exporter.spi.CharacterExporter;
import org.gephi.io.exporter.spi.GraphExporter;
import org.gephi.project.api.Workspace;
import org.gephi.utils.VersionUtils;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.joda.time.DateTimeZone;
import org.openide.util.Lookup;

public class ExporterJson
implements GraphExporter,
CharacterExporter,
LongTask {
    private boolean cancel = false;
    private ProgressTicket progress;
    private Workspace workspace;
    private boolean exportVisible;
    private Writer writer;
    private Graph graph;
    private boolean normalize = false;
    private boolean exportColors = true;
    private boolean exportPosition = true;
    private boolean exportSize = true;
    private boolean exportAttributes = true;
    private boolean exportDynamic = true;
    private boolean exportMeta = true;
    private boolean prettyPrint = true;
    private NormalizationHelper normalization;
    private Format format = Format.Graphology;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        GraphModel graphModel = graphController.getGraphModel(this.workspace);
        this.graph = this.exportVisible ? graphModel.getGraphVisible() : graphModel.getGraph();
        Progress.start((ProgressTicket)this.progress);
        this.graph.readLock();
        this.exportDynamic = this.exportDynamic && graphModel.isDynamic();
        this.normalization = NormalizationHelper.build(this.normalize, this.graph);
        Progress.switchToDeterminate((ProgressTicket)this.progress, (int)(this.graph.getNodeCount() + this.graph.getEdgeCount()));
        try {
            this.exportData();
        }
        catch (Exception e) {
            Logger.getLogger(ExporterJson.class.getName()).log(Level.SEVERE, null, e);
        }
        finally {
            this.graph.readUnlock();
            Progress.finish((ProgressTicket)this.progress);
        }
        return !this.cancel;
    }

    private void exportData() {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(Color.class, (Object)new ColorAdapter()).registerTypeAdapterFactory((TypeAdapterFactory)new GraphTypeAdapterFactory());
        if (this.prettyPrint) {
            gsonBuilder = gsonBuilder.setPrettyPrinting();
        }
        Gson gson = gsonBuilder.create();
        gson.toJson((Object)this.graph, (Appendable)this.writer);
    }

    public boolean cancel() {
        this.cancel = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public boolean isExportVisible() {
        return this.exportVisible;
    }

    public void setExportVisible(boolean exportVisible) {
        this.exportVisible = exportVisible;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    public boolean isNormalize() {
        return this.normalize;
    }

    public void setNormalize(boolean normalize) {
        this.normalize = normalize;
    }

    public boolean isExportColors() {
        return this.exportColors;
    }

    public void setExportColors(boolean exportColors) {
        this.exportColors = exportColors;
    }

    public boolean isExportPosition() {
        return this.exportPosition;
    }

    public void setExportPosition(boolean exportPosition) {
        this.exportPosition = exportPosition;
    }

    public boolean isExportSize() {
        return this.exportSize;
    }

    public void setExportSize(boolean exportSize) {
        this.exportSize = exportSize;
    }

    public boolean isExportAttributes() {
        return this.exportAttributes;
    }

    public void setExportAttributes(boolean exportAttributes) {
        this.exportAttributes = exportAttributes;
    }

    public boolean isExportDynamic() {
        return this.exportDynamic;
    }

    public void setExportDynamic(boolean exportDynamic) {
        this.exportDynamic = exportDynamic;
    }

    public boolean isExportMeta() {
        return this.exportMeta;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setExportMeta(boolean exportMeta) {
        this.exportMeta = exportMeta;
    }

    private static abstract class WriteTypeAdapter<T>
    extends TypeAdapter<T> {
        private WriteTypeAdapter() {
        }

        public T read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private class GraphTypeAdapterFactory
    implements TypeAdapterFactory {
        private GraphTypeAdapterFactory() {
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (Node.class.isAssignableFrom(type.getRawType())) {
                return new NodeTypeAdapter(gson);
            }
            if (Edge.class.isAssignableFrom(type.getRawType())) {
                return new EdgeTypeAdapter(gson);
            }
            if (Graph.class.isAssignableFrom(type.getRawType())) {
                return new GraphTypeAdapter(gson);
            }
            return null;
        }
    }

    private class EdgeTypeAdapter
    extends ElementTypeAdapter<Edge> {
        private final Set<String> reservedColumns;

        public EdgeTypeAdapter(Gson gson) {
            super(gson);
            this.reservedColumns = new HashSet<String>();
            this.reservedColumns.add("type");
            if (ExporterJson.this.exportColors) {
                this.reservedColumns.add("color");
            }
        }

        @Override
        protected Set<String> getReservedKeys() {
            return this.reservedColumns;
        }

        @Override
        public void write(JsonWriter out, Edge edge) throws IOException {
            out.beginObject();
            out.name("key");
            out.value(edge.getId().toString());
            out.name("source");
            out.value(edge.getSource().getId().toString());
            out.name("target");
            out.value(edge.getTarget().getId().toString());
            if (!edge.isDirected() && ExporterJson.this.graph.isMixed()) {
                out.name("undirected");
                out.value(Boolean.TRUE);
            }
            this.writeAttributes(out, edge);
            out.endObject();
            Progress.progress((ProgressTicket)ExporterJson.this.progress);
        }

        private void writeAttributes(JsonWriter out, Edge edge) throws IOException {
            out.name("attributes");
            out.beginObject();
            if (edge.getType() != 0) {
                out.name("type");
                out.value(edge.getTypeLabel().toString());
            }
            this.writeLabel(out, edge);
            if (edge.alpha() != 0.0f) {
                this.writeColor(out, edge.getColor());
            }
            this.writeAttValues(out, edge);
            out.endObject();
        }
    }

    private class NodeTypeAdapter
    extends ElementTypeAdapter<Node> {
        private final Set<String> reservedColumns;

        public NodeTypeAdapter(Gson gson) {
            super(gson);
            this.reservedColumns = new HashSet<String>();
            if (ExporterJson.this.exportPosition) {
                this.reservedColumns.addAll(Arrays.asList("x", "y", "z"));
            }
            if (ExporterJson.this.exportSize) {
                this.reservedColumns.add("size");
            }
            if (ExporterJson.this.exportColors) {
                this.reservedColumns.add("color");
            }
        }

        @Override
        protected Set<String> getReservedKeys() {
            return this.reservedColumns;
        }

        @Override
        public void write(JsonWriter out, Node node) throws IOException {
            out.beginObject();
            out.name("key");
            out.value(node.getId().toString());
            this.writeAttributes(out, node);
            out.endObject();
            Progress.progress((ProgressTicket)ExporterJson.this.progress);
        }

        private void writeAttributes(JsonWriter out, Node node) throws IOException {
            out.name("attributes");
            out.beginObject();
            this.writeLabel(out, node);
            this.writePositions(out, node);
            this.writeSize(out, node);
            this.writeColor(out, node.getColor());
            this.writeAttValues(out, node);
            out.endObject();
        }

        protected void writeSize(JsonWriter out, Node node) throws IOException {
            if (ExporterJson.this.exportSize) {
                float size = ExporterJson.this.normalization.normalizeSize(node.size());
                if (ExporterJson.this.normalize || size != 0.0f) {
                    out.name("size");
                    out.value(size);
                }
            }
        }

        private void writePositions(JsonWriter out, Node node) throws IOException {
            if (ExporterJson.this.exportPosition) {
                float x = ExporterJson.this.normalization.normalizeX(node.x());
                float y = ExporterJson.this.normalization.normalizeY(node.y());
                float z = ExporterJson.this.normalization.normalizeZ(node.z());
                if (x != 0.0f || y != 0.0f || z != 0.0f) {
                    out.name("x");
                    out.value(node.x());
                    out.name("y");
                    out.value(node.y());
                    if (ExporterJson.this.normalization.minZ != 0.0f || ExporterJson.this.normalization.maxZ != 0.0f) {
                        out.name("z");
                        out.value(node.z());
                    }
                }
            }
        }
    }

    private abstract class ElementTypeAdapter<T extends Element>
    extends WriteTypeAdapter<T> {
        private final TypeAdapter<Color> colorAdapter;

        public ElementTypeAdapter(Gson gson) {
            this.colorAdapter = gson.getAdapter(Color.class);
        }

        protected abstract Set<String> getReservedKeys();

        public void write(JsonWriter out, T element) throws IOException {
            throw new UnsupportedOperationException("Not to be called directly");
        }

        protected void writeAttValues(JsonWriter out, T element) throws IOException {
            if (ExporterJson.this.exportAttributes) {
                TimeFormat timeFormat = ExporterJson.this.graph.getModel().getTimeFormat();
                DateTimeZone timeZone = ExporterJson.this.graph.getModel().getTimeZone();
                Set<String> reservedKeys = this.getReservedKeys();
                for (Column column : element.getAttributeColumns()) {
                    if (column.isProperty() && (!(element instanceof Edge) || !column.getId().equals("weight"))) continue;
                    if (!reservedKeys.contains(column.getId().toLowerCase())) {
                        String columnTitle;
                        String columnId = column.getId();
                        String columnHeader = columnId.equalsIgnoreCase(columnTitle = column.getTitle()) && !column.isProperty() ? columnTitle : columnId;
                        Object value = ExporterJson.this.exportDynamic ? element.getAttribute(column) : element.getAttribute(column, ExporterJson.this.graph.getView());
                        out.name(columnHeader);
                        if (value instanceof Number) {
                            out.value((Number)value);
                            continue;
                        }
                        if (value instanceof Boolean) {
                            out.value((Boolean)value);
                            continue;
                        }
                        out.value(AttributeUtils.print((Object)value, (TimeFormat)timeFormat, (DateTimeZone)timeZone));
                        continue;
                    }
                    Logger.getLogger(ExporterJson.class.getName()).log(Level.WARNING, "Attribute value for column '" + column.getId() + "' is ignored as its key overlap with a default key");
                }
            }
        }

        protected void writeColor(JsonWriter out, Color color) throws IOException {
            if (ExporterJson.this.exportColors) {
                this.colorAdapter.write(out, (Object)color);
            }
        }

        protected void writeLabel(JsonWriter out, T element) throws IOException {
            if (element.getLabel() != null && !element.getLabel().isEmpty()) {
                out.name("label");
                out.value(element.getLabel());
            }
        }
    }

    private class GraphTypeAdapter
    extends WriteTypeAdapter<Graph> {
        private final TypeAdapter<Node> nodeTypeAdapter;
        private final TypeAdapter<Edge> edgeTypeAdapter;

        public GraphTypeAdapter(Gson gson) {
            this.nodeTypeAdapter = gson.getAdapter(Node.class);
            this.edgeTypeAdapter = gson.getAdapter(Edge.class);
        }

        public void write(JsonWriter out, Graph graph) throws IOException {
            out.beginObject();
            this.writeAttributes(out);
            this.writeOptions(out, graph);
            out.name("nodes");
            out.beginArray();
            for (Node node : graph.getNodes()) {
                if (ExporterJson.this.cancel) continue;
                this.nodeTypeAdapter.write(out, (Object)node);
            }
            out.endArray();
            out.name("edges");
            out.beginArray();
            for (Edge edge : graph.getEdges()) {
                if (ExporterJson.this.cancel) continue;
                this.edgeTypeAdapter.write(out, (Object)edge);
            }
            out.endArray();
            out.endObject();
        }

        protected void writeOptions(JsonWriter out, Graph graph) throws IOException {
            out.name("options");
            out.beginObject();
            out.name("multi");
            out.value(graph.getModel().getEdgeTypeLabels(false).length > 1);
            out.name("allowSelfLoops");
            out.value(true);
            out.name("type");
            out.value(graph.getModel().isUndirected() ? "undirected" : (graph.getModel().isMixed() ? "mixed" : "directed"));
            out.endObject();
        }

        protected void writeAttributes(JsonWriter out) throws IOException {
            if (ExporterJson.this.exportMeta) {
                out.name("attributes");
                out.beginObject();
                out.name("creator");
                out.value(VersionUtils.getGephiVersion());
                if (ExporterJson.this.exportDynamic) {
                    Configuration graphConfig = ExporterJson.this.graph.getModel().getConfiguration();
                    TimeFormat timeFormat = ExporterJson.this.graph.getModel().getTimeFormat();
                    out.name("timeformat");
                    out.value(timeFormat.toString().toLowerCase());
                    out.name("timerepresentation");
                    out.value(graphConfig.getTimeRepresentation().toString().toLowerCase());
                    out.name("timezone");
                    out.value(ExporterJson.this.graph.getModel().getTimeZone().getID());
                }
                out.endObject();
            }
        }
    }

    private class ColorAdapter
    extends WriteTypeAdapter<Color> {
        private ColorAdapter() {
        }

        public void write(JsonWriter out, Color value) throws IOException {
            if (ExporterJson.this.exportColors) {
                out.name("color");
                if (value.getAlpha() < 255) {
                    out.value(String.format("#%08x", value.getRGB() << 8 | value.getAlpha()));
                } else {
                    out.value(String.format("#%06x", value.getRGB() & 0xFFFFFF));
                }
            }
        }
    }

    public static enum Format {
        Graphology;

    }
}

