/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBlock;

public class MachoProgramUtils {
    public static Address getNextAvailableAddress(Program program) {
        Address maxAddress = null;
        for (MemoryBlock block : program.getMemory().getBlocks()) {
            if (block.isOverlay() || maxAddress != null && block.getEnd().compareTo((Object)maxAddress) <= 0) continue;
            maxAddress = block.getEnd();
        }
        if (maxAddress == null) {
            return program.getAddressFactory().getDefaultAddressSpace().getAddress(4096L);
        }
        long maxAddr = maxAddress.getOffset();
        long remainder = maxAddr % 4096L;
        return maxAddress.getNewAddress(maxAddr + 4096L - remainder);
    }

    public static Address addExternalBlock(Program program, long size, MessageLog log) throws Exception {
        Address ret;
        Memory mem = program.getMemory();
        MemoryBlock externalBlock = mem.getBlock("EXTERNAL");
        if (externalBlock != null) {
            ret = externalBlock.getEnd().add(1L);
            MemoryBlock newBlock = mem.createBlock(externalBlock, "EXTERNAL", ret, size);
            mem.join(externalBlock, newBlock);
        } else {
            ret = MachoProgramUtils.getNextAvailableAddress(program);
            externalBlock = mem.createUninitializedBlock("EXTERNAL", ret, size, false);
            externalBlock.setWrite(true);
            externalBlock.setArtificial(true);
            externalBlock.setComment("NOTE: This block is artificial and is used to make relocations work correctly");
        }
        return ret;
    }
}

