/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.cmd;

import tim.prune.cmd.Command;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;

public class ConnectMediaCmd
extends Command {
    private final DataPoint _point;
    private final Photo _photo;
    private final AudioClip _audio;

    public ConnectMediaCmd(DataPoint dataPoint, Photo photo, AudioClip audioClip) {
        this(null, dataPoint, photo, audioClip);
    }

    public ConnectMediaCmd(DataPoint dataPoint, MediaObject mediaObject) {
        this(null, dataPoint, mediaObject instanceof Photo ? (Photo)mediaObject : null, mediaObject instanceof AudioClip ? (AudioClip)mediaObject : null);
    }

    protected ConnectMediaCmd(ConnectMediaCmd connectMediaCmd, DataPoint dataPoint, Photo photo, AudioClip audioClip) {
        super(connectMediaCmd);
        this._point = dataPoint;
        this._photo = photo;
        this._audio = audioClip;
    }

    @Override
    public int getUpdateFlags() {
        return 18;
    }

    @Override
    protected boolean executeCommand(TrackInfo trackInfo) {
        boolean bl;
        if (this._point == null) {
            return false;
        }
        boolean bl2 = this._photo != null && this._point.getPhoto() == null;
        boolean bl3 = this._photo == null && this._point.getPhoto() != null;
        boolean bl4 = this._audio != null && this._point.getAudio() == null;
        boolean bl5 = bl = this._audio == null && this._point.getAudio() != null;
        if (bl2) {
            this._point.setPhoto(this._photo);
            this._photo.setDataPoint(this._point);
        } else if (bl3) {
            this._point.getPhoto().setDataPoint(null);
            this._point.setPhoto(null);
        }
        if (bl4) {
            this._point.setAudio(this._audio);
            this._audio.setDataPoint(this._point);
        } else if (bl) {
            this._point.getAudio().setDataPoint(null);
            this._point.setAudio(null);
        }
        return true;
    }

    @Override
    protected Command makeInverse(TrackInfo trackInfo) {
        Photo photo = this._photo == null ? this._point.getPhoto() : null;
        AudioClip audioClip = this._audio == null ? this._point.getAudio() : null;
        return new ConnectMediaCmd(this, this._point, photo, audioClip);
    }
}

