/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.codegen;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.meta.features.DocumentationFeature;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.model.ApiInfoMap;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.templating.mustache.CamelCaseAndSanitizeLambda;
import org.openapitools.codegen.utils.StringUtils;
import org.qtproject.qt.codegen.CppQt6AbstractCodegen;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CppQt6ClientGenerator
extends CppQt6AbstractCodegen
implements CodegenConfig {
    public static final String DEFAULT_PACKAGE_NAME = "Qt6OpenAPIClient";
    public static final String COMMON_LIB_NAME_OPTION = "commonLibraryName";
    public static final String DEFAULT_COMMON_LIB_NAME = "QtOpenAPICommon";
    public static final String COMMON_LIB_OPTION = "commonLibrary";
    public static final String MAKE_OPERATIONS_VIRTUAL_NAME = "makeOperationsVirtual";
    public static final String MAKE_OPERATIONS_VIRTUAL_DESC = "Make all operations methods virtual. This makes it easy to mock the generated API class for testing purposes.";
    public static final String MAKE_QML_ENABLED = "enableQmlCode";
    public static final String MAKE_QML_ENABLED_DESC = "Enable registering C++ Types with the QML Type System";
    protected static final String CPP_COMMON_NAMESPACE = "cppCommonNamespace";
    protected static final String CPP_COMMON_NAMESPACE_DESC = "C++ namespace (convention: name::space::for::api) for the common library.";
    protected String cppCommonNamespace = "QtCommonOpenAPI";
    protected String namePrefix = "QtOAI";
    public static final String USE_CMAKE_FUNCTION = "useCmakeMacro";
    public static final String USE_CMAKE_FUNCTION_DESC = "The 'qt6_add_openapi_client' function uses the option for CombinedModelsAndAPIs.cpp file generation";
    protected String packageName = "";
    protected String sourceFolder = "client";
    protected String commonLibrarySourceFolder = "common";
    protected String apiVersion = "1.0.0";
    protected static final String USE_COMMON_LIBRARY = "enableCommonLibGeneration";
    private final Logger LOGGER = LoggerFactory.getLogger(CppQt6ClientGenerator.class);
    protected boolean addDownloadProgress = false;
    protected boolean makeOperationsVirtual = true;
    protected boolean enableQmlCode = false;
    protected String commonLibrary;
    protected String commonLibraryName;
    protected boolean useCmakeMacro;
    protected String licenseName;

    public CodegenType getTag() {
        return CodegenType.CLIENT;
    }

    public String getName() {
        return "cpp-qt6-client";
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        objs = super.postProcessOperationsWithModels(objs, allModels);
        this.removeImport(objs, "#include <QList>");
        return objs;
    }

    public String getHelp() {
        return "Generates a cpp-qt6-client client library.";
    }

    public CppQt6ClientGenerator() {
        this.commonLibrary = GENERATION_TYPE.CLIENT_LIB.value;
        this.commonLibraryName = DEFAULT_PACKAGE_NAME;
        this.useCmakeMacro = false;
        this.licenseName = "";
        this.modifyFeatureSet(features -> features.includeDocumentationFeatures(new DocumentationFeature[]{DocumentationFeature.Readme}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterizedServer}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.MultiServer}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BasicAuth}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.ApiKey}).includeSecurityFeatures(new SecurityFeature[]{SecurityFeature.BearerToken}).includeGlobalFeatures(new GlobalFeature[]{GlobalFeature.ParameterStyling}));
        this.outputFolder = "generated-code/cpp-qt6-client";
        this.modelTemplateFiles.put("model-header.mustache", ".h");
        this.modelTemplateFiles.put("model-body.mustache", ".cpp");
        this.apiTemplateFiles.put("api-header.mustache", ".h");
        this.apiTemplateFiles.put("api-body.mustache", ".cpp");
        this.addOption(CPP_COMMON_NAMESPACE, CPP_COMMON_NAMESPACE_DESC, this.cppCommonNamespace);
        this.addOption("packageName", "C++ package (library) name.", DEFAULT_PACKAGE_NAME);
        this.addSwitch("addDownloadProgress", "Add support for Qt download progress", this.addDownloadProgress);
        this.addSwitch(MAKE_OPERATIONS_VIRTUAL_NAME, MAKE_OPERATIONS_VIRTUAL_DESC, this.makeOperationsVirtual);
        this.addSwitch(MAKE_QML_ENABLED, MAKE_QML_ENABLED_DESC, this.enableQmlCode);
        this.addSwitch(USE_CMAKE_FUNCTION, USE_CMAKE_FUNCTION_DESC, this.useCmakeMacro);
        this.addOption(COMMON_LIB_NAME_OPTION, "Name of the common client library, if generated.", DEFAULT_COMMON_LIB_NAME);
        CliOption commonLib = new CliOption(COMMON_LIB_OPTION, "Generate common library for the client or not.");
        HashMap<String, String> commonLibOptions = new HashMap<String, String>();
        commonLibOptions.put(GENERATION_TYPE.COMMON_LIB.value, "The common resources will be generated as a Common library.");
        commonLibOptions.put(GENERATION_TYPE.CLIENT_LIB.value, "The Client will be generated without common files at all.");
        commonLib.setEnum(commonLibOptions);
        commonLib.setDefault(this.commonLibrary);
        this.cliOptions.add(commonLib);
        this.cliOptions.add(new CliOption("licenseName", "The name of the license").defaultValue(this.licenseName));
        this.templateDir = "cpp-qt6-client";
        this.typeMapping.put("AnyType", "QJsonValue");
        this.importMapping.put("QJsonValue", "#include <QtCore/qjsonvalue.h>");
        this.reservedWords.add("valid");
        this.reservedWords.add("set");
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("camelcase", new CamelCaseAndSanitizeLambda(false).generator((CodegenConfig)this));
        this.additionalProperties.put(CPP_COMMON_NAMESPACE, this.cppCommonNamespace);
    }

    public void preprocessOpenAPI(OpenAPI openAPI) {
        super.preprocessOpenAPI(openAPI);
        if (openAPI.getInfo() != null) {
            Info info = openAPI.getInfo();
            if (this.additionalProperties.get("licenseName") == null && info.getLicense() != null) {
                License license = info.getLicense();
                this.licenseName = license.getName();
            }
        }
        this.additionalProperties.put("licenseName", this.licenseName);
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(CPP_COMMON_NAMESPACE)) {
            this.cppCommonNamespace = (String)this.additionalProperties.get(CPP_COMMON_NAMESPACE);
        }
        this.additionalProperties.put("cppCommonNamespaceDeclarations", this.cppCommonNamespace.split("\\::"));
        this.packageName = this.additionalProperties.getOrDefault("packageName", DEFAULT_PACKAGE_NAME);
        this.commonLibraryName = this.additionalProperties.getOrDefault(COMMON_LIB_NAME_OPTION, DEFAULT_COMMON_LIB_NAME);
        if (this.additionalProperties.containsKey("licenseName")) {
            this.setLicenseName((String)this.additionalProperties.get("licenseName"));
        }
        if (this.additionalProperties.containsKey(MAKE_OPERATIONS_VIRTUAL_NAME)) {
            this.setMakeOperationsVirtual(this.convertPropertyToBooleanAndWriteBack(MAKE_OPERATIONS_VIRTUAL_NAME));
        } else {
            this.additionalProperties.put(MAKE_OPERATIONS_VIRTUAL_NAME, this.makeOperationsVirtual);
        }
        if (this.additionalProperties.containsKey(MAKE_QML_ENABLED)) {
            this.setEnableQmlCode(this.convertPropertyToBooleanAndWriteBack(MAKE_QML_ENABLED));
        } else {
            this.additionalProperties.put(MAKE_QML_ENABLED, this.enableQmlCode);
        }
        if (this.additionalProperties.containsKey(USE_CMAKE_FUNCTION)) {
            this.setUseCmakeMacro(this.convertPropertyToBooleanAndWriteBack(USE_CMAKE_FUNCTION));
        } else {
            this.additionalProperties.put(USE_CMAKE_FUNCTION, this.useCmakeMacro);
        }
        this.additionalProperties.put("packageName", this.packageName);
        if (this.additionalProperties.containsKey(COMMON_LIB_OPTION) && !this.additionalProperties.get(COMMON_LIB_OPTION).toString().isEmpty()) {
            this.setCommonLibrary(this.additionalProperties.get(COMMON_LIB_OPTION).toString());
        } else {
            this.additionalProperties.put(COMMON_LIB_OPTION, this.commonLibrary);
        }
        if (this.commonLibrary.equals(GENERATION_TYPE.COMMON_LIB.value)) {
            if (this.additionalProperties.containsKey(COMMON_LIB_NAME_OPTION)) {
                this.setCommonLibraryName(this.additionalProperties.get(COMMON_LIB_NAME_OPTION).toString());
            } else {
                this.additionalProperties.put(COMMON_LIB_NAME_OPTION, this.commonLibraryName);
            }
        }
        this.additionalProperties.put(USE_COMMON_LIBRARY, this.commonLibrary.equals(GENERATION_TYPE.COMMON_LIB.value));
        this.supportingFiles.clear();
        this.namePrefix = this.additionalProperties.containsKey("modelNamePrefix") ? this.modelNamePrefix : "QtOAI";
        this.supportingFiles.add(new SupportingFile("README.mustache", this.sourceFolder, "README.md"));
        this.supportingFiles.add(new SupportingFile("CMakeConfig.mustache", this.sourceFolder, "Config.cmake.in"));
        if (!this.useCmakeMacro) {
            this.supportingFiles.add(new SupportingFile("CMakeLists.txt.mustache", this.sourceFolder, "CMakeLists.txt"));
        }
        this.supportingFiles.add(new SupportingFile("exports.mustache", this.sourceFolder, this.namePrefix + "Exports.h"));
        this.supportingFiles.add(new SupportingFile("doc/Doxyfile.in.mustache", this.sourceFolder, "doc/Doxyfile.in"));
        this.typeMapping.put("file", this.namePrefix + "HttpFileElement");
        this.importMapping.put(this.namePrefix + "HttpFileElement", "#include \"" + this.namePrefix + "HttpFileElement.h\"");
        if (this.commonLibrary.equals(GENERATION_TYPE.CLIENT_LIB.value)) {
            this.LOGGER.info("Skipping ./common/* templates generation. 'Skip-Common-Files' is ON.");
            return;
        }
        if (this.useCmakeMacro) {
            this.modelTemplateFiles.clear();
            this.apiTemplateFiles.clear();
        }
        this.supportingFiles.add(new SupportingFile("common/api-base-header.mustache", this.commonLibrarySourceFolder, this.namePrefix + "BaseApi.h"));
        this.supportingFiles.add(new SupportingFile("common/api-base-body.mustache", this.commonLibrarySourceFolder, this.namePrefix + "BaseApi.cpp"));
        this.supportingFiles.add(new SupportingFile("common/helpers-header.mustache", this.commonLibrarySourceFolder, this.namePrefix + "Helpers.h"));
        this.supportingFiles.add(new SupportingFile("common/helpers-body.mustache", this.commonLibrarySourceFolder, this.namePrefix + "Helpers.cpp"));
        this.supportingFiles.add(new SupportingFile("common/HttpRequest.h.mustache", this.commonLibrarySourceFolder, this.namePrefix + "HttpRequest.h"));
        this.supportingFiles.add(new SupportingFile("common/HttpRequest.cpp.mustache", this.commonLibrarySourceFolder, this.namePrefix + "HttpRequest.cpp"));
        this.supportingFiles.add(new SupportingFile("common/HttpFileElement.h.mustache", this.commonLibrarySourceFolder, this.namePrefix + "HttpFileElement.h"));
        this.supportingFiles.add(new SupportingFile("common/HttpFileElement.cpp.mustache", this.commonLibrarySourceFolder, this.namePrefix + "HttpFileElement.cpp"));
        this.supportingFiles.add(new SupportingFile("common/object.mustache", this.commonLibrarySourceFolder, this.namePrefix + "Object.h"));
        this.supportingFiles.add(new SupportingFile("common/enum.mustache", this.commonLibrarySourceFolder, this.namePrefix + "Enum.h"));
        this.supportingFiles.add(new SupportingFile("common/common-exports.mustache", this.commonLibrarySourceFolder, this.namePrefix + "CommonExports.h"));
        this.supportingFiles.add(new SupportingFile("common/ServerConfiguration.mustache", this.commonLibrarySourceFolder, this.namePrefix + "ServerConfiguration.h"));
        this.supportingFiles.add(new SupportingFile("common/ServerVariable.mustache", this.commonLibrarySourceFolder, this.namePrefix + "ServerVariable.h"));
        this.supportingFiles.add(new SupportingFile("common/CMakeConfig.mustache", this.commonLibrarySourceFolder, "Config.cmake.in"));
        if (!this.useCmakeMacro) {
            this.supportingFiles.add(new SupportingFile("common/CMakeLists.txt.mustache", this.commonLibrarySourceFolder, "CMakeLists.txt"));
        }
    }

    public String escapeReservedWord(String name) {
        return "_" + name;
    }

    public String modelFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.modelPackage().replace("::", File.separator);
    }

    public String apiFileFolder() {
        return this.outputFolder + "/" + this.sourceFolder + "/" + this.apiPackage().replace("::", File.separator);
    }

    public String escapeUnsafeCharacters(String input) {
        return input;
    }

    public String escapeQuotationMark(String input) {
        return input.replace("\"", "\\\"");
    }

    public String toApiFilename(String name) {
        return this.modelNamePrefix + this.sanitizeName(StringUtils.camelize((String)name)) + "Api";
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        objs = super.postProcessSupportingFileData(objs);
        if (this.useCmakeMacro && this.commonLibrary.equals(GENERATION_TYPE.CLIENT_LIB.value)) {
            ArrayList<Path> apiClassFiles = new ArrayList<Path>();
            String apiDir = this.apiPackage.replace('.', File.separatorChar);
            ApiInfoMap apiInfo = (ApiInfoMap)objs.get("apiInfo");
            for (OperationsMap api : apiInfo.getApis()) {
                OperationMap opsApi = api.getOperations();
                Path headerPath = Paths.get(this.outputFolder, apiDir, this.sourceFolder + File.separator + opsApi.getClassname() + ".h");
                Path cppPath = Paths.get(this.outputFolder, apiDir, this.sourceFolder + File.separator + opsApi.getClassname() + ".cpp");
                apiClassFiles.add(headerPath);
                apiClassFiles.add(cppPath);
            }
            List models = (List)objs.get("models");
            List codegenModelList = models.stream().map(ModelMap::getModel).collect(Collectors.toList());
            ArrayList<Object> modelCppFilePaths = new ArrayList<Object>();
            ArrayList<Path> modelHeaderFilePaths = new ArrayList<Path>();
            Path combinedFile = Paths.get(this.outputFolder, this.sourceFolder + File.separator + this.namePrefix + "CombinedModelsAndAPIs.cpp");
            String modelDir = this.modelPackage.replace('.', File.separatorChar);
            for (CodegenModel codeMod : codegenModelList) {
                Path headerPath = Paths.get(this.outputFolder, modelDir, this.sourceFolder + File.separator + codeMod.getClassFilename() + ".h");
                Path cppPath = Paths.get(this.outputFolder, modelDir, this.sourceFolder + File.separator + codeMod.getClassFilename() + ".cpp");
                modelHeaderFilePaths.add(headerPath);
                modelCppFilePaths.add(cppPath);
            }
            try {
                String content;
                void var15_19;
                BufferedWriter writer = Files.newBufferedWriter(combinedFile, StandardCharsets.UTF_8, new OpenOption[0]);
                ArrayList<String> filteredOrdering = new ArrayList<String>();
                HashMap<String, String> contentMap = new HashMap<String, String>();
                for (Path path : modelHeaderFilePaths) {
                    if (Files.exists(path, new LinkOption[0])) {
                        String string = new String(Files.readAllBytes(path));
                        contentMap.put(path.getFileName().toString(), string);
                        continue;
                    }
                    this.LOGGER.warn("Missing the generated Model file: {}", (Object)path);
                }
                ArrayList<String> includedHeaders = new ArrayList<String>();
                for (Map.Entry entry : contentMap.entrySet()) {
                    for (Path path : modelHeaderFilePaths) {
                        String includeHeader = "#include \"" + path.getFileName().toString() + "\"";
                        if (!((String)entry.getValue()).contains(includeHeader) || includedHeaders.contains(path.getFileName().toString())) continue;
                        if (!includedHeaders.contains(entry.getKey())) {
                            filteredOrdering.add((String)contentMap.get(path.getFileName().toString()));
                            includedHeaders.add(path.getFileName().toString());
                            continue;
                        }
                        int index = includedHeaders.indexOf(entry.getKey());
                        if (index < 0 || index >= includedHeaders.size()) continue;
                        filteredOrdering.add(index, (String)contentMap.get(path.getFileName().toString()));
                        includedHeaders.add(index, path.getFileName().toString());
                    }
                    if (includedHeaders.contains(entry.getKey())) continue;
                    filteredOrdering.add((String)entry.getValue());
                    includedHeaders.add((String)entry.getKey());
                }
                boolean bl = false;
                while (var15_19 < filteredOrdering.size()) {
                    writer.write((String)filteredOrdering.get((int)var15_19));
                    writer.write("\n\n");
                    ++var15_19;
                }
                for (Path path : modelCppFilePaths) {
                    if (Files.exists(path, new LinkOption[0])) {
                        writer.write("// ===== " + String.valueOf(path.getFileName()) + " =====\n");
                        content = new String(Files.readAllBytes(path));
                        writer.write(content);
                        writer.write("\n\n");
                        continue;
                    }
                    this.LOGGER.warn("Missing the generated Model file: {}", (Object)path);
                }
                for (Path path : apiClassFiles) {
                    if (Files.exists(path, new LinkOption[0])) {
                        writer.write("// ===== " + String.valueOf(path.getFileName()) + " =====\n");
                        content = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                        writer.write(content);
                        writer.write("\n\n");
                        continue;
                    }
                    this.LOGGER.warn("Missing the generated API file: {}", (Object)path);
                }
                writer.write("#include \"" + this.namePrefix + "CombinedModelsAndAPIs.moc\"");
                writer.write("\n\n");
                writer.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to generate CombinedModelsAndAPIs.cpp file, when the option useCmakeMacro is enabled.", e);
            }
        }
        return objs;
    }

    @Generated
    public void setAddDownloadProgress(boolean addDownloadProgress) {
        this.addDownloadProgress = addDownloadProgress;
    }

    @Generated
    public void setMakeOperationsVirtual(boolean makeOperationsVirtual) {
        this.makeOperationsVirtual = makeOperationsVirtual;
    }

    @Generated
    public void setEnableQmlCode(boolean enableQmlCode) {
        this.enableQmlCode = enableQmlCode;
    }

    @Generated
    public void setCommonLibrary(String commonLibrary) {
        this.commonLibrary = commonLibrary;
    }

    @Generated
    public void setCommonLibraryName(String commonLibraryName) {
        this.commonLibraryName = commonLibraryName;
    }

    @Generated
    public void setUseCmakeMacro(boolean useCmakeMacro) {
        this.useCmakeMacro = useCmakeMacro;
    }

    @Generated
    public void setLicenseName(String licenseName) {
        this.licenseName = licenseName;
    }

    public static enum GENERATION_TYPE {
        COMMON_LIB("Gen-Common-Lib"),
        CLIENT_LIB("Gen-Client-Lib");

        public final String value;

        private GENERATION_TYPE(String value) {
            this.value = value;
        }
    }
}

