local function item_sound(filename, volume)
  return
  {
    filename = "__base__/sound/item/"..filename,
    volume = volume,
    aggregation = {max_count = 1, remove = true},
  }
end

local item_sounds =
{
  ammo_small_inventory_move = item_sound("ammo-small-inventory-move.ogg", 0.8),
  ammo_small_inventory_pickup = item_sound("ammo-small-inventory-pickup.ogg", 0.7),
  ammo_large_inventory_move = item_sound("ammo-large-inventory-move.ogg", 0.6),
  ammo_large_inventory_pickup = item_sound("ammo-large-inventory-pickup.ogg", 0.7),
  weapon_small_inventory_pickup = item_sound("weapon-small-inventory-pickup.ogg", 0.5),
  weapon_small_inventory_move = item_sound("weapon-small-inventory-move.ogg", 0.7),
  weapon_large_inventory_pickup = item_sound("weapon-large-inventory-pickup.ogg", 0.7),
  weapon_large_inventory_move = item_sound("weapon-large-inventory-move.ogg", 0.7),
  resource_inventory_move = item_sound("resource-inventory-move.ogg", 0.8),
  resource_inventory_pickup = item_sound("resource-inventory-pickup.ogg", 0.6),
  brick_inventory_move = item_sound("brick-inventory-move.ogg", 0.5),
  brick_inventory_pickup = item_sound("brick-inventory-pickup.ogg", 0.6),
  wood_inventory_move = item_sound("wood-inventory-move.ogg", 0.7),
  wood_inventory_pickup = item_sound("wood-inventory-pickup.ogg", 0.8),
  metal_small_inventory_move = item_sound("metal-small-inventory-move.ogg", 0.8),
  metal_small_inventory_pickup = item_sound("metal-small-inventory-pickup.ogg", 0.8),
  metal_large_inventory_move = item_sound("metal-large-inventory-move.ogg", 0.7),
  metal_large_inventory_pickup = item_sound("metal-large-inventory-pickup.ogg", 0.8),
  metal_chest_inventory_move = item_sound("metal-chest-inventory-move.ogg", 0.6),
  metal_chest_inventory_pickup = item_sound("metal-chest-inventory-pickup.ogg", 0.6),
  metal_barrel_inventory_move = item_sound("metal-barrel-inventory-move.ogg", 0.5),
  metal_barrel_inventory_pickup = item_sound("metal-barrel-inventory-pickup.ogg", 0.5),
  electric_small_inventory_move = item_sound("electric-small-inventory-move.ogg", 1),
  electric_small_inventory_pickup = item_sound("electric-small-inventory-pickup.ogg", 0.7),
  electric_large_inventory_move = item_sound("electric-large-inventory-move.ogg", 0.7),
  electric_large_inventory_pickup = item_sound("electric-large-inventory-pickup.ogg", 0.7),
  science_inventory_move = item_sound("science-inventory-move.ogg", 0.6),
  science_inventory_pickup = item_sound("science-inventory-pickup.ogg", 0.6),
  nuclear_inventory_move = item_sound("nuclear-inventory-move.ogg", 0.6),
  nuclear_inventory_pickup = item_sound("nuclear-inventory-pickup.ogg", 0.6),
  atomic_bomb_inventory_move = item_sound("atomic-bomb-inventory-move.ogg", 0.6),
  atomic_bomb_inventory_pickup = item_sound("atomic-bomb-inventory-pickup.ogg", 0.6),
  concrete_inventory_move = item_sound("concrete-inventory-move.ogg", 0.6),
  concrete_inventory_pickup = item_sound("concrete-inventory-pickup.ogg", 0.8),
  grenade_inventory_move = item_sound("grenade-inventory-move.ogg", 1),
  grenade_inventory_pickup = item_sound("grenade-inventory-pickup.ogg", 0.8),
  mechanical_inventory_move = item_sound("mechanical-inventory-move.ogg", 0.7),
  mechanical_inventory_pickup = item_sound("mechanical-inventory-pickup.ogg", 0.8),
  inserter_inventory_move = item_sound("inserter-inventory-move.ogg", 0.8),
  inserter_inventory_pickup = item_sound("inserter-inventory-pickup.ogg", 0.8),
  steam_inventory_move = item_sound("steam-inventory-move.ogg", 0.6),
  steam_inventory_pickup = item_sound("steam-inventory-pickup.ogg", 0.4),
  robotic_inventory_move = item_sound("robotic-inventory-move.ogg", 0.8),
  robotic_inventory_pickup = item_sound("robotic-inventory-pickup.ogg", 0.5),
  roboport_inventory_move = item_sound("roboport-inventory-move.ogg", 0.45),
  roboport_inventory_pickup = item_sound("roboport-inventory-pickup.ogg", 0.35),
  explosive_inventory_move = item_sound("explosive-inventory-move.ogg", 1.0),
  explosive_inventory_pickup = item_sound("explosive-inventory-pickup.ogg", 0.8),
  plastic_inventory_move = item_sound("plastic-inventory-move.ogg", 0.5),
  plastic_inventory_pickup = item_sound("plastic-inventory-pickup.ogg", 0.7),
  module_inventory_move = item_sound("module-inventory-move.ogg", 0.8),
  module_inventory_pickup = item_sound("module-inventory-pickup.ogg", 0.8),
  raw_fish_inventory_move = item_sound("raw-fish-inventory-move.ogg", 0.7),
  raw_fish_inventory_pickup = item_sound("raw-fish-inventory-pickup.ogg", 0.7),
  repair_pack_inventory_move = item_sound("repair-pack-inventory-move.ogg", 0.7),
  repair_pack_inventory_pickup = item_sound("repair-pack-inventory-pickup.ogg", 0.7),
  blueprint_inventory_move = item_sound("blueprint-inventory-move.ogg", 0.7),
  blueprint_inventory_pickup = item_sound("blueprint-inventory-pickup.ogg", 0.7),
  planner_inventory_move = item_sound("planner-inventory-move.ogg", 0.7),
  planner_inventory_pickup = item_sound("planner-inventory-pickup.ogg", 0.7),
  vehicle_inventory_move = item_sound("vehicle-inventory-move.ogg", 0.6),
  vehicle_inventory_pickup = item_sound("vehicle-inventory-pickup.ogg", 0.4),
  fluid_inventory_move = item_sound("fluid-inventory-move.ogg", 0.6),
  fluid_inventory_pickup = item_sound("fluid-inventory-pickup.ogg", 0.5),
  locomotive_inventory_move = item_sound("locomotive-inventory-move.ogg", 0.4),
  locomotive_inventory_pickup = item_sound("locomotive-inventory-pickup.ogg", 0.4),
  coin_inventory_move = item_sound("coin-inventory-move.ogg", 0.7),
  coin_inventory_pickup = item_sound("coin-inventory-pickup.ogg", 0.7),
  spidertron_inventory_move = item_sound("spidertron-inventory-move.ogg", 0.8),
  spidertron_inventory_pickup = item_sound("spidertron-inventory-pickup.ogg", 0.5),
  landfill_inventory_move = item_sound("landfill-inventory-move.ogg", 1),
  landfill_inventory_pickup = item_sound("landfill-inventory-pickup.ogg", 0.7),
  turret_inventory_move = item_sound("turret-inventory-move.ogg", 0.6),
  turret_inventory_pickup = item_sound("turret-inventory-pickup.ogg", 0.5),
  combinator_inventory_move = item_sound("combinator-inventory-move.ogg", 0.5),
  combinator_inventory_pickup = item_sound("combinator-inventory-pickup.ogg", 0.6),
  lab_inventory_move = item_sound("lab-inventory-move.ogg", 0.8),
  lab_inventory_pickup = item_sound("lab-inventory-pickup.ogg", 0.6),
  wire_inventory_move = item_sound("wire-inventory-move.ogg", 0.8),
  wire_inventory_pickup = item_sound("wire-inventory-pickup.ogg", 0.6),
  speaker_inventory_move = item_sound("speaker-inventory-move.ogg", 0.4),
  speaker_inventory_pickup = item_sound("speaker-inventory-pickup.ogg", 0.5),
  solid_fuel_inventory_move = item_sound("solid-fuel-inventory-move.ogg", 0.7),
  solid_fuel_inventory_pickup = item_sound("solid-fuel-inventory-pickup.ogg", 0.7),
  transport_belt_inventory_move = item_sound("transport-belt-inventory-move.ogg", 0.7),
  transport_belt_inventory_pickup = item_sound("transport-belt-inventory-pickup.ogg", 0.7),
  rocket_control_inventory_move = item_sound("rocket-control-inventory-move.ogg", 0.7),
  rocket_control_inventory_pickup = item_sound("rocket-control-inventory-pickup.ogg", 0.6),
  armor_small_inventory_move = item_sound("armor-small-inventory-move.ogg", 0.7),
  armor_small_inventory_pickup = item_sound("armor-small-inventory-pickup.ogg", 0.7),
  armor_large_inventory_move = item_sound("armor-large-inventory-move.ogg", 0.7),
  armor_large_inventory_pickup = item_sound("armor-large-inventory-pickup.ogg", 0.7),
  exoskeleton_inventory_move = item_sound("exoskeleton-inventory-move.ogg", 0.6),
  exoskeleton_inventory_pickup = item_sound("exoskeleton-inventory-pickup.ogg", 0.6),
  low_density_inventory_move = item_sound("low-density-inventory-move.ogg", 0.7),
  low_density_inventory_pickup = item_sound("low-density-inventory-pickup.ogg", 0.7),
  reactor_inventory_move = item_sound("reactor-inventory-move.ogg", 0.7),
  reactor_inventory_pickup = item_sound("reactor-inventory-pickup.ogg", 0.6),
  artillery_remote_inventory_move = item_sound("artillery-remote-inventory-move.ogg", 0.7),
  artillery_inventory_move = item_sound("artillery-inventory-move.ogg", 0.6),
  artillery_inventory_pickup = item_sound("artillery-inventory-pickup.ogg", 0.4),
  artillery_large_inventory_move = item_sound("artillery-large-inventory-move.ogg", 0.5),
  artillery_large_inventory_pickup = item_sound("artillery-large-inventory-pickup.ogg", 0.4),
  drill_inventory_move = item_sound("drill-inventory-move.ogg", 0.8),
  drill_inventory_pickup = item_sound("drill-inventory-pickup.ogg", 0.8),
  fuel_cell_inventory_move = item_sound("fuel-cell-inventory-move.ogg", 0.6),
  fuel_cell_inventory_pickup = item_sound("fuel-cell-inventory-pickup.ogg", 0.5),
  pumpjack_inventory_move = item_sound("pumpjack-inventory-move.ogg", 0.6),
  pumpjack_inventory_pickup = item_sound("pumpjack-inventory-pickup.ogg", 0.6),
  train_inventory_move = item_sound("train-inventory-move.ogg", 0.5),
  train_inventory_pickup = item_sound("train-inventory-pickup.ogg", 0.4),
  rail_signal_inventory_move = item_sound("rail-signal-inventory-move.ogg", 0.8),
  rail_signal_inventory_pickup = item_sound("rail-signal-inventory-pickup.ogg", 0.8),
  energy_shield_inventory_move = item_sound("energy-shield-inventory-move.ogg", 0.4),
  energy_shield_inventory_pickup = item_sound("energy-shield-inventory-pickup.ogg", 0.4),
  sulfur_inventory_move = item_sound("sulfur-inventory-move.ogg", 0.7),
  shotgun_inventory_move = item_sound("shotgun-inventory-move.ogg", 0.8),
  flamethrower_inventory_move = item_sound("flamethrower-inventory-move.ogg", 0.6),
  mechanical_large_inventory_move = item_sound("mechanical-large-inventory-move.ogg", 0.7),
  mechanical_large_inventory_pickup = item_sound("mechanical-large-inventory-pickup.ogg", 0.8),
}

return item_sounds
