/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.util.Optional;

public class JarVersionLookupHandler {
    public static Info getInfo(String pkgName) {
        return JarVersionLookupHandler.getInfo(Package.getPackage(pkgName));
    }

    public static Info getInfo(Class<?> clazz) {
        return JarVersionLookupHandler.getInfo(clazz.getPackage());
    }

    public static Info getInfo(Package pkg) {
        return new Info(new Version(Optional.ofNullable(pkg.getSpecificationTitle()), Optional.ofNullable(pkg.getSpecificationVendor()), Optional.ofNullable(pkg.getSpecificationVersion())), new Version(Optional.ofNullable(pkg.getImplementationTitle()), Optional.ofNullable(pkg.getImplementationVendor()), Optional.ofNullable(pkg.getImplementationVersion())));
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public static Optional<String> getImplementationVersion(String pkgName) {
        String pkgVersion = Package.getPackage(pkgName).getImplementationVersion();
        return Optional.ofNullable(pkgVersion);
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public static Optional<String> getSpecificationVersion(String pkgName) {
        String pkgVersion = Package.getPackage(pkgName).getSpecificationVersion();
        return Optional.ofNullable(pkgVersion);
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public static Optional<String> getImplementationVersion(Class<?> clazz) {
        String pkgVersion = clazz.getPackage().getImplementationVersion();
        return Optional.ofNullable(pkgVersion);
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public static Optional<String> getImplementationTitle(Class<?> clazz) {
        String pkgVersion = clazz.getPackage().getImplementationTitle();
        return Optional.ofNullable(pkgVersion);
    }

    @Deprecated(forRemoval=true, since="1.20.2")
    public static Optional<String> getSpecificationVersion(Class<?> clazz) {
        String pkgVersion = clazz.getPackage().getSpecificationVersion();
        return Optional.ofNullable(pkgVersion);
    }

    public record Info(Version spec, Version impl) {
    }

    public record Version(Optional<String> title, Optional<String> vendor, Optional<String> version) {
        @Override
        public String toString() {
            return "[title=" + (String)this.title.orElse(null) + ", vendor=" + (String)this.vendor.orElse(null) + ", version=" + (String)this.version.orElse(null) + "]";
        }
    }
}

