/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public interface ItemOwner {
    public Level level();

    public Vec3 position();

    public float getVisualRotationYInDegrees();

    @Nullable
    default public LivingEntity asLivingEntity() {
        return null;
    }

    public static ItemOwner offsetFromOwner(ItemOwner $$0, Vec3 $$1) {
        return new OffsetFromOwner($$0, $$1);
    }

    public record OffsetFromOwner(ItemOwner owner, Vec3 offset) implements ItemOwner
    {
        @Override
        public Level level() {
            return this.owner.level();
        }

        @Override
        public Vec3 position() {
            return this.owner.position().add(this.offset);
        }

        @Override
        public float getVisualRotationYInDegrees() {
            return this.owner.getVisualRotationYInDegrees();
        }

        @Override
        @Nullable
        public LivingEntity asLivingEntity() {
            return this.owner.asLivingEntity();
        }
    }
}

