/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import net.minecraftforge.fml.loading.FMLLoader;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.VersionRange;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VersionSupportMatrix {
    private static final Map<String, List<ArtifactVersion>> OVERRIDE_VERSIONS = "1.21.1".equals(FMLLoader.versionInfo().mcVersion()) ? Map.ofEntries(VersionSupportMatrix.entry("languageloader.javafml", "51"), VersionSupportMatrix.entry("mod.minecraft", "1.21"), VersionSupportMatrix.entry("mod.forge", "51.0.33")) : Collections.emptyMap();

    @Deprecated(forRemoval=true, since="1.21.1")
    public static boolean testVersionSupportMatrix(VersionRange declaredRange, String lookupId, String type, BiPredicate<String, VersionRange> standardLookup) {
        if (standardLookup.test(lookupId, declaredRange)) {
            return true;
        }
        return VersionSupportMatrix.testVersionSupportMatrix(declaredRange, lookupId, type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean testVersionSupportMatrix(VersionRange declaredRange, String lookupId, String type) {
        if (OVERRIDE_VERSIONS.isEmpty()) {
            return false;
        }
        List<ArtifactVersion> custom = OVERRIDE_VERSIONS.get(type + "." + lookupId);
        if (custom == null) return false;
        if (!custom.stream().anyMatch(arg_0 -> ((VersionRange)declaredRange).containsVersion(arg_0))) return false;
        return true;
    }

    private static Map.Entry<String, List<ArtifactVersion>> entry(String typeAndLookupId, String declaredRange) {
        return Map.entry(typeAndLookupId, List.of(new DefaultArtifactVersion(declaredRange)));
    }

    private static Map.Entry<String, List<ArtifactVersion>> entry(String typeAndLookupId, List<String> declaredRanges) {
        return Map.entry(typeAndLookupId, declaredRanges.stream().map(DefaultArtifactVersion::new).map(it -> it).toList());
    }
}

