/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.event;

import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.gui.render.state.pip.PictureInPictureRenderState;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraftforge.eventbus.api.bus.EventBus;
import net.minecraftforge.eventbus.api.event.MutableEvent;
import net.minecraftforge.eventbus.api.event.characteristic.SelfDestructing;
import org.jetbrains.annotations.ApiStatus;

public final class RegisterPictureInPictureRendererEvent
extends MutableEvent
implements SelfDestructing {
    public static final EventBus<RegisterPictureInPictureRendererEvent> BUS = EventBus.create(RegisterPictureInPictureRendererEvent.class);
    private final List<PictureInPictureRenderer<?>> renderers;
    private final MultiBufferSource.BufferSource bufferSource;
    private final ImmutableMap.Builder<Class<? extends PictureInPictureRenderState>, PictureInPictureRenderer<?>> builder;

    @ApiStatus.Internal
    public RegisterPictureInPictureRendererEvent(List<PictureInPictureRenderer<?>> renderers, MultiBufferSource.BufferSource bufferSource, ImmutableMap.Builder<Class<? extends PictureInPictureRenderState>, PictureInPictureRenderer<?>> builder) {
        this.renderers = renderers;
        this.bufferSource = bufferSource;
        this.builder = builder;
    }

    public MultiBufferSource.BufferSource getBufferSource() {
        return this.bufferSource;
    }

    public void register(PictureInPictureRenderer<?> renderer) {
        HashSet seen = HashSet.newHashSet(this.renderers.size());
        for (PictureInPictureRenderer<?> r : this.renderers) {
            seen.add(r.getRenderStateClass());
        }
        Class key = renderer.getRenderStateClass();
        if (seen.add(key)) {
            this.builder.put((Object)key, renderer);
        }
    }
}

