/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.StanzaCollector;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpoint;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.util.rce.RemoteConnectionException;
import org.jxmpp.jid.Jid;

public abstract class SmackException
extends Exception {
    private static final long serialVersionUID = 1844674365368214458L;

    protected SmackException(Throwable wrappedThrowable) {
        super(wrappedThrowable);
    }

    protected SmackException(String message) {
        super(message);
    }

    protected SmackException(String message, Throwable wrappedThrowable) {
        super(message, wrappedThrowable);
    }

    protected SmackException() {
    }

    public static class SmackCertificateException
    extends SmackException {
        private static final long serialVersionUID = 1L;
        private final CertificateException certificateException;

        public SmackCertificateException(CertificateException certificateException) {
            this.certificateException = certificateException;
        }

        public CertificateException getCertificateException() {
            return this.certificateException;
        }
    }

    public static class SmackSaslException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        public SmackSaslException(Exception exception) {
            super(exception);
        }

        public SmackSaslException(String message) {
            super(message);
        }

        public SmackSaslException(String message, Exception exception) {
            super(message, exception);
        }
    }

    public static class SmackMessageException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        public SmackMessageException(String message) {
            super(message);
        }
    }

    public static class SmackWrappedException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        public SmackWrappedException(Exception exception) {
            super(exception);
        }

        public SmackWrappedException(String message, Exception exception) {
            super(message, exception);
        }
    }

    public static class ResourceBindingNotOfferedException
    extends SmackException {
        private static final long serialVersionUID = 2346934138253437571L;

        public ResourceBindingNotOfferedException() {
            super("Resource binding was not offered by server");
        }
    }

    public static class FeatureNotSupportedException
    extends SmackException {
        private static final long serialVersionUID = 4713404802621452016L;
        private final String feature;
        private final Jid jid;

        public FeatureNotSupportedException(String feature) {
            this(feature, (Jid)null);
        }

        public FeatureNotSupportedException(String feature, Jid jid) {
            super(feature + " not supported" + (jid == null ? "" : " by '" + jid + "'"));
            this.jid = jid;
            this.feature = feature;
        }

        public String getFeature() {
            return this.feature;
        }

        public Jid getJid() {
            return this.jid;
        }
    }

    public static final class NoEndpointsDiscoveredException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;
        private final List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> lookupFailures;

        private NoEndpointsDiscoveredException(String message, List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> lookupFailures) {
            super(message);
            this.lookupFailures = Collections.unmodifiableList(lookupFailures);
        }

        public List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> getLookupFailures() {
            return this.lookupFailures;
        }

        public static NoEndpointsDiscoveredException from(List<XmppClientToServerTransport.LookupConnectionEndpointsFailed> lookupFailures) {
            StringBuilder sb = new StringBuilder();
            if (lookupFailures.isEmpty()) {
                sb.append("No endpoint lookup finished within the timeout");
            } else {
                sb.append("No endpoints could be discovered due the following lookup failures: ");
                StringUtils.appendTo(lookupFailures, sb);
            }
            return new NoEndpointsDiscoveredException(sb.toString(), lookupFailures);
        }
    }

    public static final class EndpointConnectionException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;
        private final List<RemoteConnectionEndpointLookupFailure> lookupFailures;
        private final List<? extends RemoteConnectionException<?>> connectionExceptions;

        private EndpointConnectionException(String message, List<RemoteConnectionEndpointLookupFailure> lookupFailures, List<? extends RemoteConnectionException<?>> connectionExceptions) {
            super(message);
            assert (!lookupFailures.isEmpty() || !connectionExceptions.isEmpty());
            this.lookupFailures = lookupFailures;
            this.connectionExceptions = connectionExceptions;
        }

        public static EndpointConnectionException from(List<RemoteConnectionEndpointLookupFailure> lookupFailures, List<? extends RemoteConnectionException<?>> connectionExceptions) {
            StringBuilder sb = new StringBuilder(256);
            if (!lookupFailures.isEmpty()) {
                sb.append("Could not lookup the following endpoints: ");
                StringUtils.appendTo(lookupFailures, sb);
            }
            if (!connectionExceptions.isEmpty()) {
                sb.append("The following addresses failed: ");
                StringUtils.appendTo(connectionExceptions, sb, rce -> sb.append(rce.getErrorMessage()));
            }
            return new EndpointConnectionException(sb.toString(), lookupFailures, connectionExceptions);
        }

        public List<RemoteConnectionEndpointLookupFailure> getLookupFailures() {
            return this.lookupFailures;
        }

        public List<? extends RemoteConnectionException<? extends RemoteConnectionEndpoint>> getConnectionExceptions() {
            return this.connectionExceptions;
        }
    }

    public static final class GenericConnectionException
    extends ConnectionException {
        private static final long serialVersionUID = 1L;

        @Deprecated
        public GenericConnectionException(Throwable wrappedThrowable) {
            super(wrappedThrowable);
        }
    }

    public static abstract class ConnectionException
    extends SmackException {
        private static final long serialVersionUID = 1L;

        protected ConnectionException(Throwable wrappedThrowable) {
            super(wrappedThrowable);
        }

        protected ConnectionException(String message) {
            super(message);
        }
    }

    public static class SecurityNotPossibleException
    extends SmackException {
        private static final long serialVersionUID = -6836090872690331336L;

        public SecurityNotPossibleException(String message) {
            super(message);
        }
    }

    public static class SecurityRequiredByServerException
    extends SecurityRequiredException {
        private static final long serialVersionUID = 8268148813117631819L;

        public SecurityRequiredByServerException() {
            super("SSL/TLS required by server but disabled in client");
        }
    }

    public static class SecurityRequiredByClientException
    extends SecurityRequiredException {
        private static final long serialVersionUID = 2395325821201543159L;

        public SecurityRequiredByClientException() {
            super("SSL/TLS required by client but not supported by server");
        }
    }

    public static abstract class SecurityRequiredException
    extends SmackException {
        private static final long serialVersionUID = 384291845029773545L;

        public SecurityRequiredException(String message) {
            super(message);
        }
    }

    public static class IllegalStateChangeException
    extends SmackException {
        private static final long serialVersionUID = -1766023961577168927L;
    }

    public static class NotConnectedException
    extends SmackException {
        private static final long serialVersionUID = 9197980400776001173L;

        public NotConnectedException() {
            this((String)null);
        }

        public NotConnectedException(String optionalHint) {
            super("Client is not, or no longer, connected." + (optionalHint != null ? ' ' + optionalHint : ""));
        }

        public NotConnectedException(XMPPConnection connection, String details) {
            super("The connection " + connection.toString() + " is no longer connected. " + details);
        }

        public NotConnectedException(XMPPConnection connection, StanzaFilter stanzaFilter) {
            super("The connection " + connection + " is no longer connected while waiting for response with " + stanzaFilter);
        }

        public NotConnectedException(XMPPConnection connection, StanzaFilter stanzaFilter, Exception connectionException) {
            super("The connection " + connection + " is no longer connected while waiting for response with " + stanzaFilter + " because of " + connectionException, connectionException);
        }
    }

    public static class AlreadyConnectedException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049135231L;

        public AlreadyConnectedException() {
            super("Client is already connected");
        }
    }

    public static class AlreadyLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 5011416918049935231L;

        public AlreadyLoggedInException() {
            super("Client is already logged in");
        }
    }

    public static class NotLoggedInException
    extends SmackException {
        private static final long serialVersionUID = 3216216839100019278L;

        public NotLoggedInException() {
            super("Client is not logged in");
        }
    }

    public static final class NoResponseException
    extends SmackException {
        private static final long serialVersionUID = -6523363748984543636L;
        private final StanzaFilter filter;

        private NoResponseException(String message) {
            this(message, (StanzaFilter)null);
        }

        private NoResponseException(String message, StanzaFilter filter) {
            super(message);
            this.filter = filter;
        }

        public StanzaFilter getFilter() {
            return this.filter;
        }

        public static NoResponseException newWith(XMPPConnection connection, String waitingFor) {
            StringBuilder sb = NoResponseException.getWaitingFor(connection);
            sb.append(" While waiting for ").append(waitingFor);
            sb.append(" [").append(connection).append(']');
            return new NoResponseException(sb.toString());
        }

        public static NoResponseException newWith(long timeout, StanzaCollector collector, boolean stanzaCollectorCancelled) {
            return NoResponseException.newWith(timeout, collector.getStanzaFilter(), stanzaCollectorCancelled);
        }

        public static NoResponseException newWith(XMPPConnection connection, StanzaFilter filter) {
            return NoResponseException.newWith(connection.getReplyTimeout(), filter, false);
        }

        public static NoResponseException newWith(long timeout, StanzaFilter filter, boolean stanzaCollectorCancelled) {
            StringBuilder sb = NoResponseException.getWaitingFor(timeout);
            if (stanzaCollectorCancelled) {
                sb.append(" StanzaCollector has been cancelled.");
            }
            sb.append(" Waited for response using: ");
            if (filter != null) {
                sb.append(filter.toString());
            } else {
                sb.append("No filter used or filter was 'null'");
            }
            sb.append('.');
            return new NoResponseException(sb.toString(), filter);
        }

        private static StringBuilder getWaitingFor(XMPPConnection connection) {
            return NoResponseException.getWaitingFor(connection.getReplyTimeout());
        }

        private static StringBuilder getWaitingFor(long replyTimeout) {
            StringBuilder sb = new StringBuilder(256);
            sb.append("No response received within reply timeout. Timeout was " + replyTimeout + "ms (~" + replyTimeout / 1000L + "s).");
            return sb;
        }
    }
}

