/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtcp.RtcpHeaderBuilder;
import org.jitsi.rtp.rtcp.RtcpPacket;
import org.jitsi.rtp.rtcp.RtcpReportBlock;
import org.jitsi.rtp.rtcp.RtcpSrPacketBuilder;
import org.jitsi.rtp.rtcp.SenderInfoBuilder;
import org.jitsi.rtp.rtcp.SenderInfoParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0015\u001a\u00020\u0000H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000R\u001f\u0010\t\u001a\u00060\nR\u00020\u00008FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000e\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "Lorg/jitsi/rtp/rtcp/RtcpPacket;", "buffer", "", "offset", "", "length", "<init>", "([BII)V", "senderInfo", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket$SenderInfo;", "getSenderInfo", "()Lorg/jitsi/rtp/rtcp/RtcpSrPacket$SenderInfo;", "senderInfo$delegate", "Lkotlin/Lazy;", "reportBlocks", "", "Lorg/jitsi/rtp/rtcp/RtcpReportBlock;", "getReportBlocks", "()Ljava/util/List;", "reportBlocks$delegate", "clone", "cloneWithoutReportBlocks", "SenderInfo", "Companion", "rtp"})
@SourceDebugExtension(value={"SMAP\nRtcpSrPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RtcpSrPacket.kt\norg/jitsi/rtp/rtcp/RtcpSrPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,236:1\n1563#2:237\n1634#2,3:238\n*S KotlinDebug\n*F\n+ 1 RtcpSrPacket.kt\norg/jitsi/rtp/rtcp/RtcpSrPacket\n*L\n147#1:237\n147#1:238,3\n*E\n"})
public final class RtcpSrPacket
extends RtcpPacket {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy senderInfo$delegate;
    @NotNull
    private final Lazy reportBlocks$delegate;
    public static final int PT = 200;
    public static final int SENDER_INFO_OFFSET = 8;
    public static final int REPORT_BLOCKS_OFFSET = 28;

    public RtcpSrPacket(@NotNull byte[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super(buffer, offset, length);
        this.senderInfo$delegate = LazyKt.lazy(() -> RtcpSrPacket.senderInfo_delegate$lambda$0(this));
        this.reportBlocks$delegate = LazyKt.lazy(() -> RtcpSrPacket.reportBlocks_delegate$lambda$0(this, buffer, offset));
    }

    @NotNull
    public final SenderInfo getSenderInfo() {
        Lazy lazy = this.senderInfo$delegate;
        return (SenderInfo)lazy.getValue();
    }

    @NotNull
    public final List<RtcpReportBlock> getReportBlocks() {
        Lazy lazy = this.reportBlocks$delegate;
        return (List)lazy.getValue();
    }

    @Override
    @NotNull
    public RtcpSrPacket clone() {
        return new RtcpSrPacket(this.cloneBuffer(0), 0, this.length);
    }

    @NotNull
    public final RtcpSrPacket cloneWithoutReportBlocks() {
        return new RtcpSrPacketBuilder(new RtcpHeaderBuilder(0, false, 0, 0, 0, this.getSenderSsrc(), 27, null), new SenderInfoBuilder(this.getSenderInfo().getNtpTimestampMsw(), this.getSenderInfo().getNtpTimestampLsw(), this.getSenderInfo().getRtpTimestamp(), this.getSenderInfo().getSendersPacketCount(), this.getSenderInfo().getSendersOctetCount()), null, 4, null).build();
    }

    private static final SenderInfo senderInfo_delegate$lambda$0(RtcpSrPacket this$0) {
        return this$0.new SenderInfo();
    }

    /*
     * WARNING - void declaration
     */
    private static final List reportBlocks_delegate$lambda$0(RtcpSrPacket this$0, byte[] $buffer, int $offset) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)this$0.getReportCount());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(RtcpReportBlock.Companion.fromBuffer($buffer, $offset + 28 + it * 24));
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpSrPacket$Companion;", "", "<init>", "()V", "PT", "", "SENDER_INFO_OFFSET", "REPORT_BLOCKS_OFFSET", "rtp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0014\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R$\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\f\u0010\u0007\"\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0007\"\u0004\b\u0011\u0010\u000eR$\u0010\u0012\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0007\"\u0004\b\u0014\u0010\u000eR\u001b\u0010\u0015\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0016\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/rtp/rtcp/RtcpSrPacket$SenderInfo;", "", "<init>", "(Lorg/jitsi/rtp/rtcp/RtcpSrPacket;)V", "ntpTimestampMsw", "", "getNtpTimestampMsw", "()J", "ntpTimestampLsw", "getNtpTimestampLsw", "value", "rtpTimestamp", "getRtpTimestamp", "setRtpTimestamp", "(J)V", "sendersPacketCount", "getSendersPacketCount", "setSendersPacketCount", "sendersOctetCount", "getSendersOctetCount", "setSendersOctetCount", "compactedNtpTimestamp", "getCompactedNtpTimestamp", "compactedNtpTimestamp$delegate", "Lkotlin/Lazy;", "rtp"})
    public final class SenderInfo {
        private final long ntpTimestampMsw;
        private final long ntpTimestampLsw;
        @NotNull
        private final Lazy compactedNtpTimestamp$delegate;

        public SenderInfo() {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            this.ntpTimestampMsw = SenderInfoParser.Companion.getNtpTimestampMsw(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8);
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            this.ntpTimestampLsw = SenderInfoParser.Companion.getNtpTimestampLsw(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8);
            this.compactedNtpTimestamp$delegate = LazyKt.lazy(() -> SenderInfo.compactedNtpTimestamp_delegate$lambda$0(this));
        }

        public final long getNtpTimestampMsw() {
            return this.ntpTimestampMsw;
        }

        public final long getNtpTimestampLsw() {
            return this.ntpTimestampLsw;
        }

        public final long getRtpTimestamp() {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            return SenderInfoParser.Companion.getRtpTimestamp(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8);
        }

        public final void setRtpTimestamp(long value) {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            SenderInfoParser.Companion.setRtpTimestamp(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8, value);
        }

        public final long getSendersPacketCount() {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            return SenderInfoParser.Companion.getSendersPacketCount(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8);
        }

        public final void setSendersPacketCount(long value) {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            SenderInfoParser.Companion.setSendersPacketCount(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8, value);
        }

        public final long getSendersOctetCount() {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            return SenderInfoParser.Companion.getSendersOctetCount(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8);
        }

        public final void setSendersOctetCount(long value) {
            Intrinsics.checkNotNullExpressionValue((Object)RtcpSrPacket.this.buffer, (String)"buffer");
            SenderInfoParser.Companion.setSendersOctetCount(RtcpSrPacket.this.buffer, RtcpSrPacket.this.offset + 8, value);
        }

        public final long getCompactedNtpTimestamp() {
            Lazy lazy = this.compactedNtpTimestamp$delegate;
            return ((Number)lazy.getValue()).longValue();
        }

        private static final long compactedNtpTimestamp_delegate$lambda$0(SenderInfo this$0) {
            return UnsignedKt.toPositiveLong((this$0.ntpTimestampMsw & 0xFFFFL) << 16 | this$0.ntpTimestampLsw >>> 16);
        }
    }
}

