/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp.rtp.header_extensions;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.header_extensions.HeaderExtensionParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\u0018\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0007R\u0014\u0010\u000b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jitsi/rtp/rtp/header_extensions/TwoByteHeaderExtensionParser;", "Lorg/jitsi/rtp/rtp/header_extensions/HeaderExtensionParser;", "<init>", "()V", "headerExtensionLabel", "", "getHeaderExtensionLabel", "()I", "HEADER_EXTENSION_MASK", "extHeaderSizeBytes", "getExtHeaderSizeBytes", "minimumExtSizeBytes", "getMinimumExtSizeBytes", "isMatchingType", "", "profileField", "getId", "buf", "", "offset", "writeIdAndLength", "", "id", "dataLength", "getDataLengthBytes", "rtp"})
public final class TwoByteHeaderExtensionParser
extends HeaderExtensionParser {
    @NotNull
    public static final TwoByteHeaderExtensionParser INSTANCE = new TwoByteHeaderExtensionParser();
    private static final int headerExtensionLabel = 4096;
    private static final int HEADER_EXTENSION_MASK = 65520;
    private static final int extHeaderSizeBytes = 2;
    private static final int minimumExtSizeBytes = 2;

    private TwoByteHeaderExtensionParser() {
    }

    @Override
    public int getHeaderExtensionLabel() {
        return headerExtensionLabel;
    }

    @Override
    public int getExtHeaderSizeBytes() {
        return extHeaderSizeBytes;
    }

    @Override
    public int getMinimumExtSizeBytes() {
        return minimumExtSizeBytes;
    }

    @Override
    public boolean isMatchingType(int profileField) {
        return (profileField & 0xFFF0) == this.getHeaderExtensionLabel();
    }

    @Override
    public int getId(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return buf[offset];
    }

    @Override
    public void writeIdAndLength(int id, int dataLength, @NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        if (!(1 <= id ? id < 256 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= dataLength ? dataLength < 256 : false)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        buf[offset] = (byte)id;
        buf[offset + 1] = (byte)dataLength;
    }

    @Override
    public int getDataLengthBytes(@NotNull byte[] buf, int offset) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        return UnsignedKt.toPositiveInt(buf[offset + 1]);
    }
}

