/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.bandwidthestimation2;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\nJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\b\u001a\u00020\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/IntervalBudget;", "", "initialTargetRateKbps", "", "canBuildUpUnderuse", "", "<init>", "(IZ)V", "targetRateKbps", "maxBytesInBudget", "", "bytesRemaining", "setTargetRateKbps", "", "increaseBudget", "deltaTimeMs", "useBudget", "bytes", "budgetRatio", "", "Companion", "jitsi-media-transform"})
public final class IntervalBudget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean canBuildUpUnderuse;
    private int targetRateKbps;
    private long maxBytesInBudget;
    private long bytesRemaining;
    private static final long kWindowMs = 500L;

    public IntervalBudget(int initialTargetRateKbps, boolean canBuildUpUnderuse) {
        this.canBuildUpUnderuse = canBuildUpUnderuse;
        this.setTargetRateKbps(initialTargetRateKbps);
    }

    public /* synthetic */ IntervalBudget(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    public final void setTargetRateKbps(int targetRateKbps) {
        this.targetRateKbps = targetRateKbps;
        this.maxBytesInBudget = 500L * (long)targetRateKbps / (long)8;
        this.bytesRemaining = Math.min(Math.max(-this.maxBytesInBudget, this.bytesRemaining), this.maxBytesInBudget);
    }

    public final void increaseBudget(long deltaTimeMs) {
        long bytes = (long)this.targetRateKbps * deltaTimeMs / (long)8;
        this.bytesRemaining = this.bytesRemaining < 0L || this.canBuildUpUnderuse ? Math.min(this.bytesRemaining + bytes, this.maxBytesInBudget) : Math.min(bytes, this.maxBytesInBudget);
    }

    public final void useBudget(long bytes) {
        this.bytesRemaining = Math.max(this.bytesRemaining - bytes, -this.maxBytesInBudget);
    }

    public final long bytesRemaining() {
        return Math.max(0L, this.bytesRemaining);
    }

    public final double budgetRatio() {
        if (this.maxBytesInBudget == 0L) {
            return 0.0;
        }
        return (double)this.bytesRemaining / (double)this.maxBytesInBudget;
    }

    public final int targetRateKbps() {
        return this.targetRateKbps;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jitsi/nlj/rtp/bandwidthestimation2/IntervalBudget$Companion;", "", "<init>", "()V", "kWindowMs", "", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

