/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.stats.PacketStreamStats;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.util.UtilKt;
import org.jitsi.utils.OrderedJsonObject;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0010H\u0016J\u0006\u0010\u0011\u001a\u00020\u0012J\r\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0006\u0010\u001b\u001a\u00020\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jitsi/nlj/transform/node/PacketStreamStatsNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "direction", "", "packetStreamStats", "Lorg/jitsi/nlj/stats/PacketStreamStats;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Ljava/lang/String;Lorg/jitsi/nlj/stats/PacketStreamStats;)V", "observe", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "trace", "f", "Lkotlin/Function0;", "snapshot", "Lorg/jitsi/nlj/stats/PacketStreamStats$Snapshot;", "getBitrate", "Lorg/jitsi/nlj/util/Bandwidth;", "getBitrate-rlWvAKk", "()J", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "createNewNode", "Companion", "jitsi-media-transform"})
public final class PacketStreamStatsNode
extends ObserverNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final String direction;
    @NotNull
    private final PacketStreamStats packetStreamStats;
    private static final TimeSeriesLogger timeseriesLogger = TimeSeriesLogger.getTimeSeriesLogger(PacketStreamStatsNode.class);

    public PacketStreamStatsNode(@NotNull DiagnosticContext diagnosticContext, @NotNull String direction, @NotNull PacketStreamStats packetStreamStats) {
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        Intrinsics.checkNotNullParameter((Object)packetStreamStats, (String)"packetStreamStats");
        super("PacketStreamStats");
        this.diagnosticContext = diagnosticContext;
        this.direction = direction;
        this.packetStreamStats = packetStreamStats;
    }

    public /* synthetic */ PacketStreamStatsNode(DiagnosticContext diagnosticContext, String string, PacketStreamStats packetStreamStats, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            packetStreamStats = new PacketStreamStats();
        }
        this(diagnosticContext, string, packetStreamStats);
    }

    @Override
    protected void observe(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        this.packetStreamStats.update(packetInfo.getPacket().length);
    }

    @Override
    public void trace(@NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        f.invoke();
    }

    @NotNull
    public final PacketStreamStats.Snapshot snapshot() {
        PacketStreamStats.Snapshot snapshot;
        PacketStreamStats.Snapshot it = snapshot = this.packetStreamStats.snapshot();
        boolean bl = false;
        if (timeseriesLogger.isTraceEnabled()) {
            timeseriesLogger.trace((Map)this.diagnosticContext.makeTimeSeriesPoint(this.direction + "_packet_stream_stats").addField("bitrate_bps", (Object)it.getBitrate-rlWvAKk()).addField("packet_rate", (Object)it.getPacketRate()));
        }
        return snapshot;
    }

    public final long getBitrate-rlWvAKk() {
        return this.snapshot().getBitrate-rlWvAKk();
    }

    @Override
    @NotNull
    public OrderedJsonObject statsJson() {
        return UtilKt.appendAll(super.statsJson(), this.packetStreamStats.snapshot().toJson());
    }

    @Override
    @NotNull
    public NodeStatsBlock getNodeStats() {
        NodeStatsBlock nodeStatsBlock;
        NodeStatsBlock $this$getNodeStats_u24lambda_u240 = nodeStatsBlock = super.getNodeStats();
        boolean bl = false;
        PacketStreamStats.Snapshot snapshot = this.packetStreamStats.snapshot();
        $this$getNodeStats_u24lambda_u240.addNumber("bitrate_bps", snapshot.getBitrate-rlWvAKk());
        $this$getNodeStats_u24lambda_u240.addNumber("packet_rate", snapshot.getPacketRate());
        $this$getNodeStats_u24lambda_u240.addNumber("bytes_sent", snapshot.getBytes());
        $this$getNodeStats_u24lambda_u240.addNumber("packets_sent", snapshot.getPackets());
        return nodeStatsBlock;
    }

    @NotNull
    public final PacketStreamStatsNode createNewNode() {
        return new PacketStreamStatsNode(this.diagnosticContext, this.direction, this.packetStreamStats);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jitsi/nlj/transform/node/PacketStreamStatsNode$Companion;", "", "<init>", "()V", "timeseriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

