/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.stats.JitterStats;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.MediaType;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 )2\u00020\u0001:\u0002)*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u0004\u0018\u00010\u001fJ\u0006\u0010!\u001a\u00020\u001fJ\u001e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u001aJ\b\u0010(\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats;", "", "ssrc", "", "baseSeqNum", "", "mediaType", "Lorg/jitsi/utils/MediaType;", "<init>", "(JILorg/jitsi/utils/MediaType;)V", "statsLock", "maxSeqNum", "seqNumCycles", "numExpectedPackets", "getNumExpectedPackets", "()I", "cumulativePacketsLost", "outOfOrderPacketCount", "jitterStats", "Lorg/jitsi/nlj/stats/JitterStats;", "numReceivedPackets", "numReceivedBytes", "durationActive", "Ljava/time/Duration;", "kotlin.jvm.PlatformType", "lastPacketReceivedTime", "Ljava/time/Instant;", "activitySinceLastSnapshot", "", "probation", "createSnapshot", "Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Snapshot;", "getSnapshotIfActive", "getSnapshot", "packetReceived", "", "packet", "Lorg/jitsi/rtp/rtp/RtpPacket;", "packetSentTimestamp", "packetReceivedTime", "maybeResetProbation", "Companion", "Snapshot", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nIncomingStatisticsTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IncomingStatisticsTracker.kt\norg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1#2:343\n*E\n"})
public final class IncomingSsrcStats {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long ssrc;
    private int baseSeqNum;
    @NotNull
    private final MediaType mediaType;
    @NotNull
    private Object statsLock;
    private int maxSeqNum;
    private int seqNumCycles;
    private int cumulativePacketsLost;
    private int outOfOrderPacketCount;
    @NotNull
    private final JitterStats jitterStats;
    private int numReceivedPackets;
    private int numReceivedBytes;
    private Duration durationActive;
    @Nullable
    private Instant lastPacketReceivedTime;
    private boolean activitySinceLastSnapshot;
    private int probation;
    public static final int MAX_OOO_AMOUNT = 100;
    public static final int INITIAL_MIN_SEQUENTIAL = 2;
    public static final int MAX_DROPOUT = 3000;
    @NotNull
    private static final Duration ACTIVITY_TIMEOUT;

    public IncomingSsrcStats(long ssrc, int baseSeqNum, @NotNull MediaType mediaType) {
        Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
        this.ssrc = ssrc;
        this.baseSeqNum = baseSeqNum;
        this.mediaType = mediaType;
        this.statsLock = new Object();
        this.maxSeqNum = this.baseSeqNum;
        this.jitterStats = new JitterStats();
        this.durationActive = Duration.ZERO;
        this.probation = 2;
    }

    private final int getNumExpectedPackets() {
        return Companion.calculateExpectedPacketCount(0, this.baseSeqNum, this.seqNumCycles, this.maxSeqNum);
    }

    private final Snapshot createSnapshot() {
        int n = this.getNumExpectedPackets();
        double d = this.jitterStats.getJitter();
        Duration duration = this.durationActive;
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"durationActive");
        return new Snapshot(this.numReceivedPackets, this.numReceivedBytes, this.maxSeqNum, this.seqNumCycles, n, this.cumulativePacketsLost, d, duration, this.mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Snapshot getSnapshotIfActive() {
        Object object = this.statsLock;
        synchronized (object) {
            block4: {
                boolean bl = false;
                if (this.activitySinceLastSnapshot) break block4;
                Snapshot snapshot = null;
                return snapshot;
            }
            this.activitySinceLastSnapshot = false;
            Snapshot snapshot = this.createSnapshot();
            return snapshot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Snapshot getSnapshot() {
        Snapshot snapshot;
        Object object = this.statsLock;
        synchronized (object) {
            boolean bl = false;
            snapshot = this.createSnapshot();
        }
        return snapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void packetReceived(@NotNull RtpPacket packet, @NotNull Instant packetSentTimestamp, @NotNull Instant packetReceivedTime) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Intrinsics.checkNotNullParameter((Object)packetSentTimestamp, (String)"packetSentTimestamp");
        Intrinsics.checkNotNullParameter((Object)packetReceivedTime, (String)"packetReceivedTime");
        int packetSequenceNumber = packet.getSequenceNumber();
        Object object = this.statsLock;
        synchronized (object) {
            Duration timeSincePreviousPacket;
            boolean bl = false;
            this.activitySinceLastSnapshot = true;
            int n = this.numReceivedPackets;
            this.numReceivedPackets = n + 1;
            this.numReceivedBytes += packet.length;
            if (this.lastPacketReceivedTime != null && (timeSincePreviousPacket = Duration.between(this.lastPacketReceivedTime, packetReceivedTime)).compareTo(ACTIVITY_TIMEOUT) < 0) {
                this.durationActive = this.durationActive.plus(timeSincePreviousPacket);
            }
            this.lastPacketReceivedTime = packetReceivedTime;
            if (RtpUtilsKt.isNewerThan((int)packetSequenceNumber, (int)this.maxSeqNum)) {
                if (RtpUtilsKt.isNextAfter((int)packetSequenceNumber, (int)this.maxSeqNum)) {
                    if (this.probation > 0) {
                        n = this.probation;
                        this.probation = n + -1;
                    }
                } else {
                    n = RtpUtilsKt.numPacketsTo((int)this.maxSeqNum, (int)packetSequenceNumber);
                    boolean bl2 = 0 <= n ? n < 3001 : false;
                    if (bl2) {
                        this.cumulativePacketsLost += RtpUtilsKt.numPacketsTo((int)this.maxSeqNum, (int)packetSequenceNumber);
                        this.maybeResetProbation();
                    }
                }
                if (RtpUtilsKt.rolledOverTo((int)this.maxSeqNum, (int)packetSequenceNumber)) {
                    n = this.seqNumCycles;
                    this.seqNumCycles = n + 1;
                }
                this.maxSeqNum = packetSequenceNumber;
            } else {
                n = RtpUtilsKt.numPacketsTo((int)packetSequenceNumber, (int)this.maxSeqNum);
                boolean bl3 = 0 <= n ? n < 101 : false;
                if (bl3) {
                    n = this.cumulativePacketsLost;
                    this.cumulativePacketsLost = n + -1;
                }
                n = this.outOfOrderPacketCount;
                this.outOfOrderPacketCount = n + 1;
                this.maybeResetProbation();
            }
            this.jitterStats.addPacket(packetSentTimestamp, packetReceivedTime);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void maybeResetProbation() {
        if (this.probation > 0) {
            this.probation = 1;
        }
    }

    static {
        Duration duration = Duration.ofMillis(1000L);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        ACTIVITY_TIMEOUT = duration;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Companion;", "", "<init>", "()V", "MAX_OOO_AMOUNT", "", "INITIAL_MIN_SEQUENTIAL", "MAX_DROPOUT", "ACTIVITY_TIMEOUT", "Ljava/time/Duration;", "getACTIVITY_TIMEOUT", "()Ljava/time/Duration;", "calculateExpectedPacketCount", "baseSeqNumCycles", "baseSeqNum", "currCycles", "currSeqNum", "jitsi-media-transform"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Duration getACTIVITY_TIMEOUT() {
            return ACTIVITY_TIMEOUT;
        }

        public final int calculateExpectedPacketCount(int baseSeqNumCycles, int baseSeqNum, int currCycles, int currSeqNum) {
            int baseExtended = (baseSeqNumCycles << 16) + baseSeqNum;
            int maxExtended = (currCycles << 16) + currSeqNum;
            return maxExtended - baseExtended + 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0000J\u0006\u0010 \u001a\u00020!J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\nH\u00c6\u0003J\t\u0010)\u001a\u00020\fH\u00c6\u0003J\t\u0010*\u001a\u00020\u000eH\u00c6\u0003Jc\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u00020\u0003H\u00d6\u0001J\t\u00100\u001a\u000201H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00062"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/IncomingSsrcStats$Snapshot;", "", "numReceivedPackets", "", "numReceivedBytes", "maxSeqNum", "seqNumCycles", "numExpectedPackets", "cumulativePacketsLost", "jitter", "", "durationActive", "Ljava/time/Duration;", "mediaType", "Lorg/jitsi/utils/MediaType;", "<init>", "(IIIIIIDLjava/time/Duration;Lorg/jitsi/utils/MediaType;)V", "getNumReceivedPackets", "()I", "getNumReceivedBytes", "getMaxSeqNum", "getSeqNumCycles", "getNumExpectedPackets", "getCumulativePacketsLost", "getJitter", "()D", "getDurationActive", "()Ljava/time/Duration;", "getMediaType", "()Lorg/jitsi/utils/MediaType;", "computeFractionLost", "previousSnapshot", "toJson", "Lorg/jitsi/utils/OrderedJsonObject;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "toString", "", "jitsi-media-transform"})
    public static final class Snapshot {
        private final int numReceivedPackets;
        private final int numReceivedBytes;
        private final int maxSeqNum;
        private final int seqNumCycles;
        private final int numExpectedPackets;
        private final int cumulativePacketsLost;
        private final double jitter;
        @NotNull
        private final Duration durationActive;
        @NotNull
        private final MediaType mediaType;

        public Snapshot(int numReceivedPackets, int numReceivedBytes, int maxSeqNum, int seqNumCycles, int numExpectedPackets, int cumulativePacketsLost, double jitter, @NotNull Duration durationActive, @NotNull MediaType mediaType) {
            Intrinsics.checkNotNullParameter((Object)durationActive, (String)"durationActive");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            this.numReceivedPackets = numReceivedPackets;
            this.numReceivedBytes = numReceivedBytes;
            this.maxSeqNum = maxSeqNum;
            this.seqNumCycles = seqNumCycles;
            this.numExpectedPackets = numExpectedPackets;
            this.cumulativePacketsLost = cumulativePacketsLost;
            this.jitter = jitter;
            this.durationActive = durationActive;
            this.mediaType = mediaType;
        }

        public /* synthetic */ Snapshot(int n, int n2, int n3, int n4, int n5, int n6, double d, Duration duration, MediaType mediaType, int n7, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n7 & 1) != 0) {
                n = 0;
            }
            if ((n7 & 2) != 0) {
                n2 = 0;
            }
            if ((n7 & 4) != 0) {
                n3 = 0;
            }
            if ((n7 & 8) != 0) {
                n4 = 0;
            }
            if ((n7 & 0x10) != 0) {
                n5 = 0;
            }
            if ((n7 & 0x20) != 0) {
                n6 = 0;
            }
            if ((n7 & 0x40) != 0) {
                d = 0.0;
            }
            if ((n7 & 0x80) != 0) {
                Duration duration2 = Duration.ZERO;
                Intrinsics.checkNotNullExpressionValue((Object)duration2, (String)"ZERO");
                duration = duration2;
            }
            this(n, n2, n3, n4, n5, n6, d, duration, mediaType);
        }

        public final int getNumReceivedPackets() {
            return this.numReceivedPackets;
        }

        public final int getNumReceivedBytes() {
            return this.numReceivedBytes;
        }

        public final int getMaxSeqNum() {
            return this.maxSeqNum;
        }

        public final int getSeqNumCycles() {
            return this.seqNumCycles;
        }

        public final int getNumExpectedPackets() {
            return this.numExpectedPackets;
        }

        public final int getCumulativePacketsLost() {
            return this.cumulativePacketsLost;
        }

        public final double getJitter() {
            return this.jitter;
        }

        @NotNull
        public final Duration getDurationActive() {
            return this.durationActive;
        }

        @NotNull
        public final MediaType getMediaType() {
            return this.mediaType;
        }

        public final int computeFractionLost(@NotNull Snapshot previousSnapshot) {
            Intrinsics.checkNotNullParameter((Object)previousSnapshot, (String)"previousSnapshot");
            int numExpectedPacketsInterval = this.numExpectedPackets - previousSnapshot.numExpectedPackets;
            int numReceivedPacketsInterval = this.numReceivedPackets - previousSnapshot.numReceivedPackets;
            int numLostPacketsInterval = numExpectedPacketsInterval - numReceivedPacketsInterval;
            return numExpectedPacketsInterval == 0 || numLostPacketsInterval <= 0 ? 0 : (int)((double)(numLostPacketsInterval << 8) / (double)numExpectedPacketsInterval);
        }

        @NotNull
        public final OrderedJsonObject toJson() {
            OrderedJsonObject orderedJsonObject;
            OrderedJsonObject $this$toJson_u24lambda_u240 = orderedJsonObject = new OrderedJsonObject();
            boolean bl = false;
            $this$toJson_u24lambda_u240.put((Object)"num_received_packets", (Object)this.numReceivedPackets);
            $this$toJson_u24lambda_u240.put((Object)"num_received_bytes", (Object)this.numReceivedBytes);
            $this$toJson_u24lambda_u240.put((Object)"max_seq_num", (Object)this.maxSeqNum);
            $this$toJson_u24lambda_u240.put((Object)"seq_num_cycles", (Object)this.seqNumCycles);
            $this$toJson_u24lambda_u240.put((Object)"num_expected_packets", (Object)this.numExpectedPackets);
            $this$toJson_u24lambda_u240.put((Object)"cumulative_packets_lost", (Object)this.cumulativePacketsLost);
            $this$toJson_u24lambda_u240.put((Object)"jitter", (Object)this.jitter);
            $this$toJson_u24lambda_u240.put((Object)"duration_active_ms", (Object)this.durationActive.toMillis());
            String string = this.mediaType.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            $this$toJson_u24lambda_u240.put((Object)"media_type", (Object)string);
            return orderedJsonObject;
        }

        public final int component1() {
            return this.numReceivedPackets;
        }

        public final int component2() {
            return this.numReceivedBytes;
        }

        public final int component3() {
            return this.maxSeqNum;
        }

        public final int component4() {
            return this.seqNumCycles;
        }

        public final int component5() {
            return this.numExpectedPackets;
        }

        public final int component6() {
            return this.cumulativePacketsLost;
        }

        public final double component7() {
            return this.jitter;
        }

        @NotNull
        public final Duration component8() {
            return this.durationActive;
        }

        @NotNull
        public final MediaType component9() {
            return this.mediaType;
        }

        @NotNull
        public final Snapshot copy(int numReceivedPackets, int numReceivedBytes, int maxSeqNum, int seqNumCycles, int numExpectedPackets, int cumulativePacketsLost, double jitter, @NotNull Duration durationActive, @NotNull MediaType mediaType) {
            Intrinsics.checkNotNullParameter((Object)durationActive, (String)"durationActive");
            Intrinsics.checkNotNullParameter((Object)mediaType, (String)"mediaType");
            return new Snapshot(numReceivedPackets, numReceivedBytes, maxSeqNum, seqNumCycles, numExpectedPackets, cumulativePacketsLost, jitter, durationActive, mediaType);
        }

        public static /* synthetic */ Snapshot copy$default(Snapshot snapshot, int n, int n2, int n3, int n4, int n5, int n6, double d, Duration duration, MediaType mediaType, int n7, Object object) {
            if ((n7 & 1) != 0) {
                n = snapshot.numReceivedPackets;
            }
            if ((n7 & 2) != 0) {
                n2 = snapshot.numReceivedBytes;
            }
            if ((n7 & 4) != 0) {
                n3 = snapshot.maxSeqNum;
            }
            if ((n7 & 8) != 0) {
                n4 = snapshot.seqNumCycles;
            }
            if ((n7 & 0x10) != 0) {
                n5 = snapshot.numExpectedPackets;
            }
            if ((n7 & 0x20) != 0) {
                n6 = snapshot.cumulativePacketsLost;
            }
            if ((n7 & 0x40) != 0) {
                d = snapshot.jitter;
            }
            if ((n7 & 0x80) != 0) {
                duration = snapshot.durationActive;
            }
            if ((n7 & 0x100) != 0) {
                mediaType = snapshot.mediaType;
            }
            return snapshot.copy(n, n2, n3, n4, n5, n6, d, duration, mediaType);
        }

        @NotNull
        public String toString() {
            return "Snapshot(numReceivedPackets=" + this.numReceivedPackets + ", numReceivedBytes=" + this.numReceivedBytes + ", maxSeqNum=" + this.maxSeqNum + ", seqNumCycles=" + this.seqNumCycles + ", numExpectedPackets=" + this.numExpectedPackets + ", cumulativePacketsLost=" + this.cumulativePacketsLost + ", jitter=" + this.jitter + ", durationActive=" + this.durationActive + ", mediaType=" + this.mediaType + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.numReceivedPackets);
            result = result * 31 + Integer.hashCode(this.numReceivedBytes);
            result = result * 31 + Integer.hashCode(this.maxSeqNum);
            result = result * 31 + Integer.hashCode(this.seqNumCycles);
            result = result * 31 + Integer.hashCode(this.numExpectedPackets);
            result = result * 31 + Integer.hashCode(this.cumulativePacketsLost);
            result = result * 31 + Double.hashCode(this.jitter);
            result = result * 31 + this.durationActive.hashCode();
            result = result * 31 + this.mediaType.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Snapshot)) {
                return false;
            }
            Snapshot snapshot = (Snapshot)other;
            if (this.numReceivedPackets != snapshot.numReceivedPackets) {
                return false;
            }
            if (this.numReceivedBytes != snapshot.numReceivedBytes) {
                return false;
            }
            if (this.maxSeqNum != snapshot.maxSeqNum) {
                return false;
            }
            if (this.seqNumCycles != snapshot.seqNumCycles) {
                return false;
            }
            if (this.numExpectedPackets != snapshot.numExpectedPackets) {
                return false;
            }
            if (this.cumulativePacketsLost != snapshot.cumulativePacketsLost) {
                return false;
            }
            if (Double.compare(this.jitter, snapshot.jitter) != 0) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.durationActive, (Object)snapshot.durationActive)) {
                return false;
            }
            return this.mediaType == snapshot.mediaType;
        }
    }
}

