/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.logging2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.jitsi.utils.logging2.ContextLogRecord;

public class JitsiLogFormatter
extends Formatter {
    private static final String PROGRAM_NAME_PROPERTY = ".programname";
    private static final String DISABLE_TIMESTAMP_PROPERTY = ".disableTimestamp";
    private static final String lineSeparator = System.lineSeparator();
    private static String programName;
    private static boolean timestampDisabled;
    private static final DateTimeFormatter timestampFormatter;

    public JitsiLogFormatter() {
        this.loadConfigProperties();
    }

    @Override
    public synchronized String format(LogRecord record) {
        String context;
        StringBuilder sb = new StringBuilder();
        if (programName != null) {
            sb.append(programName);
            sb.append(' ');
        }
        if (!timestampDisabled) {
            sb.append(timestampFormatter.format(ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault())));
        }
        sb.append(record.getLevel().getLocalizedName());
        sb.append(": ");
        sb.append("[").append(record.getThreadID()).append("] ");
        if (record instanceof ContextLogRecord && !(context = ((ContextLogRecord)record).getContext()).isEmpty()) {
            sb.append(context).append(" ");
        }
        int lineNumber = this.inferCaller(record);
        sb.append(record.getSourceClassName());
        if (record.getSourceMethodName() != null) {
            sb.append(".");
            sb.append(record.getSourceMethodName());
            if (lineNumber != -1) {
                sb.append("#").append(lineNumber);
            }
        }
        sb.append(": ");
        sb.append(record.getMessage());
        sb.append(lineSeparator);
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                sb.append(sw);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private int inferCaller(LogRecord record) {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        int lineNumber = -1;
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals("org.jitsi.utils.logging2.LoggerImpl") && !cname.equals("org.jitsi.utils.logging.LoggerImpl"); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            lineNumber = stack[ix].getLineNumber();
            cname = frame.getClassName();
            String shortName = cname.substring(cname.lastIndexOf(".") + 1);
            if (!cname.contains("org.jitsi.utils.logging")) {
                record.setSourceClassName(shortName);
                record.setSourceMethodName(frame.getMethodName());
                break;
            }
            ++ix;
        }
        return lineNumber;
    }

    private void loadConfigProperties() {
        JitsiLogFormatter.loadProgramNameProperty();
        JitsiLogFormatter.loadTimestampDisabledProperty();
    }

    private static void loadTimestampDisabledProperty() {
        LogManager manager = LogManager.getLogManager();
        String cname = JitsiLogFormatter.class.getName();
        timestampDisabled = Boolean.parseBoolean(manager.getProperty(cname + DISABLE_TIMESTAMP_PROPERTY));
    }

    private static void loadProgramNameProperty() {
        LogManager manager = LogManager.getLogManager();
        String cname = JitsiLogFormatter.class.getName();
        programName = manager.getProperty(cname + PROGRAM_NAME_PROPERTY);
    }

    static {
        timestampDisabled = false;
        timestampFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS ");
    }
}

