/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.textfield;

import javax.swing.event.HyperlinkEvent;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.textfield.ReadOnlyTextPane;

public class ReadOnlyTextPaneHTML
extends ReadOnlyTextPane {
    private static final Document.OutputSettings NO_PRETTYPRINT = new Document.OutputSettings().prettyPrint(false);
    private static final String NO_TEXT = "<html><body> </body></html>";

    public ReadOnlyTextPaneHTML() {
        this.setContentType("text/html");
        this.setText(NO_TEXT);
        this.addHyperlinkListener(e -> {
            if (HyperlinkEvent.EventType.ACTIVATED.equals(e.getEventType())) {
                try {
                    TmmUIHelper.browseUrl(e.getURL().toURI().toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.updateUI();
    }

    @Override
    public void setText(String t) {
        if (t == null || t.isEmpty()) {
            super.setText(NO_TEXT);
        } else if (t.startsWith("<html>")) {
            super.setText(t);
        } else {
            if (t.contains("http") || t.contains("www")) {
                t = Jsoup.clean((String)t, (String)"", (Safelist)Safelist.simpleText(), (Document.OutputSettings)NO_PRETTYPRINT);
                t = t.replaceAll("\\n", " <br/> ");
                t = t.replaceAll("(?:https|http)://([^\\s]+)", "<a href=\"$0\">$1</a>");
                t = t.replaceAll("(?:^|\\s)(www\\.[^\\s]+)", " <a href=\"https://$1\">$1</a>");
            } else {
                t = t.replaceAll("\\n", " <br/> ");
            }
            super.setText("<html><body>" + t + "</body></html>");
        }
    }
}

