/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.mediainfo.MediaInfo3D;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieVideo3DFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaInfo3D> {
    public MovieVideo3DFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallEditionArray();
    }

    @Override
    public String getId() {
        return "movieVideo3D";
    }

    private void buildAndInstallEditionArray() {
        ArrayList<MediaInfo3D> editions = new ArrayList<MediaInfo3D>();
        for (MediaInfo3D ddd : MediaInfo3D.values()) {
            if (!StringUtils.isNotBlank((CharSequence)ddd.toString())) continue;
            editions.add(ddd);
        }
        this.setValues(editions);
    }

    @Override
    protected String parseTypeToString(MediaInfo3D type) throws Exception {
        return type.name();
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        MediaInfo3D ddd = MediaInfo3D.get3DFrom(movie.getVideo3DFormat2());
        return selectedItems.contains((Object)ddd);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.3d"));
    }

    @Override
    protected MediaInfo3D parseStringToType(String string) throws Exception {
        return MediaInfo3D.get3DFrom(string);
    }
}

