/*
 * Decompiled with CFR 0.152.
 */
package fr.turri.jiso8601;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Iso8601Deserializer {
    private Iso8601Deserializer() {
    }

    public static Date toDate(String toParse) {
        return Iso8601Deserializer.toCalendar(toParse).getTime();
    }

    public static Calendar toCalendar(String toParse) {
        if (toParse.indexOf(84) == -1) {
            return Iso8601Deserializer.buildCalendarWithDateOnly(toParse, toParse);
        }
        int indexOfT = toParse.indexOf(84);
        Calendar result = Iso8601Deserializer.buildCalendarWithDateOnly(toParse.substring(0, indexOfT), toParse);
        return Iso8601Deserializer.parseHour(result, toParse.substring(indexOfT + 1));
    }

    private static Calendar parseHour(Calendar result, String hourStr) {
        String basicFormatHour = hourStr.replace(":", "");
        int indexOfZ = basicFormatHour.indexOf(90);
        if (indexOfZ != -1) {
            Iso8601Deserializer.parseHourWithoutHandlingTimeZone(result, basicFormatHour.substring(0, indexOfZ));
        } else {
            int indexOfSign = Iso8601Deserializer.getIndexOfSign(basicFormatHour);
            if (indexOfSign == -1) {
                Iso8601Deserializer.parseHourWithoutHandlingTimeZone(result, basicFormatHour);
                result.setTimeZone(TimeZone.getDefault());
            } else {
                Iso8601Deserializer.parseHourWithoutHandlingTimeZone(result, basicFormatHour.substring(0, indexOfSign));
                result.setTimeZone(TimeZone.getTimeZone("GMT" + basicFormatHour.substring(indexOfSign)));
            }
        }
        return result;
    }

    private static int getIndexOfSign(String str) {
        int index = str.indexOf(43);
        return index != -1 ? index : str.indexOf(45);
    }

    private static void parseHourWithoutHandlingTimeZone(Calendar calendar, String basicFormatHour) {
        basicFormatHour = basicFormatHour.replace(',', '.');
        int indexOfDot = basicFormatHour.indexOf(46);
        double fractionalPart = 0.0;
        if (indexOfDot != -1) {
            fractionalPart = Double.parseDouble("0" + basicFormatHour.substring(indexOfDot));
            basicFormatHour = basicFormatHour.substring(0, indexOfDot);
        }
        if (basicFormatHour.length() >= 2) {
            calendar.set(11, Integer.parseInt(basicFormatHour.substring(0, 2)));
        }
        if (basicFormatHour.length() > 2) {
            calendar.set(12, Integer.parseInt(basicFormatHour.substring(2, 4)));
        } else {
            fractionalPart *= 60.0;
        }
        if (basicFormatHour.length() > 4) {
            calendar.set(13, Integer.parseInt(basicFormatHour.substring(4, 6)));
        } else {
            fractionalPart *= 60.0;
        }
        calendar.set(14, (int)(fractionalPart * 1000.0));
    }

    private static Calendar buildCalendarWithDateOnly(String dateStr, String originalDate) {
        GregorianCalendar result = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        result.setMinimalDaysInFirstWeek(4);
        result.setFirstDayOfWeek(2);
        result.set(11, 0);
        result.set(12, 0);
        result.set(13, 0);
        result.set(14, 0);
        String basicFormatDate = dateStr.replaceAll("-", "");
        if (basicFormatDate.indexOf(87) != -1) {
            return Iso8601Deserializer.parseWeekDate(result, basicFormatDate);
        }
        if (basicFormatDate.length() == 7) {
            return Iso8601Deserializer.parseOrdinalDate(result, basicFormatDate);
        }
        return Iso8601Deserializer.parseCalendarDate(result, basicFormatDate, originalDate);
    }

    private static Calendar parseCalendarDate(Calendar result, String basicFormatDate, String originalDate) {
        if (basicFormatDate.length() == 2) {
            return Iso8601Deserializer.parseCalendarDateWithCenturyOnly(result, basicFormatDate);
        }
        if (basicFormatDate.length() == 4) {
            return Iso8601Deserializer.parseCalendarDateWithYearOnly(result, basicFormatDate);
        }
        return Iso8601Deserializer.parseCalendarDateWithPrecisionGreaterThanYear(result, basicFormatDate, originalDate);
    }

    private static Calendar parseCalendarDateWithCenturyOnly(Calendar result, String basicFormatDate) {
        result.set(Integer.parseInt(basicFormatDate) * 100, 0, 1);
        return result;
    }

    private static Calendar parseCalendarDateWithYearOnly(Calendar result, String basicFormatDate) {
        result.set(Integer.parseInt(basicFormatDate), 0, 1);
        return result;
    }

    private static Calendar parseCalendarDateWithPrecisionGreaterThanYear(Calendar result, String basicFormatDate, String originalDate) {
        int year = Integer.parseInt(basicFormatDate.substring(0, 4));
        int month = Integer.parseInt(basicFormatDate.substring(4, 6)) - 1;
        if (basicFormatDate.length() == 6) {
            result.set(year, month, 1);
            return result;
        }
        if (basicFormatDate.length() == 8) {
            result.set(year, month, Integer.parseInt(basicFormatDate.substring(6)));
            return result;
        }
        throw new RuntimeException("Can't parse " + originalDate);
    }

    private static Calendar parseWeekDate(Calendar result, String basicFormatDate) {
        result.set(1, Integer.parseInt(basicFormatDate.substring(0, 4)));
        result.set(3, Integer.parseInt(basicFormatDate.substring(5, 7)));
        result.set(7, basicFormatDate.length() == 7 ? 2 : 1 + Integer.parseInt(basicFormatDate.substring(7)));
        return result;
    }

    private static Calendar parseOrdinalDate(Calendar calendar, String basicFormatOrdinalDate) {
        calendar.set(1, Integer.parseInt(basicFormatOrdinalDate.substring(0, 4)));
        calendar.set(6, Integer.parseInt(basicFormatOrdinalDate.substring(4)));
        return calendar;
    }
}

