/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingbinding;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingListener;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.beansbinding.PropertyStateEvent;
import org.jdesktop.beansbinding.PropertyStateListener;
import org.jdesktop.beansbinding.util.Parameters;
import org.jdesktop.swingbinding.ElementsProperty;
import org.jdesktop.swingbinding.impl.AbstractColumnBinding;
import org.jdesktop.swingbinding.impl.ListBindingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JTableBinding<E, SS, TS>
extends AutoBinding<SS, List<E>, TS, List> {
    private Property<TS, ? extends JTable> tableP;
    private ElementsProperty<TS> elementsP;
    private Handler handler = new Handler();
    private JTable table;
    private BindingTableModel model;
    private boolean editable = true;
    private List<ColumnBinding> columnBindings = new ArrayList<ColumnBinding>();

    protected JTableBinding(@Nonnull AutoBinding.UpdateStrategy strategy, @Nonnull SS sourceObject, @Nonnull Property<SS, List<E>> sourceListProperty, @Nonnull TS targetObject, @Nonnull Property<TS, ? extends JTable> targetJTableProperty, @CheckForNull String name) {
        super(strategy == AutoBinding.UpdateStrategy.READ_WRITE ? AutoBinding.UpdateStrategy.READ : strategy, sourceObject, sourceListProperty, targetObject, new ElementsProperty(), name);
        Parameters.checkNotNull(targetJTableProperty, (String)"targetJTableProperty");
        this.tableP = targetJTableProperty;
        this.elementsP = (ElementsProperty)this.getTargetProperty();
    }

    protected void bindImpl() {
        this.elementsP.setAccessible(this.isTableAccessible());
        this.tableP.addPropertyStateListener(this.getTargetObject(), (PropertyStateListener)this.handler);
        this.elementsP.addPropertyStateListener(null, this.handler);
        super.bindImpl();
    }

    protected void unbindImpl() {
        this.elementsP.removePropertyStateListener(null, this.handler);
        this.tableP.removePropertyStateListener(this.getTargetObject(), (PropertyStateListener)this.handler);
        this.elementsP.setAccessible(false);
        this.cleanupForLast();
        super.unbindImpl();
    }

    private boolean isTableAccessible() {
        return this.tableP.isReadable(this.getTargetObject()) && this.tableP.getValue(this.getTargetObject()) != null;
    }

    private boolean isTableAccessible(Object value) {
        return value != null && value != PropertyStateEvent.UNREADABLE;
    }

    private void cleanupForLast() {
        if (this.table == null) {
            return;
        }
        this.table.setModel(new DefaultTableModel());
        this.table = null;
        this.model.setElements(null, true);
        this.model = null;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public ColumnBinding addColumnBinding(Property<E, ?> columnProperty) {
        return this.addColumnBinding(columnProperty, null);
    }

    public ColumnBinding addColumnBinding(Property<E, ?> columnProperty, String name) {
        this.throwIfBound();
        if (columnProperty == null) {
            throw new IllegalArgumentException("can't have null column property");
        }
        if (name == null && this.getName() != null) {
            name = this.getName() + ".COLUMN_BINDING";
        }
        ColumnBinding binding = new ColumnBinding(this.columnBindings.size(), columnProperty, name);
        this.columnBindings.add(binding);
        return binding;
    }

    public ColumnBinding addColumnBinding(int index, Property<E, ?> columnProperty) {
        return this.addColumnBinding(index, columnProperty, null);
    }

    public ColumnBinding addColumnBinding(int index, Property<E, ?> columnProperty, String name) {
        this.throwIfBound();
        if (columnProperty == null) {
            throw new IllegalArgumentException("can't have null column property");
        }
        if (name == null && this.getName() != null) {
            name = this.getName() + ".COLUMN_BINDING";
        }
        ColumnBinding binding = new ColumnBinding(index, columnProperty, name);
        this.columnBindings.add(index, binding);
        this.adjustIndices(index + 1, true);
        return binding;
    }

    public boolean removeColumnBinding(ColumnBinding binding) {
        this.throwIfBound();
        boolean retVal = this.columnBindings.remove((Object)binding);
        if (retVal) {
            this.adjustIndices(binding.getColumn(), false);
        }
        return retVal;
    }

    public ColumnBinding removeColumnBinding(int index) {
        this.throwIfBound();
        ColumnBinding retVal = this.columnBindings.remove(index);
        if (retVal != null) {
            this.adjustIndices(index, false);
        }
        return retVal;
    }

    public ColumnBinding getColumnBinding(int index) {
        return this.columnBindings.get(index);
    }

    public List<ColumnBinding> getColumnBindings() {
        return Collections.unmodifiableList(this.columnBindings);
    }

    private void adjustIndices(int start, boolean up) {
        int size = this.columnBindings.size();
        for (int i = start; i < size; ++i) {
            ColumnBinding cb = this.columnBindings.get(i);
            cb.adjustColumn(cb.getColumn() + (up ? 1 : -1));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class BindingTableModel
    extends ListBindingManager
    implements TableModel {
        private final List<TableModelListener> listeners = new CopyOnWriteArrayList<TableModelListener>();

        @Override
        protected AbstractColumnBinding[] getColBindings() {
            AbstractColumnBinding[] bindings = new AbstractColumnBinding[JTableBinding.this.getColumnBindings().size()];
            bindings = JTableBinding.this.getColumnBindings().toArray(bindings);
            return bindings;
        }

        @Override
        public int getRowCount() {
            return this.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.valueAt(rowIndex, columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            ColumnBinding cb = JTableBinding.this.getColumnBinding(columnIndex);
            BindingListener[] cbListeners = cb.getBindingListeners();
            BindingListener[] tbListeners = JTableBinding.this.getBindingListeners();
            cb.setSourceObjectUnmanaged0(this.getElement(rowIndex));
            cb.setEditingObject(value);
            cb.bindUnmanaged0();
            for (BindingListener listener : tbListeners) {
                listener.bindingBecameBound((Binding)cb);
            }
            PropertyStateEvent pse = new PropertyStateEvent(cb.getTargetProperty(), cb.getTargetObject(), true, this.getValueAt(rowIndex, columnIndex), value, false, cb.getSourceProperty().isWriteable(cb.getSourceObject()));
            for (BindingListener listener : cbListeners) {
                listener.targetChanged((Binding)cb, pse);
            }
            for (BindingListener listener : tbListeners) {
                listener.targetChanged((Binding)cb, pse);
            }
            Binding.SyncFailure failure = cb.saveUnmanaged0();
            if (failure == null) {
                for (BindingListener listener : cbListeners) {
                    listener.synced((Binding)cb);
                }
                for (BindingListener listener : tbListeners) {
                    listener.synced((Binding)cb);
                }
            } else {
                for (BindingListener listener : cbListeners) {
                    listener.syncFailed((Binding)cb, failure);
                }
                for (BindingListener listener : tbListeners) {
                    listener.syncFailed((Binding)cb, failure);
                }
            }
            cb.unbindUnmanaged0();
            for (BindingListener listener : tbListeners) {
                listener.bindingBecameUnbound((Binding)cb);
            }
            cb.setEditingObject(null);
            cb.setSourceObjectUnmanaged0(null);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Class<?> klass = JTableBinding.this.getColumnBinding(columnIndex).getColumnClass();
            return klass == null ? Object.class : klass;
        }

        @Override
        protected void allChanged() {
            this.fireTableModelEvent(new TableModelEvent(this, 0, Integer.MAX_VALUE));
        }

        @Override
        protected void valueChanged(int row, int column) {
            this.fireTableModelEvent(new TableModelEvent(this, row, row, column));
        }

        @Override
        protected void added(int row, int length) {
            assert (length > 0);
            this.fireTableModelEvent(new TableModelEvent(this, row, row + length - 1, -1, 1));
        }

        @Override
        protected void removed(int row, int length) {
            assert (length > 0);
            this.fireTableModelEvent(new TableModelEvent(this, row, row + length - 1, -1, -1));
        }

        @Override
        protected void changed(int row) {
            this.fireTableModelEvent(new TableModelEvent(this, row, row, -1));
        }

        @Override
        public String getColumnName(int columnIndex) {
            ColumnBinding binding = JTableBinding.this.getColumnBinding(columnIndex);
            return binding.getColumnName() == null ? binding.getSourceProperty().toString() : binding.getColumnName();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (!JTableBinding.this.isEditable()) {
                return false;
            }
            ColumnBinding binding = JTableBinding.this.getColumnBinding(columnIndex);
            if (!binding.isEditable()) {
                return false;
            }
            return binding.getSourceProperty().isWriteable(this.getElement(rowIndex));
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
            this.listeners.remove(l);
        }

        private void fireTableModelEvent(TableModelEvent e) {
            for (TableModelListener listener : this.listeners) {
                listener.tableChanged(e);
            }
        }

        @Override
        public int getColumnCount() {
            return this.columnCount();
        }
    }

    private class Handler
    implements PropertyStateListener {
        private Handler() {
        }

        public void propertyStateChanged(PropertyStateEvent pse) {
            if (!pse.getValueChanged()) {
                return;
            }
            if (pse.getSourceProperty() == JTableBinding.this.tableP) {
                JTableBinding.this.cleanupForLast();
                boolean wasAccessible = JTableBinding.this.isTableAccessible(pse.getOldValue());
                boolean isAccessible = JTableBinding.this.isTableAccessible(pse.getNewValue());
                if (wasAccessible != isAccessible) {
                    JTableBinding.this.elementsP.setAccessible(isAccessible);
                } else if (JTableBinding.this.elementsP.isAccessible()) {
                    JTableBinding.this.elementsP.setValueAndIgnore(null, null);
                }
            } else {
                if (((ElementsProperty.ElementsPropertyStateEvent)pse).shouldIgnore()) {
                    return;
                }
                if (JTableBinding.this.table == null) {
                    JTableBinding.this.table = (JTable)JTableBinding.this.tableP.getValue(JTableBinding.this.getTargetObject());
                    JTableBinding.this.model = new BindingTableModel();
                    JTableBinding.this.table.setModel(JTableBinding.this.model);
                    TableColumnModel columnModel = JTableBinding.this.table.getColumnModel();
                    for (int i = 0; i < columnModel.getColumnCount(); ++i) {
                        TableColumn column = columnModel.getColumn(i);
                        ColumnBinding columnBinding = JTableBinding.this.getColumnBinding(i);
                        column.setCellRenderer(columnBinding.getRenderer());
                        column.setCellEditor(columnBinding.getEditor());
                    }
                }
                JTableBinding.this.model.setElements((List)pse.getNewValue(), true);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class ColumnBinding
    extends AbstractColumnBinding {
        private Class<?> columnClass;
        private boolean editable;
        private boolean editableSet;
        private String columnName;
        private Object editingObject;
        @CheckForNull
        private TableCellRenderer renderer;
        @CheckForNull
        private TableCellEditor editor;

        private ColumnBinding(int column, Property<E, ?> columnProperty, String name) {
            super(column, columnProperty, new ColumnProperty(), name);
            this.editable = true;
            ((ColumnProperty)this.getTargetProperty()).binding = this;
        }

        private void setEditingObject(Object editingObject) {
            this.editingObject = editingObject;
        }

        private void adjustColumn(int newCol) {
            this.setColumn(newCol);
        }

        public ColumnBinding setColumnName(String name) {
            JTableBinding.this.throwIfBound();
            this.columnName = name;
            return this;
        }

        public ColumnBinding setColumnClass(Class<?> columnClass) {
            JTableBinding.this.throwIfBound();
            this.columnClass = columnClass;
            return this;
        }

        public Class<?> getColumnClass() {
            return this.columnClass == null ? Object.class : this.columnClass;
        }

        public String getColumnName() {
            return this.columnName == null ? this.getSourceProperty().toString() : this.columnName;
        }

        public ColumnBinding setEditable(boolean editable) {
            this.editable = editable;
            return this;
        }

        public boolean isEditable() {
            return this.editable;
        }

        @Nonnull
        public ColumnBinding setRenderer(@CheckForNull TableCellRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        @CheckForNull
        public TableCellRenderer getRenderer() {
            return this.renderer;
        }

        @Nonnull
        public ColumnBinding setEditor(@CheckForNull TableCellEditor editor) {
            this.editor = editor;
            return this;
        }

        @CheckForNull
        public TableCellEditor getEditor() {
            return this.editor;
        }

        private void bindUnmanaged0() {
            this.bindUnmanaged();
        }

        private void unbindUnmanaged0() {
            this.unbindUnmanaged();
        }

        private Binding.SyncFailure saveUnmanaged0() {
            return this.saveUnmanaged();
        }

        private void setSourceObjectUnmanaged0(Object source) {
            this.setSourceObjectUnmanaged(source);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ColumnProperty
    extends Property {
        private ColumnBinding binding;

        private ColumnProperty() {
        }

        public Class<? extends Object> getWriteType(Object source) {
            return this.binding.columnClass == null ? Object.class : this.binding.columnClass;
        }

        public Object getValue(Object source) {
            if (this.binding.isBound()) {
                return this.binding.editingObject;
            }
            throw new UnsupportedOperationException();
        }

        public void setValue(Object source, Object value) {
            throw new UnsupportedOperationException();
        }

        public boolean isReadable(Object source) {
            return this.binding.isBound();
        }

        public boolean isWriteable(Object source) {
            return true;
        }

        public void addPropertyStateListener(Object source, PropertyStateListener listener) {
        }

        public void removePropertyStateListener(Object source, PropertyStateListener listener) {
        }

        public PropertyStateListener[] getPropertyStateListeners(Object source) {
            return new PropertyStateListener[0];
        }
    }
}

