/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.clipinf;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.library.bluray.clipinf.AtcSequence;

@XmlType(propOrder={"reserved", "atcNumber", "atcSequence"})
public class SequenceInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(SequenceInfo.class);
    private byte reserved;
    private byte atcNumber;
    private AtcSequence[] atcSequence;

    public int size() {
        return 6 + (this.atcNumber > 0 ? this.atcSequence[0].size() * this.atcNumber : 0);
    }

    public byte getReserved() {
        return this.reserved;
    }

    public void setReserved(byte by) {
        this.reserved = by;
    }

    public byte getAtcNumber() {
        return this.atcNumber;
    }

    public void setAtcNumber(byte by) {
        this.atcNumber = by;
    }

    @XmlElement(name="AtcSequence")
    public AtcSequence[] getAtcSequence() {
        return this.atcSequence;
    }

    public void setAtcSequence(AtcSequence[] atcSequenceArray) {
        this.atcSequence = atcSequenceArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        LOGGER.trace("SequenceInfo length=" + n);
        this.reserved = dataInputStream.readByte();
        LOGGER.trace("SequenceInfo reserved=" + this.reserved);
        this.atcNumber = dataInputStream.readByte();
        LOGGER.trace("SequenceInfo atcNumber=" + this.atcNumber);
        this.atcSequence = new AtcSequence[this.atcNumber];
        for (int i = 0; i < this.atcNumber; ++i) {
            this.atcSequence[i] = new AtcSequence();
            this.atcSequence[i].readObject(dataInputStream);
        }
        LOGGER.trace("SequenceInfo reaLength=" + this.size());
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.size() - 4);
        dataOutputStream.writeShort(this.getAtcNumber());
        for (int i = 0; i < this.atcNumber; ++i) {
            this.atcSequence[i].writeObject(dataOutputStream);
        }
    }
}

