/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.verapdf.core.JAXBCollection;

public final class XmlSerialiser {
    private static final String NOID = "no-id";

    private XmlSerialiser() {
    }

    public static <T, C> C typeFromXml(Class<T> type, String source) throws JAXBException {
        return XmlSerialiser.typeFromXml(type, new StringReader(source));
    }

    public static <T, C> C typeFromXml(Class<T> type, File source) throws JAXBException {
        return XmlSerialiser.typeFromXml(type, new StreamSource(source));
    }

    public static <T, C> C typeFromXml(Class<T> type, Reader source) throws JAXBException {
        return XmlSerialiser.typeFromXml(type, new StreamSource(source));
    }

    public static <T, C> C typeFromXml(Class<T> type, InputStream source) throws JAXBException {
        return XmlSerialiser.typeFromXml(type, new StreamSource(source));
    }

    public static <T, C> C typeFromXml(Class<T> type, Source source) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance(type);
        Unmarshaller u = ctx.createUnmarshaller();
        return (C)u.unmarshal(source, type).getValue();
    }

    public static <T> List<T> collectionFromXml(Class<T> type, String source) throws JAXBException {
        return XmlSerialiser.collectionFromXml(type, new StringReader(source));
    }

    public static <T> List<T> collectionFromXml(Class<T> type, Reader source) throws JAXBException {
        return XmlSerialiser.collectionFromXml(type, new StreamSource(source));
    }

    public static <T> List<T> collectionFromXml(Class<T> type, InputStream source) throws JAXBException {
        return XmlSerialiser.collectionFromXml(type, new StreamSource(source));
    }

    public static <T> List<T> collectionFromXml(Class<T> type, Source source) throws JAXBException {
        JAXBContext ctx = JAXBContext.newInstance(JAXBCollection.class, type);
        Unmarshaller u = ctx.createUnmarshaller();
        JAXBCollection collection = u.unmarshal(source, JAXBCollection.class).getValue();
        return collection.getItems();
    }

    public static <T> String toXml(T obj, boolean format, boolean fragment) throws JAXBException {
        StringWriter sw = new StringWriter();
        XmlSerialiser.toXml(obj, sw, format, fragment);
        return sw.toString();
    }

    public static <T> void toXml(T obj, Writer wr, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(obj.getClass()), format, fragment);
        m.marshal(obj, wr);
    }

    public static <T> void toXml(T obj, XMLStreamWriter wr, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(obj.getClass()), format, fragment);
        m.marshal(obj, wr);
    }

    public static <T> void toXml(T obj, File f, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(obj.getClass()), format, fragment);
        m.marshal(obj, f);
    }

    public static <T> void toXml(T obj, OutputStream source, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(obj.getClass()), format, fragment);
        m.marshal(obj, source);
    }

    public static <T> String toXml(String rootName, Collection<T> c, boolean format, boolean fragment) throws JAXBException {
        StringWriter sw = new StringWriter();
        XmlSerialiser.toXml(rootName, c, sw, format, fragment);
        return sw.toString();
    }

    public static <T> void toXml(String rootName, Collection<T> c, Writer w, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(XmlSerialiser.findTypes(c)), format, fragment);
        JAXBElement<?> element = XmlSerialiser.createCollectionElement(rootName, c);
        m.marshal(element, w);
    }

    public static <T> void toXml(String rootName, Collection<T> c, File f, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(XmlSerialiser.findTypes(c)), format, fragment);
        JAXBElement<?> element = XmlSerialiser.createCollectionElement(rootName, c);
        m.marshal(element, f);
    }

    public static <T> void toXml(String rootName, Collection<T> c, OutputStream dest, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = XmlSerialiser.marshaller(JAXBContext.newInstance(XmlSerialiser.findTypes(c)), format, fragment);
        JAXBElement<?> element = XmlSerialiser.createCollectionElement(rootName, c);
        m.marshal(element, dest);
    }

    public static <T> void schema(T obj, Writer schemaDest) throws IOException, JAXBException {
        JAXBContext ctx = JAXBContext.newInstance(obj.getClass());
        ctx.generateSchema(new WriterSchemaOutputResolver(schemaDest));
    }

    public static <T> void schema(T obj, OutputStream schemaDest) throws IOException, JAXBException {
        OutputStreamWriter writer = new OutputStreamWriter(schemaDest);
        XmlSerialiser.schema(obj, writer);
    }

    public static <T> String schema(T obj) throws IOException, JAXBException {
        StringWriter writer = new StringWriter();
        XmlSerialiser.schema(obj, writer);
        return ((Object)writer).toString();
    }

    protected static <T> Class<?>[] findTypes(Collection<T> c) {
        HashSet types = new HashSet();
        types.add(JAXBCollection.class);
        for (T o : c) {
            if (o == null) continue;
            types.add(o.getClass());
        }
        return types.toArray(new Class[0]);
    }

    protected static <T> JAXBElement<?> createCollectionElement(String rootName, Collection<T> c) {
        JAXBCollection<T> collection = new JAXBCollection<T>(c);
        return new JAXBElement<JAXBCollection<T>>(new QName(rootName), JAXBCollection.class, collection);
    }

    private static Marshaller marshaller(JAXBContext ctx, boolean format, boolean fragment) throws JAXBException {
        Marshaller m = ctx.createMarshaller();
        m.setProperty("jaxb.formatted.output", format);
        if (fragment) {
            m.setProperty("jaxb.fragment", Boolean.TRUE);
        }
        return m;
    }

    private static class WriterSchemaOutputResolver
    extends SchemaOutputResolver {
        private final Writer out;

        public WriterSchemaOutputResolver(Writer out) {
            this.out = out;
        }

        @Override
        public Result createOutput(String namespaceUri, String suggestedFileName) {
            StreamResult result = new StreamResult(this.out);
            result.setSystemId(XmlSerialiser.NOID);
            return result;
        }
    }
}

