/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import com.mojang.logging.LogUtils;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.slf4j.Logger;

public class ModLoadingContext {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ThreadLocal<ModLoadingContext> context = ThreadLocal.withInitial(ModLoadingContext::new);
    private ModContainer activeContainer;
    private Object languageExtension;

    @Deprecated(forRemoval=true, since="1.21.1")
    public static ModLoadingContext get() {
        return context.get();
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public void setActiveContainer(ModContainer container) {
        this.activeContainer = container;
        this.languageExtension = container == null ? null : container.contextExtension.get();
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public ModContainer getActiveContainer() {
        return this.activeContainer == null ? ModList.get().getModContainerById("minecraft").orElseThrow(() -> new RuntimeException("Where is minecraft???!")) : this.activeContainer;
    }

    @Deprecated(forRemoval=true, since="1.21.1")
    public String getActiveNamespace() {
        return this.activeContainer == null ? "minecraft" : this.activeContainer.getNamespace();
    }

    public ModContainer getContainer() {
        return this.getActiveContainer();
    }

    public <T extends Record> void registerExtensionPoint(Class<? extends IExtensionPoint<T>> point, Supplier<T> extension) {
        this.getContainer().registerExtensionPoint(point, extension);
    }

    public void registerDisplayTest(IExtensionPoint.DisplayTest displayTest) {
        this.getContainer().registerDisplayTest(() -> displayTest);
    }

    public void registerDisplayTest(Supplier<IExtensionPoint.DisplayTest> displayTest) {
        this.getContainer().registerDisplayTest(displayTest);
    }

    public void registerDisplayTest(String version, BiPredicate<String, Boolean> remoteVersionTest) {
        this.getContainer().registerDisplayTest(new IExtensionPoint.DisplayTest(version, remoteVersionTest));
    }

    public void registerDisplayTest(Supplier<String> suppliedVersion, BiPredicate<String, Boolean> remoteVersionTest) {
        this.getContainer().registerDisplayTest(new IExtensionPoint.DisplayTest(suppliedVersion, remoteVersionTest));
    }

    public void registerConfig(ModConfig.Type type, IConfigSpec<?> spec) {
        if (spec.isEmpty()) {
            LOGGER.debug("Attempted to register an empty config for type {} on mod {}", (Object)type, (Object)this.getContainer().getModId());
            return;
        }
        this.getContainer().addConfig(new ModConfig(type, spec, this.getContainer()));
    }

    public void registerConfig(ModConfig.Type type, IConfigSpec<?> spec, String fileName) {
        if (spec.isEmpty()) {
            LOGGER.debug("Attempted to register an empty config for type {} on mod {} using file name {}", new Object[]{type, this.getContainer().getModId(), fileName});
            return;
        }
        this.getContainer().addConfig(new ModConfig(type, spec, this.getContainer(), fileName));
    }

    public <T> T extension() {
        return (T)this.languageExtension;
    }
}

