/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.eventbus.api.bus.CancellableEventBus;
import net.minecraftforge.eventbus.api.event.characteristic.Cancellable;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.eventbus.internal.BusGroupImpl;
import net.minecraftforge.eventbus.internal.Constants;
import net.minecraftforge.eventbus.internal.Event;
import org.jspecify.annotations.Nullable;

final class EventListenerFactory {
    private static final MethodType RETURNS_CONSUMER = MethodType.methodType(Consumer.class);
    private static final MethodType RETURNS_PREDICATE = MethodType.methodType(Predicate.class);
    private static final MethodType RETURNS_MONITOR = MethodType.methodType(ObjBooleanBiConsumer.class);
    private static final MethodType CONSUMER_FI_TYPE = MethodType.methodType(Void.TYPE, Object.class);
    private static final MethodType PREDICATE_FI_TYPE = CONSUMER_FI_TYPE.changeReturnType(Boolean.TYPE);
    private static final MethodType MONITOR_FI_TYPE = MethodType.methodType(Void.TYPE, Object.class, Boolean.TYPE);
    private static final Map<Method, MethodHandle> LMF_CACHE = new ConcurrentHashMap<Method, MethodHandle>();

    private EventListenerFactory() {
    }

    public static Collection<EventListener> register(BusGroupImpl busGroup, MethodHandles.Lookup callerLookup, Class<?> listenerClass, @Nullable Object listenerInstance) {
        Method[] declaredMethods = listenerClass.getDeclaredMethods();
        if (declaredMethods.length == 0) {
            throw new IllegalArgumentException("No declared methods found in " + String.valueOf(listenerClass));
        }
        Class<?> firstValidListenerEventType = null;
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (Method method : declaredMethods) {
            Class<?> returnType;
            int paramCount;
            if (listenerInstance == null && !Modifier.isStatic(method.getModifiers()) || method.isSynthetic() || (paramCount = method.getParameterCount()) == 0 || paramCount > 2 || (returnType = method.getReturnType()) != Void.TYPE && returnType != Boolean.TYPE || !method.isAnnotationPresent(SubscribeEvent.class)) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            if (!Event.class.isAssignableFrom(parameterTypes[0])) {
                throw new IllegalArgumentException("First parameter of a @SubscribeEvent method must be an event");
            }
            Class<?> eventType = parameterTypes[0];
            SubscribeEvent subscribeEventAnnotation = method.getAnnotation(SubscribeEvent.class);
            listeners.add(EventListenerFactory.registerListener(busGroup, callerLookup, paramCount, returnType, eventType, subscribeEventAnnotation, method, listenerInstance));
            if (firstValidListenerEventType != null) continue;
            firstValidListenerEventType = eventType;
        }
        if (listeners.isEmpty()) {
            throw new IllegalArgumentException("No listeners found in " + String.valueOf(listenerClass));
        }
        if (firstValidListenerEventType == null) {
            throw new IllegalArgumentException("No valid listeners found in " + String.valueOf(listenerClass));
        }
        if (listeners.size() == 1) {
            throw new IllegalArgumentException("Only a single listener found in " + String.valueOf(listenerClass) + ". You should directly call addListener() on the EventBus of " + firstValidListenerEventType.getSimpleName() + " instead.");
        }
        return listeners;
    }

    public static Collection<EventListener> registerStrict(BusGroupImpl busGroup, MethodHandles.Lookup callerLookup, Class<?> listenerClass, @Nullable Object listenerInstance) {
        Class<?> firstValidListenerEventType = null;
        List<Method> declaredMethods = Arrays.stream(listenerClass.getDeclaredMethods()).filter(Predicate.not(Method::isSynthetic)).toList();
        if (declaredMethods.isEmpty()) {
            String errMsg = "No declared methods found in " + listenerClass.getName();
            Class<?> superClass = listenerClass.getSuperclass();
            if (superClass != null && superClass != Record.class && superClass != Enum.class) {
                errMsg = errMsg + ". Note that listener inheritance is not supported. If you are trying to inherit listeners, please use @Override and @SubscribeEvent on the method in the subclass.";
            }
            throw EventListenerFactory.fail(listenerClass, errMsg);
        }
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        for (Method method : declaredMethods) {
            boolean isMonitoringPriority;
            boolean hasSubscribeEvent = method.isAnnotationPresent(SubscribeEvent.class);
            int paramCount = method.getParameterCount();
            if (hasSubscribeEvent && (paramCount == 0 || paramCount > 2)) {
                throw EventListenerFactory.fail(method, "Invalid number of parameters: " + paramCount + " (expected 1 or 2)");
            }
            if (paramCount == 0) continue;
            Class<?> returnType = method.getReturnType();
            Class<?>[] parameterTypes = method.getParameterTypes();
            boolean firstParamExtendsEvent = Event.class.isAssignableFrom(parameterTypes[0]);
            if (!hasSubscribeEvent && firstParamExtendsEvent) {
                throw EventListenerFactory.fail(method, "Missing @SubscribeEvent annotation");
            }
            if (!hasSubscribeEvent) continue;
            boolean firstParamExtendsCancellable = Cancellable.class.isAssignableFrom(parameterTypes[0]);
            SubscribeEvent subscribeEventAnnotation = method.getAnnotation(SubscribeEvent.class);
            boolean bl = isMonitoringPriority = subscribeEventAnnotation.priority() == -128;
            if (!firstParamExtendsEvent) {
                throw EventListenerFactory.fail(method, "First parameter of a @SubscribeEvent method must be an event");
            }
            Class<?> eventType = parameterTypes[0];
            if (returnType != Void.TYPE && returnType != Boolean.TYPE) {
                throw EventListenerFactory.fail(method, "Invalid return type: " + returnType.getName() + " (expected void or boolean)");
            }
            if (listenerInstance == null && !Modifier.isStatic(method.getModifiers())) {
                throw EventListenerFactory.fail(method, "Listener instance is null and method is not static");
            }
            if (isMonitoringPriority && (returnType == Boolean.TYPE || subscribeEventAnnotation.alwaysCancelling())) {
                throw EventListenerFactory.fail(method, "Monitoring listeners cannot cancel events");
            }
            if (paramCount == 2) {
                if (!firstParamExtendsCancellable) {
                    throw EventListenerFactory.fail(method, "Cancellation-aware monitoring listeners are only valid for cancellable events");
                }
                if (!Boolean.TYPE.isAssignableFrom(parameterTypes[1])) {
                    throw EventListenerFactory.fail(method, "Second parameter of a cancellation-aware monitoring listener must be a boolean");
                }
                if (!isMonitoringPriority) {
                    throw EventListenerFactory.fail(method, "Cancellation-aware monitoring listeners must have a priority of MONITOR");
                }
            }
            if (!firstParamExtendsCancellable) {
                if (subscribeEventAnnotation.alwaysCancelling()) {
                    throw EventListenerFactory.fail(method, "Always cancelling listeners are only valid for cancellable events");
                }
                if (returnType == Boolean.TYPE) {
                    throw EventListenerFactory.fail(method, "Return type boolean is only valid for cancellable events");
                }
            }
            listeners.add(EventListenerFactory.registerListener(busGroup, callerLookup, paramCount, returnType, eventType, subscribeEventAnnotation, method, listenerInstance));
            if (firstValidListenerEventType != null) continue;
            firstValidListenerEventType = eventType;
        }
        if (listeners.isEmpty()) {
            throw EventListenerFactory.fail(listenerClass, "No listeners found");
        }
        if (firstValidListenerEventType == null) {
            throw EventListenerFactory.fail(listenerClass, "No valid listeners found");
        }
        if (listeners.size() == 1) {
            throw EventListenerFactory.fail(listenerClass, "Only a single listener found. You should directly call addListener() on the EventBus of " + firstValidListenerEventType.getSimpleName() + " instead.");
        }
        return listeners;
    }

    private static EventListener registerListener(BusGroupImpl busGroup, MethodHandles.Lookup callerLookup, int paramCount, Class<?> returnType, Class<? extends Event> eventType, SubscribeEvent subscribeEventAnnotation, Method method, @Nullable Object listenerInstance) {
        if (paramCount == 1) {
            byte priority = subscribeEventAnnotation.priority();
            if (returnType == Void.TYPE) {
                if (Cancellable.class.isAssignableFrom(eventType)) {
                    CancellableEventBus eventBus = (CancellableEventBus)busGroup.getOrCreateEventBus(eventType);
                    if (subscribeEventAnnotation.alwaysCancelling()) {
                        return eventBus.addListener(priority, true, EventListenerFactory.createConsumer(callerLookup, method, listenerInstance));
                    }
                    return eventBus.addListener(priority, EventListenerFactory.createConsumer(callerLookup, method, listenerInstance));
                }
                return busGroup.getOrCreateEventBus(eventType).addListener(priority, EventListenerFactory.createConsumer(callerLookup, method, listenerInstance));
            }
            if (!Cancellable.class.isAssignableFrom(eventType)) {
                throw EventListenerFactory.fail(method, "Return type boolean is only valid for cancellable events");
            }
            if (subscribeEventAnnotation.alwaysCancelling()) {
                throw new IllegalArgumentException("Always cancelling listeners must have a void return type");
            }
            return ((CancellableEventBus)busGroup.getOrCreateEventBus(eventType)).addListener(priority, EventListenerFactory.createPredicate(callerLookup, method, listenerInstance));
        }
        if (returnType != Void.TYPE) {
            throw new IllegalArgumentException("Cancellation-aware monitoring listeners must have a void return type");
        }
        if (subscribeEventAnnotation.alwaysCancelling()) {
            throw new IllegalArgumentException("Monitoring listeners cannot cancel events");
        }
        return ((CancellableEventBus)busGroup.getOrCreateEventBus(eventType)).addListener(EventListenerFactory.createMonitor(callerLookup, method, listenerInstance));
    }

    private static IllegalArgumentException fail(Class<?> listenerClass, String reason) {
        return new IllegalArgumentException("Failed to register " + listenerClass.getName() + ": " + reason);
    }

    private static IllegalArgumentException fail(Method mtd, String reason) {
        return new IllegalArgumentException("Failed to register " + mtd.getDeclaringClass().getName() + "." + mtd.getName() + ": " + reason);
    }

    private static <T extends Event> Consumer<T> createConsumer(MethodHandles.Lookup callerLookup, Method callback, @Nullable Object instance) {
        boolean isStatic = Modifier.isStatic(callback.getModifiers());
        MethodHandle factoryMH = EventListenerFactory.getOrMakeFactory(callerLookup, callback, isStatic, instance, RETURNS_CONSUMER, CONSUMER_FI_TYPE, "accept");
        try {
            return isStatic ? factoryMH.invokeExact() : factoryMH.invokeExact(instance);
        }
        catch (Exception e) {
            throw EventListenerFactory.makeRuntimeException(callback, e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static <T extends Event> Predicate<T> createPredicate(MethodHandles.Lookup callerLookup, Method callback, @Nullable Object instance) {
        boolean isStatic = Modifier.isStatic(callback.getModifiers());
        MethodHandle factoryMH = EventListenerFactory.getOrMakeFactory(callerLookup, callback, isStatic, instance, RETURNS_PREDICATE, PREDICATE_FI_TYPE, "test");
        try {
            return isStatic ? factoryMH.invokeExact() : factoryMH.invokeExact(instance);
        }
        catch (Exception e) {
            throw EventListenerFactory.makeRuntimeException(callback, e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static <T extends Event> ObjBooleanBiConsumer<T> createMonitor(MethodHandles.Lookup callerLookup, Method callback, @Nullable Object instance) {
        boolean isStatic = Modifier.isStatic(callback.getModifiers());
        MethodHandle factoryMH = EventListenerFactory.getOrMakeFactory(callerLookup, callback, isStatic, instance, RETURNS_MONITOR, MONITOR_FI_TYPE, "accept");
        try {
            return isStatic ? factoryMH.invokeExact() : factoryMH.invokeExact(instance);
        }
        catch (Exception e) {
            throw EventListenerFactory.makeRuntimeException(callback, e);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static MethodHandle getOrMakeFactory(MethodHandles.Lookup callerLookup, Method callback, boolean isStatic, @Nullable Object instance, MethodType factoryReturnType, MethodType fiMethodType, String fiMethodName) {
        if (Constants.ALLOW_DUPE_LISTENERS) {
            return EventListenerFactory.makeFactory(callerLookup, callback, isStatic, instance, factoryReturnType, fiMethodType, fiMethodName);
        }
        return LMF_CACHE.computeIfAbsent(callback, callbackMethod -> EventListenerFactory.makeFactory(callerLookup, callbackMethod, isStatic, instance, factoryReturnType, fiMethodType, fiMethodName));
    }

    private static MethodHandle makeFactory(MethodHandles.Lookup callerLookup, Method callback, boolean isStatic, @Nullable Object instance, MethodType factoryReturnType, MethodType fiMethodType, String fiMethodName) {
        try {
            MethodHandle mh = callerLookup.unreflect(callback);
            MethodType factoryType = isStatic ? factoryReturnType : factoryReturnType.insertParameterTypes(0, Objects.requireNonNull(instance).getClass());
            MethodHandle lmf = LambdaMetafactory.metafactory(callerLookup, fiMethodName, factoryType, fiMethodType, mh, isStatic ? mh.type() : mh.type().dropParameterTypes(0, 1)).getTarget();
            if (isStatic) {
                return lmf;
            }
            return lmf.asType(factoryType.changeParameterType(0, Object.class));
        }
        catch (Exception e) {
            throw EventListenerFactory.makeRuntimeException(callback, e);
        }
    }

    private static RuntimeException makeRuntimeException(Method callback, Exception e) {
        Exception exception = e;
        Objects.requireNonNull(exception);
        Exception exception2 = exception;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IllegalAccessException.class, NullPointerException.class}, (Object)exception2, n)) {
            case 0 -> {
                IllegalAccessException iae = (IllegalAccessException)exception2;
                Object errMsg = "Failed to create listener";
                if (!Modifier.isPublic(callback.getModifiers())) {
                    errMsg = (String)errMsg + " - is it public?";
                }
                yield new RuntimeException((String)errMsg, iae);
            }
            case 1 -> {
                NullPointerException npe = (NullPointerException)exception2;
                yield new RuntimeException("Failed to create listener - was given a non-static method without an instance to invoke it with", npe);
            }
            default -> new RuntimeException("Failed to create listener", e);
        };
    }
}

