/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.eventbus.internal;

import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraftforge.eventbus.api.listener.EventListener;
import net.minecraftforge.eventbus.api.listener.ObjBooleanBiConsumer;
import net.minecraftforge.eventbus.internal.Event;

public sealed interface EventListenerImpl
extends EventListener {

    public record WrappedConsumerListener(Class<? extends Event> eventType, byte priority, boolean alwaysCancelling, Consumer<Event> consumer, Predicate<Event> predicate) implements HasConsumer<Event>,
    HasPredicate<Event>
    {
        public WrappedConsumerListener(Class<? extends Event> eventType, byte priority, Consumer<Event> consumer) {
            this(eventType, priority, false, consumer, WrappedConsumerListener.wrap(false, consumer));
        }

        public WrappedConsumerListener(Class<? extends Event> eventType, byte priority, boolean alwaysCancelling, Consumer<Event> consumer) {
            this(eventType, priority, alwaysCancelling, consumer, WrappedConsumerListener.wrap(alwaysCancelling, consumer));
        }

        public WrappedConsumerListener {
            assert (!alwaysCancelling || priority != -128) : "Monitoring listeners cannot cancel events";
        }

        public static Predicate<Event> wrap(boolean alwaysCancelling, Consumer<Event> consumer) {
            if (alwaysCancelling) {
                return event -> {
                    consumer.accept((Event)event);
                    return true;
                };
            }
            return event -> {
                consumer.accept((Event)event);
                return false;
            };
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof WrappedConsumerListener)) return false;
            WrappedConsumerListener that = (WrappedConsumerListener)obj;
            if (this.eventType != that.eventType) return false;
            if (this.priority != that.priority) return false;
            if (this.alwaysCancelling != that.alwaysCancelling) return false;
            if (!this.consumer.equals(that.consumer)) return false;
            return true;
        }

        @Override
        public int hashCode() {
            return this.eventType.hashCode() * 31 + this.priority * 31 + Boolean.hashCode(this.alwaysCancelling) * 31 + this.consumer.hashCode();
        }
    }

    public record MonitoringListener(Class<? extends Event> eventType, ObjBooleanBiConsumer<Event> booleanBiConsumer) implements EventListenerImpl
    {
        public MonitoringListener(Class<? extends Event> eventType, Consumer<Event> listener) {
            this(eventType, (Event event, boolean wasCancelled) -> listener.accept((Event)event));
        }

        @Override
        public byte priority() {
            return -128;
        }
    }

    public record PredicateListener(Class<? extends Event> eventType, byte priority, Predicate<Event> predicate) implements HasPredicate<Event>
    {
        public PredicateListener {
            assert (priority != -128) : "Monitoring listeners cannot cancel events";
        }
    }

    public record ConsumerListener(Class<? extends Event> eventType, byte priority, Consumer<Event> consumer) implements HasConsumer<Event>
    {
    }

    public static sealed interface HasPredicate<T>
    extends EventListenerImpl
    permits PredicateListener, WrappedConsumerListener {
        public Predicate<T> predicate();
    }

    public static sealed interface HasConsumer<T>
    extends EventListenerImpl
    permits ConsumerListener, WrappedConsumerListener {
        public Consumer<T> consumer();
    }
}

