/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty.upnp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jupnp.UpnpService;
import org.jupnp.controlpoint.ActionCallback;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.header.UDADeviceTypeHeader;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.meta.Device;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.DeviceType;
import org.jupnp.model.types.ServiceId;
import org.jupnp.model.types.UDADeviceType;
import org.jupnp.model.types.UDAServiceId;
import org.jupnp.support.avtransport.callback.Play;
import org.jupnp.support.avtransport.callback.SetAVTransportURI;
import org.jupnp.support.avtransport.callback.Stop;
import org.jupnp.support.contentdirectory.DIDLParser;
import org.jupnp.support.model.DIDLContent;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.item.Item;
import org.jupnp.transport.RouterException;
import org.jupnp.util.SpecificationViolationReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.thirdparty.NetworkUtil;
import org.tinymediamanager.thirdparty.upnp.Metadata;
import org.tinymediamanager.thirdparty.upnp.TmmUpnpService;

public class Upnp {
    private static final Logger LOGGER = LoggerFactory.getLogger(Upnp.class);
    public static final String ID_ROOT = "0";
    public static final String ID_MOVIES = "1";
    public static final String ID_TVSHOWS = "2";
    private static boolean initialized = false;
    private static Upnp instance;
    private final String ipAddress;
    private TmmUpnpService upnpService = null;
    private Service<?, ?> playerService = null;
    public final Set<String> blockedIps = new HashSet<String>();
    private int upnpPort;

    private Upnp() {
        this.ipAddress = NetworkUtil.getMachineIPAddress();
    }

    public static synchronized Upnp getInstance() {
        if (instance == null) {
            SpecificationViolationReporter.disableReporting();
            instance = new Upnp();
        }
        return instance;
    }

    public static void init() {
        initialized = true;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public int getPort() {
        return this.upnpPort;
    }

    public Set<String> getBlockedIps() {
        return this.blockedIps;
    }

    public void addBlockedIp(String ip) {
        this.blockedIps.add(ip);
    }

    private synchronized void createUpnpService() {
        if ((Settings.getInstance().isUpnpShareLibrary() || Settings.getInstance().isUpnpRemotePlay()) && this.upnpService == null) {
            boolean isStarted;
            this.upnpService = new TmmUpnpService(this.upnpPort, Settings.getInstance().isUpnpShareLibrary());
            this.upnpService.startup();
            try {
                isStarted = this.upnpService.getRouter().isEnabled();
            }
            catch (RouterException ex) {
                isStarted = false;
            }
            if (!isStarted) {
                LOGGER.error("UPnP fatal error: unable to start UPnP service");
            } else {
                LOGGER.debug("UPnP (JUPnP) services are online and listening for media renderers on port {}", (Object)this.upnpPort);
            }
        }
    }

    public synchronized void updateConfiguration(boolean shareLibrary, boolean remotePlay, int port) {
        if (!initialized) {
            return;
        }
        if (!shareLibrary && !remotePlay) {
            if (this.upnpService != null) {
                LOGGER.debug("Stopping UPnP service as requested by settings change");
                this.upnpService.shutdown();
                this.upnpService = null;
            }
            return;
        }
        if (this.upnpService == null) {
            this.upnpPort = port;
            this.blockedIps.clear();
            LOGGER.debug("Starting UPnP service on port {} as requested by settings", (Object)this.upnpPort);
            this.createUpnpService();
            return;
        }
        if (this.upnpPort != port) {
            LOGGER.debug("Restarting UPnP service on new port {} (was {})", (Object)port, (Object)this.upnpPort);
            try {
                this.upnpService.shutdown();
            }
            catch (Exception e) {
                LOGGER.debug("Error while shutting down existing UPnP service", (Throwable)e);
            }
            this.upnpPort = port;
            this.upnpService = null;
            this.createUpnpService();
        }
    }

    public void sendPlayerSearchRequest() {
        this.createUpnpService();
        this.upnpService.getControlPoint().search((UpnpHeader)new UDADeviceTypeHeader((DeviceType)new UDADeviceType("MediaRenderer")));
    }

    public List<Device<?, ?, ?>> getAvailablePlayers() {
        this.createUpnpService();
        ArrayList ret = new ArrayList();
        for (Device device : this.upnpService.getRegistry().getDevices()) {
            if (!device.getType().getType().equals("MediaRenderer")) continue;
            LOGGER.debug("Found MediaRenderer: {}", (Object)device.getDisplayString());
            ret.add(device);
        }
        return ret;
    }

    public void setPlayer(Device<?, ?, ?> device) {
        this.playerService = device.findService((ServiceId)new UDAServiceId("AVTransport"));
        if (this.playerService == null) {
            LOGGER.debug("Could not find AVTransport service on UPnP device: {}", (Object)device.getDisplayString());
        }
    }

    public void playFile(MediaEntity me, MediaFile mf) {
        if (this.playerService == null) {
            LOGGER.debug("No UPnP player set; did you call setPlayer(Device)?");
            return;
        }
        if (mf == null) {
            LOGGER.debug("No MediaFile provided to playFile()");
            return;
        }
        String url = "";
        String meta = "NO METADATA";
        if (me != null) {
            try {
                DIDLContent didl = new DIDLContent();
                DIDLParser dip = new DIDLParser();
                if (me instanceof Movie) {
                    Movie movie = (Movie)me;
                    didl.addItem((Item)Metadata.getUpnpMovie(movie, true));
                } else if (me instanceof TvShowEpisode) {
                    TvShowEpisode episode = (TvShowEpisode)me;
                    didl.addItem((Item)Metadata.getUpnpTvShowEpisode(episode.getTvShow(), episode, true));
                }
                url = ((Res)((Item)didl.getItems().get(0)).getResources().get(0)).getValue();
                meta = dip.generate(didl);
            }
            catch (Exception e) {
                LOGGER.debug("Could not generate metadata / URL for UPnP playback", (Throwable)e);
                return;
            }
        }
        SetAVTransportURI setAVTransportURIAction = new SetAVTransportURI(this.playerService, url, meta){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Setting URL for player failed: {}", (Object)defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)setAVTransportURIAction);
        Play playAction = new Play(this.playerService){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Playing via UPnP failed: {}", (Object)defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)playAction);
    }

    public void stopPlay() {
        if (this.playerService == null) {
            return;
        }
        Stop stopAction = new Stop(this.playerService){

            public void failure(ActionInvocation invocation, UpnpResponse operation, String defaultMsg) {
                LOGGER.warn("Stopping UPnP playback failed: {}", (Object)defaultMsg);
            }
        };
        this.upnpService.getControlPoint().execute((ActionCallback)stopAction);
    }

    public void startMediaServer() {
        this.createUpnpService();
    }

    public void stopMediaServer() {
        if (this.upnpService != null) {
            this.upnpService.shutdown();
        }
    }

    public void shutdown() {
        this.stopPlay();
        this.stopMediaServer();
    }
}

