/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.collection;

import io.jenetics.internal.collection.ObjectStore;
import io.jenetics.internal.util.reflect;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;

public final class Array<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Store.Ref<T> _store;
    private final int _start;
    private final int _length;

    private Array(Store.Ref<T> store, int from, int until) {
        this._store = Objects.requireNonNull(store);
        this._start = from;
        this._length = until - from;
    }

    private Array(Store<T> store) {
        this(Store.Ref.of(store), 0, store.length());
    }

    public Store<T> store() {
        return ((Store.Ref)this._store)._value;
    }

    public void copyIfSealed() {
        this._store.copyIfSealed();
    }

    public final Array<T> seal() {
        return new Array<T>(this._store.seal(), this._start, this._length + this._start);
    }

    public boolean isSealed() {
        return this._store.isSealed();
    }

    public void set(int index, T value) {
        this._store.set(index + this._start, value);
    }

    public void sort(int from, int until, Comparator<? super T> comparator) {
        this._store.sort(from + this._start, until + this._start, comparator);
    }

    public T get(int index) {
        return this._store.get(index + this._start);
    }

    public Array<T> append(Array<T> array2) {
        int i;
        Array<T> appended = this.newInstance(this.length() + array2.length());
        for (i = 0; i < this._length; ++i) {
            appended.set(i, this.get(i));
        }
        for (i = 0; i < array2._length; ++i) {
            appended.set(i + this._length, array2.get(i));
        }
        return appended;
    }

    private Array<T> newInstance(int length) {
        return Array.of(((Store.Ref)this._store)._value.newInstance(length));
    }

    public Array<T> append(Iterable<? extends T> values) {
        int size = Array.size(values);
        Array<T> array2 = this.newInstance(this._length + size);
        for (int i = 0; i < this._length; ++i) {
            array2.set(i, this.get(i));
        }
        Iterator<T> it = values.iterator();
        for (int i = 0; i < size; ++i) {
            array2.set(this._length + i, it.next());
        }
        return array2;
    }

    public Array<T> prepend(Iterable<? extends T> values) {
        int i;
        int size = Array.size(values);
        Array<T> array2 = this.newInstance(this._length + size);
        Iterator<T> it = values.iterator();
        for (i = 0; i < size; ++i) {
            array2.set(i, it.next());
        }
        for (i = 0; i < this._length; ++i) {
            array2.set(size + i, this.get(i));
        }
        return array2;
    }

    private static int size(Iterable<?> values) {
        int size = 0;
        if (values instanceof Collection) {
            size = ((Collection)values).size();
        } else {
            for (Object value : values) {
                ++size;
            }
        }
        return size;
    }

    public int length() {
        return this._length;
    }

    public Array<T> copy() {
        return new Array<T>(this._store.copy(this._start, this._length + this._start));
    }

    public Array<T> slice(int from) {
        return this.slice(from, this.length());
    }

    public Array<T> slice(int from, int until) {
        this.checkIndex(from, until);
        return new Array<T>(this._store, from + this._start, until + this._start);
    }

    public void checkIndex(int index) {
        if (index < 0 || index >= this.length()) {
            throw new ArrayIndexOutOfBoundsException(String.format("Index %s is out of bounds [0, %s)", index, this.length()));
        }
    }

    public final void checkIndex(int from, int until) {
        Array.checkIndex(from, until, this.length());
    }

    public static void checkIndex(int from, int until, int size) {
        if (from < 0) {
            throw new ArrayIndexOutOfBoundsException("fromIndex = " + from);
        }
        if (until > size) {
            throw new ArrayIndexOutOfBoundsException(String.format("Invalid index range: [%d, %s)", from, until));
        }
        if (from > until) {
            throw new IllegalArgumentException(String.format("fromIndex(%d) > toIndex(%d)", from, until));
        }
    }

    public static <T> Array<T> of(Store<T> store) {
        return new Array<T>(store);
    }

    public static <T> Array<T> ofLength(int length) {
        return new Array(ObjectStore.ofLength(length));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        Store store = this._start == 0 ? ((Store.Ref)this._store)._value : ((Store.Ref)this._store)._value.copy(this._start, this._start + this._length);
        out.writeBoolean(((Store.Ref)this._store)._sealed);
        out.writeObject(store);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean sealed = in.readBoolean();
        Store store = (Store)in.readObject();
        Store.Ref ref = new Store.Ref(store, sealed);
        reflect.setField(this, "_start", 0);
        reflect.setField(this, "_length", store.length());
        reflect.setField(this, "_store", ref);
    }

    public static interface Store<T> {
        public void set(int var1, T var2);

        public T get(int var1);

        public void sort(int var1, int var2, Comparator<? super T> var3);

        public int length();

        public Store<T> copy(int var1, int var2);

        default public Store<T> copy(int from) {
            return this.copy(from, this.length());
        }

        default public Store<T> copy() {
            return this.copy(0, this.length());
        }

        public Store<T> newInstance(int var1);

        public static final class Ref<T>
        implements Store<T> {
            private Store<T> _value;
            private boolean _sealed;

            private Ref(Store<T> value, boolean sealed) {
                this._value = value;
                this._sealed = sealed;
            }

            public Ref<T> seal() {
                this._sealed = true;
                return new Ref<T>(this._value, true);
            }

            public boolean isSealed() {
                return this._sealed;
            }

            @Override
            public void set(int index, T value) {
                this.copyIfSealed();
                this._value.set(index, value);
            }

            @Override
            public void sort(int from, int until, Comparator<? super T> comparator) {
                this.copyIfSealed();
                this._value.sort(from, until, comparator);
            }

            void copyIfSealed() {
                if (this._sealed) {
                    this._value = this.copy();
                    this._sealed = false;
                }
            }

            @Override
            public T get(int index) {
                return this._value.get(index);
            }

            @Override
            public int length() {
                return this._value.length();
            }

            @Override
            public Store<T> copy(int from, int until) {
                return this._value.copy(from, until);
            }

            @Override
            public Store<T> newInstance(int length) {
                return this._value.newInstance(length);
            }

            public static <T> Ref<T> of(Store<T> value) {
                return new Ref<T>(Objects.requireNonNull(value), false);
            }
        }
    }
}

