/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.jitsi.utils.concurrent.ExecutorUtils;
import org.jitsi.utils.concurrent.PeriodicRunnable;
import org.jitsi.utils.concurrent.RecurringRunnable;
import org.jitsi.utils.concurrent.RecurringRunnableExecutor;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.AbstractEndpoint;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Videobridge;
import org.jitsi.videobridge.VideobridgeExpireThreadConfig;

public class VideobridgeExpireThread {
    private static final Logger logger = new LoggerImpl(VideobridgeExpireThread.class.getName());
    private static final RecurringRunnableExecutor EXECUTOR = new RecurringRunnableExecutor(VideobridgeExpireThread.class.getSimpleName());
    private static final Executor EXPIRE_EXECUTOR = ExecutorUtils.newCachedThreadPool((boolean)true, (String)(VideobridgeExpireThread.class.getSimpleName() + "-channel"));
    private PeriodicRunnable expireRunnable;
    private Videobridge videobridge;

    public VideobridgeExpireThread(Videobridge videobridge) {
        this.videobridge = Objects.requireNonNull(videobridge);
    }

    void start() {
        Duration expireCheckSleepDuration = VideobridgeExpireThreadConfig.config.getInterval();
        logger.info((Object)("Starting with " + expireCheckSleepDuration.getSeconds() + " second interval."));
        this.expireRunnable = new PeriodicRunnable(expireCheckSleepDuration.toMillis()){

            public void run() {
                super.run();
                Videobridge videobridge = VideobridgeExpireThread.this.videobridge;
                if (videobridge != null) {
                    VideobridgeExpireThread.this.expire(videobridge);
                }
            }
        };
        EXECUTOR.registerRecurringRunnable((RecurringRunnable)this.expireRunnable);
    }

    void stop() {
        logger.info((Object)"Stopping.");
        if (this.expireRunnable != null) {
            EXECUTOR.deRegisterRecurringRunnable((RecurringRunnable)this.expireRunnable);
        }
        this.expireRunnable = null;
        this.videobridge = null;
    }

    private void expire(Videobridge videobridge) {
        logger.debug((Object)"Running expire()");
        for (Conference conference : videobridge.getConferences()) {
            if (conference.shouldExpire()) {
                logger.info((Object)("Conference " + conference.getID() + " should expire, expiring it"));
                EXPIRE_EXECUTOR.execute(() -> videobridge.expireConference(conference));
                continue;
            }
            for (AbstractEndpoint endpoint : conference.getEndpoints()) {
                if (!endpoint.shouldExpire()) continue;
                logger.info((Object)("Expiring endpoint " + endpoint.getId()));
                EXPIRE_EXECUTOR.execute(endpoint::expire);
            }
        }
    }
}

