/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.ffmpeg;

import java.util.Collections;
import java.util.List;
import org.tinymediamanager.core.FeatureNotEnabledException;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.ffmpeg.FFmpegArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;

public class FFmpegTvShowArtworkProvider
extends FFmpegArtworkProvider
implements ITvShowArtworkProvider {
    @Override
    protected MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = super.createMediaProviderInfo();
        providerInfo.getConfig().addInteger("start", "", 5);
        providerInfo.getConfig().addInteger("end", "", 95);
        providerInfo.getConfig().addInteger("count", "", 10);
        providerInfo.getConfig().addLabel("type", "");
        providerInfo.getConfig().addBoolean("episodeThumb", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    @Override
    protected String getSubId() {
        return "tvshow_artwork";
    }

    @Override
    protected boolean isFanartEnabled() {
        return false;
    }

    @Override
    protected boolean isThumbEnabled() {
        return Boolean.TRUE.equals(this.getProviderInfo().getConfig().getValueAsBool("episodeThumb"));
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (!this.isActive()) {
            throw new ScrapeException(new FeatureNotEnabledException(this));
        }
        if (options.getMediaType() != MediaType.TV_EPISODE) {
            return Collections.emptyList();
        }
        if (!this.isThumbEnabled()) {
            return Collections.emptyList();
        }
        if (options.getArtworkType() != MediaArtwork.MediaArtworkType.THUMB && options.getArtworkType() != MediaArtwork.MediaArtworkType.ALL) {
            return Collections.emptyList();
        }
        return super.getArtwork(options);
    }
}

