/*
 * Decompiled with CFR 0.152.
 */
package org.ahocorasick.interval;

import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.ahocorasick.interval.IntervalNode;
import org.ahocorasick.interval.Intervalable;
import org.ahocorasick.interval.IntervalableComparatorByPosition;
import org.ahocorasick.interval.IntervalableComparatorBySize;

public class IntervalTree {
    private final IntervalNode rootNode;

    public IntervalTree(List<Intervalable> intervals) {
        this.rootNode = new IntervalNode(intervals);
    }

    public List<Intervalable> removeOverlaps(List<Intervalable> intervals) {
        Collections.sort(intervals, new IntervalableComparatorBySize());
        TreeSet<Intervalable> removeIntervals = new TreeSet<Intervalable>();
        for (Intervalable interval : intervals) {
            if (removeIntervals.contains(interval)) continue;
            removeIntervals.addAll(this.findOverlaps(interval));
        }
        for (Intervalable removeInterval : removeIntervals) {
            intervals.remove(removeInterval);
        }
        Collections.sort(intervals, new IntervalableComparatorByPosition());
        return intervals;
    }

    public List<Intervalable> findOverlaps(Intervalable interval) {
        return this.rootNode.findOverlaps(interval);
    }
}

