/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.core.utils;

import java.io.File;
import org.verapdf.core.VeraPDFException;
import org.verapdf.core.utils.FileOutputMapper;

abstract class AbstractFileOutputMapper
implements FileOutputMapper {
    protected static final String defaultPrefix = "veraPDF_";
    protected static final String defaultSuffix = "";
    protected static final String extSplitter = ".";
    private final String prefix;
    private final String suffix;

    protected AbstractFileOutputMapper() {
        this(defaultPrefix);
    }

    protected AbstractFileOutputMapper(String prefix) {
        this(prefix, defaultSuffix);
    }

    protected AbstractFileOutputMapper(String prefix, String suffix) {
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public File mapFile(File orig) throws VeraPDFException {
        return this.doMapFile(orig);
    }

    protected abstract File doMapFile(File var1) throws VeraPDFException;

    protected static String addPrefixAndSuffix(File orig, FileOutputMapper mapper) {
        if (orig == null) {
            throw new NullPointerException("Arg orig can not be null.");
        }
        String filename = orig.getName();
        String newName = mapper.getPrefix() + filename;
        newName = !mapper.getSuffix().isEmpty() && !AbstractFileOutputMapper.isExtension(mapper) && AbstractFileOutputMapper.hasExtension(filename) ? newName.substring(0, newName.lastIndexOf(extSplitter)) + mapper.getSuffix() + filename.substring(filename.lastIndexOf(extSplitter)) : newName + mapper.getSuffix();
        return newName;
    }

    private static boolean isExtension(FileOutputMapper toTest) {
        return toTest.getSuffix().startsWith(extSplitter);
    }

    private static boolean hasExtension(String filename) {
        return filename.lastIndexOf(extSplitter) > 0;
    }

    public String toString() {
        return "AbstractFileOutputMapper [prefix=" + this.prefix + ", suffix=" + this.suffix + "]";
    }
}

