/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.Connection;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelDataManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;

public interface IForgeBlockEntity
extends ICapabilityProvider {
    public static final AABB INFINITE_EXTENT_AABB = new AABB(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    private BlockEntity self() {
        return (BlockEntity)this;
    }

    default public void onDataPacket(Connection connection, ValueInput data, HolderLookup.Provider lookup) {
        this.self().loadWithComponents(data);
    }

    default public void handleUpdateTag(ValueInput tag, HolderLookup.Provider holders) {
        this.self().loadWithComponents(tag);
    }

    default public void onChunkUnloaded() {
    }

    default public void onLoad() {
        this.requestModelDataUpdate();
    }

    default public AABB getRenderBoundingBox() {
        AABB bb = INFINITE_EXTENT_AABB;
        BlockState state = this.self().getBlockState();
        Block block = state.getBlock();
        BlockPos pos = this.self().getBlockPos();
        if (block == Blocks.ENCHANTING_TABLE) {
            bb = new AABB(pos);
        } else if (block == Blocks.CHEST || block == Blocks.TRAPPED_CHEST) {
            bb = AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 0, 1));
        } else if (block == Blocks.STRUCTURE_BLOCK) {
            bb = INFINITE_EXTENT_AABB;
        } else if (block != null && block != Blocks.BEACON && block != Blocks.TEST_INSTANCE_BLOCK) {
            AABB cbb = null;
            try {
                VoxelShape collisionShape = state.getCollisionShape((BlockGetter)this.self().getLevel(), pos);
                if (!collisionShape.isEmpty()) {
                    cbb = collisionShape.bounds().move(pos);
                }
            }
            catch (Exception e) {
                cbb = AABB.encapsulatingFullBlocks((BlockPos)pos.offset(-1, 0, -1), (BlockPos)pos.offset(1, 1, 1));
            }
            if (cbb != null) {
                bb = cbb;
            }
        }
        return bb;
    }

    default public void requestModelDataUpdate() {
        ModelDataManager modelDataManager;
        BlockEntity te = this.self();
        Level level = te.getLevel();
        if (level != null && level.isClientSide() && (modelDataManager = level.getModelDataManager()) != null) {
            modelDataManager.requestRefresh(te);
        }
    }

    @NotNull
    default public ModelData getModelData() {
        return ModelData.EMPTY;
    }

    default public boolean hasCustomOutlineRendering() {
        return false;
    }
}

