/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fart.api;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Optional;
import net.minecraftforge.fart.internal.ClassLoaderClassProvider;
import net.minecraftforge.fart.internal.ClassProviderBuilderImpl;
import org.jetbrains.annotations.Nullable;

public interface ClassProvider
extends Closeable {
    public static Builder builder() {
        return new ClassProviderBuilderImpl();
    }

    public static ClassProvider fromPaths(Path ... paths) {
        Builder builder = ClassProvider.builder().shouldCacheAll(true);
        for (Path path : paths) {
            builder.addLibrary(path);
        }
        return builder.build();
    }

    public static ClassProvider fromJvmClasspath() {
        return new ClassLoaderClassProvider(null);
    }

    public static ClassProvider fromClassLoader(@Nullable ClassLoader classLoader) {
        return new ClassLoaderClassProvider(classLoader);
    }

    public Optional<? extends IClassInfo> getClass(String var1);

    public static interface IMethodInfo {
        public int getAccess();

        public String getName();

        public String getDescriptor();
    }

    public static interface IFieldInfo {
        public int getAccess();

        public String getName();

        public String getDescriptor();
    }

    public static interface IClassInfo {
        public int getAccess();

        public String getName();

        @Nullable
        public String getSuper();

        public Collection<String> getInterfaces();

        public Collection<? extends IFieldInfo> getFields();

        public Optional<? extends IFieldInfo> getField(String var1);

        public Collection<? extends IMethodInfo> getMethods();

        public Optional<? extends IMethodInfo> getMethod(String var1, String var2);
    }

    public static interface Builder {
        public Builder addLibrary(Path var1);

        public Builder addClass(String var1, byte[] var2);

        public Builder shouldCacheAll(boolean var1);

        public ClassProvider build();
    }
}

