// Copyright The prometheus-operator Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// NativeHistogramConfigApplyConfiguration represents a declarative configuration of the NativeHistogramConfig type for use
// with apply.
type NativeHistogramConfigApplyConfiguration struct {
	ScrapeClassicHistograms        *bool              `json:"scrapeClassicHistograms,omitempty"`
	NativeHistogramBucketLimit     *uint64            `json:"nativeHistogramBucketLimit,omitempty"`
	NativeHistogramMinBucketFactor *resource.Quantity `json:"nativeHistogramMinBucketFactor,omitempty"`
	ConvertClassicHistogramsToNHCB *bool              `json:"convertClassicHistogramsToNHCB,omitempty"`
}

// NativeHistogramConfigApplyConfiguration constructs a declarative configuration of the NativeHistogramConfig type for use with
// apply.
func NativeHistogramConfig() *NativeHistogramConfigApplyConfiguration {
	return &NativeHistogramConfigApplyConfiguration{}
}

// WithScrapeClassicHistograms sets the ScrapeClassicHistograms field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ScrapeClassicHistograms field is set to the value of the last call.
func (b *NativeHistogramConfigApplyConfiguration) WithScrapeClassicHistograms(value bool) *NativeHistogramConfigApplyConfiguration {
	b.ScrapeClassicHistograms = &value
	return b
}

// WithNativeHistogramBucketLimit sets the NativeHistogramBucketLimit field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NativeHistogramBucketLimit field is set to the value of the last call.
func (b *NativeHistogramConfigApplyConfiguration) WithNativeHistogramBucketLimit(value uint64) *NativeHistogramConfigApplyConfiguration {
	b.NativeHistogramBucketLimit = &value
	return b
}

// WithNativeHistogramMinBucketFactor sets the NativeHistogramMinBucketFactor field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the NativeHistogramMinBucketFactor field is set to the value of the last call.
func (b *NativeHistogramConfigApplyConfiguration) WithNativeHistogramMinBucketFactor(value resource.Quantity) *NativeHistogramConfigApplyConfiguration {
	b.NativeHistogramMinBucketFactor = &value
	return b
}

// WithConvertClassicHistogramsToNHCB sets the ConvertClassicHistogramsToNHCB field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ConvertClassicHistogramsToNHCB field is set to the value of the last call.
func (b *NativeHistogramConfigApplyConfiguration) WithConvertClassicHistogramsToNHCB(value bool) *NativeHistogramConfigApplyConfiguration {
	b.ConvertClassicHistogramsToNHCB = &value
	return b
}
