/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.allocation;

import java.time.Clock;
import java.time.Duration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.nlj.DebugStateMode;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.format.PayloadType;
import org.jitsi.nlj.format.PayloadTypeEncoding;
import org.jitsi.nlj.util.Bandwidth;
import org.jitsi.nlj.util.BandwidthKt;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.utils.event.EventEmitter;
import org.jitsi.utils.event.SyncEventEmitter;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.allocation.AllocationSettings;
import org.jitsi.videobridge.cc.allocation.AllocationSettingsWrapper;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocation;
import org.jitsi.videobridge.cc.allocation.BandwidthAllocator;
import org.jitsi.videobridge.cc.allocation.BitrateControllerStatusSnapshot;
import org.jitsi.videobridge.cc.allocation.MediaSourceContainer;
import org.jitsi.videobridge.cc.allocation.PacketHandler;
import org.jitsi.videobridge.cc.allocation.SingleAllocation;
import org.jitsi.videobridge.cc.allocation.VideoConstraints;
import org.jitsi.videobridge.cc.config.BitrateControllerConfig;
import org.jitsi.videobridge.message.ReceiverVideoConstraintsMessage;
import org.jitsi.videobridge.util.BooleanStateTimeTracker;
import org.json.simple.JSONObject;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0002cdB?\b\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010,\u001a\u00020'J\u0006\u00107\u001a\u000208J\u0006\u0010?\u001a\u000208J\u0006\u0010@\u001a\u000209J\u0006\u0010A\u001a\u00020BJ\u0006\u0010C\u001a\u00020'J\u000e\u0010D\u001a\u0002082\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020'2\u0006\u0010H\u001a\u00020IJ\u000e\u0010G\u001a\u00020'2\u0006\u0010J\u001a\u00020KJ\u000e\u0010L\u001a\u00020'2\u0006\u0010J\u001a\u00020KJ\u000e\u0010M\u001a\u00020'2\u0006\u0010H\u001a\u00020IJ\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020QJ\u000e\u0010R\u001a\u0002082\u0006\u0010S\u001a\u00020TJ\u000e\u0010U\u001a\u0002082\u0006\u0010V\u001a\u00020WJ\u000e\u0010X\u001a\u00020'2\u0006\u0010Y\u001a\u00020ZJ\u000e\u0010[\u001a\u00020'2\u0006\u0010Y\u001a\u00020ZJ\u0006\u0010\\\u001a\u00020]J\u0014\u0010^\u001a\u000208*\u00020#2\u0006\u0010_\u001a\u00020FH\u0002J\u0014\u0010`\u001a\u000208*\u00020#2\u0006\u0010a\u001a\u00020bH\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\f0\u0017R\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000+X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u0002008F\u00a2\u0006\u0006\u001a\u0004\b1\u00102R\u000e\u00103\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R$\u0010:\u001a\u0002092\u0006\u0010\u0018\u001a\u0002098F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>\u00a8\u0006e"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController;", "T", "Lorg/jitsi/videobridge/cc/allocation/MediaSourceContainer;", "", "eventHandler", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "endpointsSupplier", "Ljava/util/function/Supplier;", "", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "clock", "Ljava/time/Clock;", "<init>", "(Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;Ljava/util/function/Supplier;Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/utils/logging2/Logger;Ljava/time/Clock;)V", "eventEmitter", "Lorg/jitsi/utils/event/SyncEventEmitter;", "getEventEmitter", "()Lorg/jitsi/utils/event/SyncEventEmitter;", "logger", "bitrateAllocatorEventHandler", "Lorg/jitsi/videobridge/cc/allocation/BitrateController$BitrateAllocatorEventHandler;", "value", "", "", "forwardedSources", "getForwardedSources", "()Ljava/util/Set;", "oversendingTimeTracker", "Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "getOversendingTimeTracker", "()Lorg/jitsi/videobridge/util/BooleanStateTimeTracker;", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "getTimeSeriesLogger", "()Lorg/jitsi/utils/logging/TimeSeriesLogger;", "supportsRtx", "", "packetHandler", "Lorg/jitsi/videobridge/cc/allocation/PacketHandler;", "bandwidthAllocator", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator;", "hasSuspendedSources", "allocationSettingsWrapper", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettingsWrapper;", "allocationSettings", "Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "getAllocationSettings", "()Lorg/jitsi/videobridge/cc/allocation/AllocationSettings;", "bweSet", "trustBwe", "getTrustBwe", "()Z", "endpointOrderingChanged", "", "", "lastN", "getLastN", "()I", "setLastN", "(I)V", "expire", "numForwardedSources", "getTotalOversendingTime", "Ljava/time/Duration;", "isOversending", "bandwidthChanged", "newBandwidthBps", "", "accept", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "transformRtcp", "transformRtp", "debugState", "Lorg/json/simple/JSONObject;", "mode", "Lorg/jitsi/nlj/DebugStateMode;", "addPayloadType", "payloadType", "Lorg/jitsi/nlj/format/PayloadType;", "setBandwidthAllocationSettings", "message", "Lorg/jitsi/videobridge/message/ReceiverVideoConstraintsMessage;", "isOnStageOrSelected", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "hasNonZeroEffectiveConstraints", "getStatusSnapshot", "Lorg/jitsi/videobridge/cc/allocation/BitrateControllerStatusSnapshot;", "logBweChange", "newBweBps", "logAllocationChange", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "EventHandler", "BitrateAllocatorEventHandler", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nBitrateController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitrateController.kt\norg/jitsi/videobridge/cc/allocation/BitrateController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,336:1\n1869#2:337\n1870#2:339\n1869#2,2:340\n1#3:338\n*S KotlinDebug\n*F\n+ 1 BitrateController.kt\norg/jitsi/videobridge/cc/allocation/BitrateController\n*L\n205#1:337\n205#1:339\n250#1:340,2\n*E\n"})
public final class BitrateController<T extends MediaSourceContainer> {
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Clock clock;
    @NotNull
    private final SyncEventEmitter<EventHandler> eventEmitter;
    @NotNull
    private final Logger logger;
    @NotNull
    private final BitrateAllocatorEventHandler bitrateAllocatorEventHandler;
    @NotNull
    private Set<String> forwardedSources;
    @NotNull
    private final BooleanStateTimeTracker oversendingTimeTracker;
    @Nullable
    private final TimeSeriesLogger timeSeriesLogger;
    private boolean supportsRtx;
    @NotNull
    private final PacketHandler packetHandler;
    @NotNull
    private final BandwidthAllocator<T> bandwidthAllocator;
    @NotNull
    private final AllocationSettingsWrapper allocationSettingsWrapper;
    private boolean bweSet;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public BitrateController(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger, @NotNull Clock clock) {
        void it;
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, (String)"endpointsSupplier");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        this.diagnosticContext = diagnosticContext;
        this.clock = clock;
        this.eventEmitter = new SyncEventEmitter();
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.bitrateAllocatorEventHandler = new BitrateAllocatorEventHandler();
        this.forwardedSources = SetsKt.emptySet();
        this.oversendingTimeTracker = new BooleanStateTimeTracker(false, null, 3, null);
        TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(BitrateController.class);
        BitrateController bitrateController2 = this;
        boolean bl = false;
        bitrateController2.timeSeriesLogger = it.isTraceEnabled() ? it : null;
        this.packetHandler = new PacketHandler(this.clock, parentLogger, this.diagnosticContext, (EventEmitter<EventHandler>)((EventEmitter)this.eventEmitter));
        this.bandwidthAllocator = new BandwidthAllocator<T>(this.bitrateAllocatorEventHandler, endpointsSupplier, () -> BitrateController.bandwidthAllocator$lambda$0(this), parentLogger, this.diagnosticContext, this.clock);
        this.allocationSettingsWrapper = new AllocationSettingsWrapper(parentLogger);
        this.eventEmitter.addHandler((Object)eventHandler);
    }

    public /* synthetic */ BitrateController(EventHandler eventHandler, Supplier supplier, DiagnosticContext diagnosticContext, Logger logger, Clock clock, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            Clock clock2 = Clock.systemUTC();
            Intrinsics.checkNotNullExpressionValue((Object)clock2, (String)"systemUTC(...)");
            clock = clock2;
        }
        this(eventHandler, supplier, diagnosticContext, logger, clock);
    }

    @NotNull
    public final SyncEventEmitter<EventHandler> getEventEmitter() {
        return this.eventEmitter;
    }

    @NotNull
    public final Set<String> getForwardedSources() {
        return this.forwardedSources;
    }

    @NotNull
    public final BooleanStateTimeTracker getOversendingTimeTracker() {
        return this.oversendingTimeTracker;
    }

    @Nullable
    public final TimeSeriesLogger getTimeSeriesLogger() {
        return this.timeSeriesLogger;
    }

    public final boolean hasSuspendedSources() {
        return this.bandwidthAllocator.getAllocation().getHasSuspendedSources();
    }

    @NotNull
    public final AllocationSettings getAllocationSettings() {
        return this.allocationSettingsWrapper.get();
    }

    private final boolean getTrustBwe() {
        return BitrateControllerConfig.config.getTrustBwe() && this.supportsRtx && this.bweSet && this.packetHandler.timeSinceFirstMedia().compareTo(BitrateControllerConfig.config.getInitialIgnoreBwePeriod()) >= 0;
    }

    public final void endpointOrderingChanged() {
        this.bandwidthAllocator.update();
    }

    public final int getLastN() {
        return this.allocationSettingsWrapper.getLastN$jitsi_videobridge();
    }

    public final void setLastN(int value) {
        if (this.allocationSettingsWrapper.setLastN(value)) {
            this.bandwidthAllocator.update(this.allocationSettingsWrapper.get());
        }
    }

    public final void expire() {
        this.bandwidthAllocator.expire();
    }

    public final int numForwardedSources() {
        return this.forwardedSources.size();
    }

    @NotNull
    public final Duration getTotalOversendingTime() {
        return this.oversendingTimeTracker.totalTimeOn();
    }

    public final boolean isOversending() {
        return this.oversendingTimeTracker.getState();
    }

    public final void bandwidthChanged(long newBandwidthBps) {
        this.bweSet = true;
        TimeSeriesLogger timeSeriesLogger = this.timeSeriesLogger;
        if (timeSeriesLogger != null) {
            this.logBweChange(timeSeriesLogger, newBandwidthBps);
        }
        this.bandwidthAllocator.bandwidthChanged(newBandwidthBps);
    }

    public final boolean accept(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        if (packetInfo.getLayeringChanged()) {
            this.logger.debug(() -> BitrateController.accept$lambda$0(packetInfo));
            this.bandwidthAllocator.update();
        }
        return this.packetHandler.accept(packetInfo);
    }

    public final boolean accept(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter((Object)rtcpSrPacket, (String)"rtcpSrPacket");
        return this.packetHandler.accept(rtcpSrPacket);
    }

    public final boolean transformRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter((Object)rtcpSrPacket, (String)"rtcpSrPacket");
        return this.packetHandler.transformRtcp(rtcpSrPacket);
    }

    public final boolean transformRtp(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter((Object)packetInfo, (String)"packetInfo");
        return this.packetHandler.transformRtp(packetInfo);
    }

    @NotNull
    public final JSONObject debugState(@NotNull DebugStateMode mode) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        JSONObject $this$debugState_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$debugState_u24lambda_u240.put((Object)"bitrate_allocator", (Object)this.bandwidthAllocator.getDebugState());
        $this$debugState_u24lambda_u240.put((Object)"packet_handler", (Object)this.packetHandler.debugState(mode));
        $this$debugState_u24lambda_u240.put((Object)"forwarded_sources", (Object)this.forwardedSources.toString());
        $this$debugState_u24lambda_u240.put((Object)"oversending", (Object)this.oversendingTimeTracker.getState());
        $this$debugState_u24lambda_u240.put((Object)"total_oversending_time_secs", (Object)this.oversendingTimeTracker.totalTimeOn().getSeconds());
        $this$debugState_u24lambda_u240.put((Object)"supports_rtx", (Object)this.supportsRtx);
        $this$debugState_u24lambda_u240.put((Object)"trust_bwe", (Object)this.getTrustBwe());
        return jSONObject;
    }

    public final void addPayloadType(@NotNull PayloadType payloadType) {
        Intrinsics.checkNotNullParameter((Object)payloadType, (String)"payloadType");
        if (payloadType.getEncoding() == PayloadTypeEncoding.RTX) {
            this.supportsRtx = true;
        }
    }

    public final void setBandwidthAllocationSettings(@NotNull ReceiverVideoConstraintsMessage message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.allocationSettingsWrapper.setBandwidthAllocationSettings(message)) {
            this.bandwidthAllocator.update(this.allocationSettingsWrapper.get());
        }
    }

    public final boolean isOnStageOrSelected(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.getAllocationSettings().getOnStageSources().contains(source.getSourceName()) || this.getAllocationSettings().getSelectedSources().contains(source.getSourceName());
    }

    public final boolean hasNonZeroEffectiveConstraints(@NotNull MediaSourceDesc source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return this.bandwidthAllocator.hasNonZeroEffectiveConstraints$jitsi_videobridge(source);
    }

    @NotNull
    public final BitrateControllerStatusSnapshot getStatusSnapshot() {
        long totalTargetBitrate = 0L;
        totalTargetBitrate = BandwidthKt.getBps((int)0);
        long totalIdealBitrate = 0L;
        totalIdealBitrate = BandwidthKt.getBps((int)0);
        Set activeSsrcs = new LinkedHashSet();
        boolean hasNonIdealLayer = false;
        long nowMs = this.clock.instant().toEpochMilli();
        BandwidthAllocation allocation = this.bandwidthAllocator.getAllocation();
        Iterable $this$forEach$iv = allocation.getAllocations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpLayerDesc allocationIdealBitrate;
            Object object;
            Bandwidth allocationTargetBitrate;
            SingleAllocation singleAllocation = (SingleAllocation)element$iv;
            boolean bl = false;
            RtpLayerDesc rtpLayerDesc = singleAllocation.getTargetLayer();
            Bandwidth bandwidth = allocationTargetBitrate = rtpLayerDesc != null ? Bandwidth.box-impl((long)rtpLayerDesc.getBitrate-WElJv5I(nowMs)) : null;
            if (bandwidth != null) {
                long it = bandwidth.unbox-impl();
                boolean bl2 = false;
                totalTargetBitrate = Bandwidth.plus-GI7mN98((long)totalTargetBitrate, (long)it);
                MediaSourceDesc mediaSourceDesc = singleAllocation.getMediaSource();
                if (mediaSourceDesc != null) {
                    long primarySsrc = mediaSourceDesc.getPrimarySSRC();
                    boolean bl3 = false;
                    activeSsrcs.add(primarySsrc);
                }
            }
            if (BitrateControllerConfig.config.getUseVlaTargetBitrate()) {
                object = singleAllocation.getIdealLayer();
                if (object == null || (object = object.getTargetBitrate-4yB3KFE()) == null) {
                    RtpLayerDesc rtpLayerDesc2 = singleAllocation.getIdealLayer();
                    object = rtpLayerDesc2 != null ? Bandwidth.box-impl((long)rtpLayerDesc2.getBitrate-WElJv5I(nowMs)) : null;
                }
            } else {
                RtpLayerDesc rtpLayerDesc3 = singleAllocation.getIdealLayer();
                object = rtpLayerDesc3 != null ? Bandwidth.box-impl((long)rtpLayerDesc3.getBitrate-WElJv5I(nowMs)) : null;
            }
            RtpLayerDesc rtpLayerDesc4 = allocationIdealBitrate = object;
            if (rtpLayerDesc4 != null) {
                long it = rtpLayerDesc4.unbox-impl();
                boolean bl4 = false;
                totalIdealBitrate = Bandwidth.plus-GI7mN98((long)totalIdealBitrate, (long)it);
            }
            if (singleAllocation.getIdealLayer() == null || Intrinsics.areEqual((Object)singleAllocation.getIdealLayer(), (Object)singleAllocation.getTargetLayer())) continue;
            hasNonIdealLayer = true;
        }
        activeSsrcs.removeIf(arg_0 -> BitrateController.getStatusSnapshot$lambda$2(BitrateController::getStatusSnapshot$lambda$1, arg_0));
        return new BitrateControllerStatusSnapshot(totalTargetBitrate, totalIdealBitrate, activeSsrcs, hasNonIdealLayer);
    }

    private final void logBweChange(TimeSeriesLogger $this$logBweChange, long newBweBps) {
        $this$logBweChange.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("new_bwe").addField("bwe_bps", (Object)newBweBps));
    }

    private final void logAllocationChange(TimeSeriesLogger $this$logAllocationChange, BandwidthAllocation allocation) {
        long nowMs = this.clock.millis();
        double totalTargetBps = 0.0;
        double totalIdealBps = 0.0;
        double totalTargetVlaBps = 0.0;
        double totalIdealVlaBps = 0.0;
        Iterable $this$forEach$iv = allocation.getAllocations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpLayerDesc rtpLayerDesc;
            RtpLayerDesc rtpLayerDesc2;
            RtpLayerDesc rtpLayerDesc3;
            long bitrate;
            RtpLayerDesc rtpLayerDesc4;
            long bitrate2;
            SingleAllocation it = (SingleAllocation)element$iv;
            boolean bl = false;
            RtpLayerDesc rtpLayerDesc5 = it.getTargetLayer();
            if (rtpLayerDesc5 != null) {
                bitrate2 = rtpLayerDesc5.getBitrate-WElJv5I(nowMs);
                boolean bl2 = false;
                totalTargetBps += (double)bitrate2;
            }
            RtpLayerDesc rtpLayerDesc6 = it.getIdealLayer();
            if (rtpLayerDesc6 != null) {
                bitrate2 = rtpLayerDesc6.getBitrate-WElJv5I(nowMs);
                boolean bl3 = false;
                totalIdealBps += (double)bitrate2;
            }
            if ((rtpLayerDesc4 = it.getTargetLayer()) != null && (rtpLayerDesc4 = rtpLayerDesc4.getTargetBitrate-4yB3KFE()) != null) {
                bitrate = rtpLayerDesc4.unbox-impl();
                boolean bl4 = false;
                totalTargetVlaBps += (double)bitrate;
            }
            if ((rtpLayerDesc3 = it.getIdealLayer()) != null && (rtpLayerDesc3 = rtpLayerDesc3.getTargetBitrate-4yB3KFE()) != null) {
                bitrate = rtpLayerDesc3.unbox-impl();
                boolean bl5 = false;
                totalIdealVlaBps += (double)bitrate;
            }
            RtpLayerDesc rtpLayerDesc7 = it.getTargetLayer();
            RtpLayerDesc rtpLayerDesc8 = it.getIdealLayer();
            RtpLayerDesc rtpLayerDesc9 = it.getTargetLayer();
            RtpLayerDesc rtpLayerDesc10 = it.getIdealLayer();
            $this$logAllocationChange.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("allocation_for_source", nowMs).addField("remote_endpoint_id", (Object)it.getEndpointId()).addField("target_idx", (Object)(rtpLayerDesc7 != null ? rtpLayerDesc7.getIndex() : -1)).addField("ideal_idx", (Object)(rtpLayerDesc8 != null ? rtpLayerDesc8.getIndex() : -1)).addField("target_bps_measured", (Object)(rtpLayerDesc9 != null ? rtpLayerDesc9.getBitrate-WElJv5I(nowMs) : -1L)).addField("target_bps_vla", (Object)((rtpLayerDesc2 = it.getTargetLayer()) != null && (rtpLayerDesc2 = rtpLayerDesc2.getTargetBitrate-4yB3KFE()) != null ? rtpLayerDesc2.unbox-impl() : -1L)).addField("ideal_bps_measured", (Object)(rtpLayerDesc10 != null ? rtpLayerDesc10.getBitrate-WElJv5I(nowMs) : -1L)).addField("ideal_bps_vla", (Object)((rtpLayerDesc = it.getIdealLayer()) != null && (rtpLayerDesc = rtpLayerDesc.getTargetBitrate-4yB3KFE()) != null ? rtpLayerDesc.unbox-impl() : -1L)));
        }
        $this$logAllocationChange.trace((Map)this.diagnosticContext.makeTimeSeriesPoint("allocation", nowMs).addField("total_target_measured_bps", (Object)totalTargetBps).addField("total_ideal_measured_bps", (Object)totalIdealBps).addField("total_target_vla_bps", (Object)totalTargetVlaBps).addField("total_ideal_vla_bps", (Object)totalIdealVlaBps));
    }

    @JvmOverloads
    public BitrateController(@NotNull EventHandler eventHandler, @NotNull Supplier<List<T>> endpointsSupplier, @NotNull DiagnosticContext diagnosticContext, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter(endpointsSupplier, (String)"endpointsSupplier");
        Intrinsics.checkNotNullParameter((Object)diagnosticContext, (String)"diagnosticContext");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        this(eventHandler, endpointsSupplier, diagnosticContext, parentLogger, null, 16, null);
    }

    private static final Boolean bandwidthAllocator$lambda$0(BitrateController this$0) {
        return this$0.getTrustBwe();
    }

    private static final String accept$lambda$0(PacketInfo $packetInfo) {
        return "Layering information changed for packet from " + $packetInfo.getEndpointId() + ", updating bandwidth allocation";
    }

    private static final boolean getStatusSnapshot$lambda$1(Long it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it < 0L;
    }

    private static final boolean getStatusSnapshot$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J8\u0010\b\u001a\u00020\u00052\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\r2\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nj\u0002`\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController$BitrateAllocatorEventHandler;", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocator$EventHandler;", "<init>", "(Lorg/jitsi/videobridge/cc/allocation/BitrateController;)V", "allocationChanged", "", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "newEffectiveConstraints", "jitsi-videobridge"})
    private final class BitrateAllocatorEventHandler
    implements BandwidthAllocator.EventHandler {
        @Override
        public void allocationChanged(@NotNull BandwidthAllocation allocation) {
            Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
            TimeSeriesLogger timeSeriesLogger = BitrateController.this.getTimeSeriesLogger();
            if (timeSeriesLogger != null) {
                BitrateController.this.logAllocationChange(timeSeriesLogger, allocation);
            }
            BitrateController.this.packetHandler.allocationChanged(allocation);
            Set<String> newForwardedSources = allocation.getForwardedSources();
            if (!Intrinsics.areEqual(BitrateController.this.getForwardedSources(), newForwardedSources)) {
                BitrateController.this.forwardedSources = newForwardedSources;
                BitrateController.this.getEventEmitter().fireEvent(arg_0 -> BitrateAllocatorEventHandler.allocationChanged$lambda$0(newForwardedSources, arg_0));
            }
            BitrateController.this.getOversendingTimeTracker().setState(allocation.getOversending());
            BitrateController.this.getEventEmitter().fireEvent(arg_0 -> BitrateAllocatorEventHandler.allocationChanged$lambda$1(allocation, arg_0));
        }

        @Override
        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> oldEffectiveConstraints, @NotNull Map<MediaSourceDesc, VideoConstraints> newEffectiveConstraints) {
            Intrinsics.checkNotNullParameter(oldEffectiveConstraints, (String)"oldEffectiveConstraints");
            Intrinsics.checkNotNullParameter(newEffectiveConstraints, (String)"newEffectiveConstraints");
            BitrateController.this.getEventEmitter().fireEvent(arg_0 -> BitrateAllocatorEventHandler.effectiveVideoConstraintsChanged$lambda$0(oldEffectiveConstraints, newEffectiveConstraints, arg_0));
        }

        private static final Unit allocationChanged$lambda$0(Set $newForwardedSources, EventHandler $this$fireEvent) {
            Intrinsics.checkNotNullParameter((Object)$this$fireEvent, (String)"$this$fireEvent");
            $this$fireEvent.forwardedSourcesChanged($newForwardedSources);
            return Unit.INSTANCE;
        }

        private static final Unit allocationChanged$lambda$1(BandwidthAllocation $allocation, EventHandler $this$fireEvent) {
            Intrinsics.checkNotNullParameter((Object)$this$fireEvent, (String)"$this$fireEvent");
            $this$fireEvent.allocationChanged($allocation);
            return Unit.INSTANCE;
        }

        private static final Unit effectiveVideoConstraintsChanged$lambda$0(Map $oldEffectiveConstraints, Map $newEffectiveConstraints, EventHandler $this$fireEvent) {
            Intrinsics.checkNotNullParameter((Object)$this$fireEvent, (String)"$this$fireEvent");
            $this$fireEvent.effectiveVideoConstraintsChanged($oldEffectiveConstraints, $newEffectiveConstraints);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0016\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H&J8\u0010\u0007\u001a\u00020\u00032\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\f2\u0016\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u0002`\fH&J\u001a\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\u0011H&J\u0010\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015\u00c0\u0006\u0003"}, d2={"Lorg/jitsi/videobridge/cc/allocation/BitrateController$EventHandler;", "", "forwardedSourcesChanged", "", "forwardedSources", "", "", "effectiveVideoConstraintsChanged", "oldEffectiveConstraints", "", "Lorg/jitsi/nlj/MediaSourceDesc;", "Lorg/jitsi/videobridge/cc/allocation/VideoConstraints;", "Lorg/jitsi/videobridge/cc/allocation/EffectiveConstraintsMap;", "newEffectiveConstraints", "keyframeNeeded", "endpointId", "ssrc", "", "allocationChanged", "allocation", "Lorg/jitsi/videobridge/cc/allocation/BandwidthAllocation;", "jitsi-videobridge"})
    public static interface EventHandler {
        public void forwardedSourcesChanged(@NotNull Set<String> var1);

        public void effectiveVideoConstraintsChanged(@NotNull Map<MediaSourceDesc, VideoConstraints> var1, @NotNull Map<MediaSourceDesc, VideoConstraints> var2);

        public void keyframeNeeded(@Nullable String var1, long var2);

        default public void allocationChanged(@NotNull BandwidthAllocation allocation) {
            Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static void allocationChanged(@NotNull EventHandler $this, @NotNull BandwidthAllocation allocation) {
                Intrinsics.checkNotNullParameter((Object)allocation, (String)"allocation");
                $this.allocationChanged(allocation);
            }
        }
    }
}

