/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.dtls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bouncycastle.tls.Certificate;
import org.bouncycastle.tls.DTLSClientProtocol;
import org.bouncycastle.tls.DTLSTransport;
import org.bouncycastle.tls.DatagramTransport;
import org.bouncycastle.tls.TlsClient;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.dtls.CertificateInfo;
import org.jitsi.nlj.dtls.DtlsRole;
import org.jitsi.nlj.dtls.TlsClientImpl;
import org.jitsi.nlj.srtp.TlsRole;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007\u0012\u0016\b\u0002\u0010\f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0012\u0004\u0012\u00020\u000b0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jitsi/nlj/dtls/DtlsClient;", "Lorg/jitsi/nlj/dtls/DtlsRole;", "datagramTransport", "Lorg/bouncycastle/tls/DatagramTransport;", "certificateInfo", "Lorg/jitsi/nlj/dtls/CertificateInfo;", "handshakeCompleteHandler", "Lkotlin/Function3;", "", "Lorg/jitsi/nlj/srtp/TlsRole;", "", "", "verifyAndValidateRemoteCertificate", "Lkotlin/Function1;", "Lorg/bouncycastle/tls/Certificate;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "dtlsClientProtocol", "Lorg/bouncycastle/tls/DTLSClientProtocol;", "<init>", "(Lorg/bouncycastle/tls/DatagramTransport;Lorg/jitsi/nlj/dtls/CertificateInfo;Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function1;Lorg/jitsi/utils/logging2/Logger;Lorg/bouncycastle/tls/DTLSClientProtocol;)V", "logger", "tlsClient", "Lorg/jitsi/nlj/dtls/TlsClientImpl;", "start", "Lorg/bouncycastle/tls/DTLSTransport;", "connect", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nDtlsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DtlsClient.kt\norg/jitsi/nlj/dtls/DtlsClient\n+ 2 LoggerExtensions.kt\norg/jitsi/utils/logging2/LoggerExtensionsKt\n*L\n1#1,59:1\n63#2,4:60\n75#2,2:64\n*S KotlinDebug\n*F\n+ 1 DtlsClient.kt\norg/jitsi/nlj/dtls/DtlsClient\n*L\n46#1:60,4\n54#1:64,2\n*E\n"})
public final class DtlsClient
implements DtlsRole {
    @NotNull
    private final DatagramTransport datagramTransport;
    @NotNull
    private final Function3<Integer, TlsRole, byte[], Unit> handshakeCompleteHandler;
    @NotNull
    private final DTLSClientProtocol dtlsClientProtocol;
    @NotNull
    private final Logger logger;
    @NotNull
    private final TlsClientImpl tlsClient;

    public DtlsClient(@NotNull DatagramTransport datagramTransport, @NotNull CertificateInfo certificateInfo, @NotNull Function3<? super Integer, ? super TlsRole, ? super byte[], Unit> handshakeCompleteHandler, @NotNull Function1<? super Certificate, Unit> verifyAndValidateRemoteCertificate, @NotNull Logger parentLogger, @NotNull DTLSClientProtocol dtlsClientProtocol) {
        Intrinsics.checkNotNullParameter((Object)datagramTransport, (String)"datagramTransport");
        Intrinsics.checkNotNullParameter((Object)certificateInfo, (String)"certificateInfo");
        Intrinsics.checkNotNullParameter(handshakeCompleteHandler, (String)"handshakeCompleteHandler");
        Intrinsics.checkNotNullParameter(verifyAndValidateRemoteCertificate, (String)"verifyAndValidateRemoteCertificate");
        Intrinsics.checkNotNullParameter((Object)parentLogger, (String)"parentLogger");
        Intrinsics.checkNotNullParameter((Object)dtlsClientProtocol, (String)"dtlsClientProtocol");
        this.datagramTransport = datagramTransport;
        this.handshakeCompleteHandler = handshakeCompleteHandler;
        this.dtlsClientProtocol = dtlsClientProtocol;
        this.logger = LoggerExtensionsKt.createChildLogger$default((Object)this, (Logger)parentLogger, null, (int)2, null);
        this.tlsClient = new TlsClientImpl(certificateInfo, verifyAndValidateRemoteCertificate, this.logger);
    }

    public /* synthetic */ DtlsClient(DatagramTransport datagramTransport, CertificateInfo certificateInfo, Function3 function3, Function1 function1, Logger logger, DTLSClientProtocol dTLSClientProtocol, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function3 = DtlsClient::_init_$lambda$0;
        }
        if ((n & 8) != 0) {
            function1 = DtlsClient::_init_$lambda$1;
        }
        if ((n & 0x20) != 0) {
            dTLSClientProtocol = new DTLSClientProtocol();
        }
        this(datagramTransport, certificateInfo, (Function3<? super Integer, ? super TlsRole, ? super byte[], Unit>)function3, (Function1<? super Certificate, Unit>)function1, logger, dTLSClientProtocol);
    }

    @Override
    @NotNull
    public DTLSTransport start() {
        return this.connect();
    }

    @NotNull
    public final DTLSTransport connect() {
        try {
            DTLSTransport dTLSTransport;
            DTLSTransport it = dTLSTransport = this.dtlsClientProtocol.connect((TlsClient)this.tlsClient, this.datagramTransport);
            boolean bl = false;
            Logger $this$cdebug$iv = this.logger;
            boolean $i$f$cdebug = false;
            if ($this$cdebug$iv.isDebugEnabled()) {
                Logger logger = $this$cdebug$iv;
                boolean bl2 = false;
                logger.debug((Object)"DTLS handshake finished");
            }
            this.handshakeCompleteHandler.invoke((Object)this.tlsClient.getChosenSrtpProtectionProfile(), (Object)TlsRole.CLIENT, (Object)this.tlsClient.getSrtpKeyingMaterial());
            DTLSTransport dTLSTransport2 = dTLSTransport;
            Intrinsics.checkNotNullExpressionValue((Object)dTLSTransport2, (String)"also(...)");
            return dTLSTransport2;
        }
        catch (Exception e) {
            Logger $this$cerror$iv = this.logger;
            boolean $i$f$cerror = false;
            Logger logger = $this$cerror$iv;
            boolean bl = false;
            logger.error((Object)("Error during DTLS connection: " + e));
            throw e;
        }
    }

    private static final Unit _init_$lambda$0(int n, TlsRole tlsRole, byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)((Object)tlsRole), (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<unused var>");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Certificate it) {
        return Unit.INSTANCE;
    }
}

