/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import jakarta.xml.bind.DatatypeConverter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil {
    public static final String DEFAULT_VECTOR = "727DEC2725991751BDFE3DBD0C6BF137";
    public static final String DEFAULT_SALT = "19CAD45282FBC7627B91A57F201B69E0359AFEB15DE328A88C0A2E05585F84C9";
    public static final AesUtil DEFAULT_INSTANCE = new AesUtil(128, 10);
    private final int keySize;
    private final int iterationCount;
    private final Cipher cipher;

    public AesUtil(int keySize, int iterationCount) {
        this.keySize = keySize;
        this.iterationCount = iterationCount;
        try {
            this.cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception e) {
            throw this.fail(e);
        }
    }

    public String encrypt(String salt, String iv, String passphrase, String plaintext) {
        SecretKey key = this.generateKey(salt, passphrase);
        byte[] encrypted = this.doFinal(1, key, iv, plaintext.getBytes(StandardCharsets.UTF_8));
        return AesUtil.base64(encrypted);
    }

    public String decrypt(String salt, String iv, String passphrase, String ciphertext) {
        SecretKey key = this.generateKey(salt, passphrase);
        byte[] decrypted = this.doFinal(2, key, iv, AesUtil.base64(ciphertext));
        return new String(decrypted, StandardCharsets.UTF_8);
    }

    private byte[] doFinal(int encryptMode, SecretKey key, String iv, byte[] bytes) {
        try {
            this.cipher.init(encryptMode, (Key)key, new IvParameterSpec(AesUtil.hex(iv)));
            return this.cipher.doFinal(bytes);
        }
        catch (Exception e) {
            throw this.fail(e);
        }
    }

    private SecretKey generateKey(String salt, String passphrase) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), AesUtil.hex(salt), this.iterationCount, this.keySize);
            return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        }
        catch (Exception e) {
            throw this.fail(e);
        }
    }

    protected static String random(int length) {
        byte[] salt = new byte[length];
        new SecureRandom().nextBytes(salt);
        return AesUtil.hex(salt);
    }

    protected static String base64(byte[] bytes) {
        return DatatypeConverter.printBase64Binary((byte[])bytes);
    }

    protected static byte[] base64(String str) {
        return DatatypeConverter.parseBase64Binary((String)str);
    }

    protected static String hex(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    protected static byte[] hex(String str) {
        return DatatypeConverter.parseHexBinary((String)str);
    }

    private IllegalStateException fail(Exception e) {
        return new IllegalStateException(e);
    }
}

