/*
 * Decompiled with CFR 0.152.
 */
package io.github.jacksonbrienen.jwfd;

import io.github.jacksonbrienen.jwfd.FileExtension;
import io.github.jacksonbrienen.jwfd.JFileDialog;
import io.github.jacksonbrienen.jwfd.JNIException;
import io.github.jacksonbrienen.jwfd.WindowsFileDialog;
import java.awt.Frame;

public final class JWindowsFileDialog {
    private JWindowsFileDialog() {
    }

    public static String showOpenDialog(Frame frame) {
        return JWindowsFileDialog.showOpenDialog(frame, FileExtension.ALL);
    }

    public static String showOpenDialog(Frame frame, FileExtension ... filters) {
        return JWindowsFileDialog.showOpenDialog(frame, null, filters);
    }

    public static String showOpenDialog(Frame frame, String title, FileExtension ... filters) {
        return JWindowsFileDialog.showOpenDialog(frame, title, null, filters);
    }

    public static String showOpenDialog(Frame frame, String title, String path, FileExtension ... filters) {
        if (WindowsFileDialog.IS_WINDOWS) {
            try {
                return WindowsFileDialog.openFileDialog(frame, title, path, JWindowsFileDialog.toWindowsFilter(filters));
            }
            catch (JNIException | UnsatisfiedLinkError throwable) {
                // empty catch block
            }
        }
        return JFileDialog.showOpenDialog(frame, title, path, filters);
    }

    public static String showSaveDialog(Frame frame) {
        return JWindowsFileDialog.showSaveDialog(frame, FileExtension.ALL);
    }

    public static String showSaveDialog(Frame frame, FileExtension ... filters) {
        return JWindowsFileDialog.showSaveDialog(frame, null, filters);
    }

    public static String showSaveDialog(Frame frame, String title, FileExtension ... filters) {
        return JWindowsFileDialog.showSaveDialog(frame, title, null, filters);
    }

    public static String showSaveDialog(Frame frame, String title, String path, FileExtension ... filters) {
        if (WindowsFileDialog.IS_WINDOWS) {
            try {
                return WindowsFileDialog.openSaveDialog(frame, title, path, JWindowsFileDialog.toWindowsFilter(filters));
            }
            catch (JNIException | UnsatisfiedLinkError throwable) {
                // empty catch block
            }
        }
        return JFileDialog.showSaveDialog(frame, title, path, filters);
    }

    public static String[] showMultiDialog(Frame frame) {
        return JWindowsFileDialog.showMultiDialog(frame, FileExtension.ALL);
    }

    public static String[] showMultiDialog(Frame frame, FileExtension ... filters) {
        return JWindowsFileDialog.showMultiDialog(frame, null, filters);
    }

    public static String[] showMultiDialog(Frame frame, String title, FileExtension ... filters) {
        return JWindowsFileDialog.showMultiDialog(frame, title, null, filters);
    }

    public static String[] showMultiDialog(Frame frame, String title, String path, FileExtension ... filters) {
        if (WindowsFileDialog.IS_WINDOWS) {
            try {
                return WindowsFileDialog.openMultipleDialog(frame, title, path, JWindowsFileDialog.toWindowsFilter(filters));
            }
            catch (JNIException | UnsatisfiedLinkError throwable) {
                // empty catch block
            }
        }
        return JFileDialog.showMultiDialog(frame, title, path, filters);
    }

    public static String showDirectoryDialog(Frame frame) {
        return JWindowsFileDialog.showDirectoryDialog(frame, null);
    }

    public static String showDirectoryDialog(Frame frame, String title) {
        return JWindowsFileDialog.showDirectoryDialog(frame, title, null);
    }

    public static String showDirectoryDialog(Frame frame, String title, String path) {
        if (WindowsFileDialog.IS_WINDOWS) {
            try {
                return WindowsFileDialog.openDirDialog(frame, title, path);
            }
            catch (JNIException | UnsatisfiedLinkError throwable) {
                // empty catch block
            }
        }
        return JFileDialog.showDirDialog(frame, title, path);
    }

    private static String toWindowsFilter(FileExtension ... filter) {
        if (filter == null || filter.length == 0) {
            return FileExtension.ALL.getWindowsFilter();
        }
        StringBuilder bld = new StringBuilder(filter[0].getWindowsFilter());
        for (int i = 1; i < filter.length; ++i) {
            bld.append('\u0000').append(filter[i].getWindowsFilter());
        }
        return bld.toString();
    }
}

