/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.vpn;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ubnt.data.NetworkConf;
import com.ubnt.data.SettingPreference;
import com.ubnt.model.M.OoOO.B;
import com.ubnt.model.api.network.configuration.NetworkPurpose;
import com.ubnt.model.api.vpn.ImmutableVpnL2tpConfigurationDto;
import com.ubnt.return.F;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Optional;
import org.immutables.value.Value;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_ABSENT)
@JsonDeserialize(builder=ImmutableVpnL2tpConfigurationDto.Builder.class)
@Schema(name="L2TP VPN Configuration")
@Value.Immutable
@F
public interface VpnL2tpConfigurationDto {
    @JsonProperty(value="purpose")
    public NetworkPurpose purpose();

    @JsonProperty(value="vpn_type")
    public B vpnType();

    @JsonProperty(value="setting_preference")
    public Optional<SettingPreference> settingPreference();

    @JsonProperty(value="l2tp_allow_weak_ciphers")
    public boolean allowWeakCiphers();

    @JsonProperty(value="require_mschapv2")
    public boolean requireMsChapV2();

    @JsonProperty(value="dhcpd_dns_enabled")
    public boolean dhcpdDnsEnabled();

    public static ImmutableVpnL2tpConfigurationDto.Builder builder() {
        return ImmutableVpnL2tpConfigurationDto.builder();
    }

    public static VpnL2tpConfigurationDto ofLegacy(NetworkConf networkConf) {
        return VpnL2tpConfigurationDto.builder().purpose(networkConf.getNetworkPurpose()).vpnType(networkConf.getVpnType().orElse(B.\u00d400000)).settingPreference(networkConf.getSettingPreference()).allowWeakCiphers(networkConf.isL2tpAllowWeakCiphers()).requireMsChapV2(networkConf.isRequireMsChapV2()).dhcpdDnsEnabled(networkConf.isDhcpdDnsEnabled()).build();
    }
}

