/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.floorplan;

import com.ubnt.model.api.floorplan.FloorPlanShapeType;
import com.ubnt.repository.C;
import com.ubnt.repository.oo0O;
import com.ubnt.return.o0OO;
import com.ubnt.service.floorplan.FloorPlanDeviceDocumentPart;
import com.ubnt.service.floorplan.FloorPlanMapDocumentPart;
import com.ubnt.service.floorplan.FloorPlanScaleDocumentPart;
import com.ubnt.service.floorplan.FloorPlanWallDocumentPart;
import com.ubnt.service.floorplan.if;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.immutables.builder.Builder;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Immutable;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Immutable
@Document(collection="floorplan_shape")
@o0OO
public class FloorPlanShapeDocument
implements C,
oo0O {
    public static final String COLLECTION_NAME = "floorplan_shape";
    public static final FloorPlanShapeDocument EMPTY = FloorPlanShapeDocument.builder().\u00d500000();
    @Id
    private String id;
    @Field(value="site_id")
    @Indexed
    private final String siteId;
    @Field(value="uuid")
    @Indexed(unique=true)
    private final String uuid;
    @Field(value="plan_id")
    @Indexed
    private final String planId;
    @Field(value="status")
    private final Integer status;
    @Field(value="type")
    private final FloorPlanShapeType type;
    @Field(value="device")
    private final FloorPlanDeviceDocumentPart device;
    @Field(value="map")
    private final FloorPlanMapDocumentPart map;
    @Field(value="scale")
    private final FloorPlanScaleDocumentPart scale;
    @Field(value="wall")
    private final FloorPlanWallDocumentPart wall;

    @Builder.Constructor
    public FloorPlanShapeDocument(@Value(value="_id") @Nullable String string, @Value(value="site_id") String string2, @Value(value="uuid") String string3, @Value(value="plan_id") String string4, @Value(value="status") Integer n2, @Value(value="type") FloorPlanShapeType floorPlanShapeType, @Value(value="device") @Nullable FloorPlanDeviceDocumentPart floorPlanDeviceDocumentPart, @Value(value="map") @Nullable FloorPlanMapDocumentPart floorPlanMapDocumentPart, @Value(value="scale") @Nullable FloorPlanScaleDocumentPart floorPlanScaleDocumentPart, @Value(value="wall") @Nullable FloorPlanWallDocumentPart floorPlanWallDocumentPart) {
        this.id = string;
        this.siteId = string2;
        this.uuid = string3;
        this.planId = string4;
        this.status = n2;
        this.type = floorPlanShapeType;
        this.device = floorPlanDeviceDocumentPart;
        this.map = floorPlanMapDocumentPart;
        this.scale = floorPlanScaleDocumentPart;
        this.wall = floorPlanWallDocumentPart;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getSiteId() {
        return this.siteId;
    }

    public String getUuid() {
        return this.uuid;
    }

    @Override
    public String getCollectionName() {
        return COLLECTION_NAME;
    }

    public int getStatus() {
        return Optional.ofNullable(this.status).orElse(0);
    }

    public FloorPlanShapeType getType() {
        return this.type;
    }

    public String getPlanId() {
        return this.planId;
    }

    public Optional<FloorPlanDeviceDocumentPart> getDevice() {
        return Optional.ofNullable(this.device);
    }

    public Optional<FloorPlanMapDocumentPart> getMap() {
        return Optional.ofNullable(this.map);
    }

    public Optional<FloorPlanScaleDocumentPart> getScale() {
        return Optional.ofNullable(this.scale);
    }

    public Optional<FloorPlanWallDocumentPart> getWall() {
        return Optional.ofNullable(this.wall);
    }

    public FloorPlanShapeDocument duplicateWithId(String string) {
        if (string != null && !StringUtils.equals((CharSequence)string, (CharSequence)this.id)) {
            return FloorPlanShapeDocument.builder().\u00f600000(string).\u00d200000(this.siteId).\u00d600000(this.uuid).o00000(this.planId).\u00f500000(this.status).\u00f400000(this.type).\u00d400000(this.device).void(this.map).Object(this.scale).float(this.wall).\u00d500000();
        }
        return this;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FloorPlanShapeDocument floorPlanShapeDocument = (FloorPlanShapeDocument)object;
        return new EqualsBuilder().append((Object)this.id, (Object)floorPlanShapeDocument.id).append((Object)this.siteId, (Object)floorPlanShapeDocument.siteId).append((Object)this.planId, (Object)floorPlanShapeDocument.planId).append((Object)this.type, (Object)floorPlanShapeDocument.type).append((Object)this.device, (Object)floorPlanShapeDocument.device).append((Object)this.map, (Object)floorPlanShapeDocument.map).append((Object)this.scale, (Object)floorPlanShapeDocument.scale).append((Object)this.status, (Object)floorPlanShapeDocument.status).append((Object)this.uuid, (Object)floorPlanShapeDocument.uuid).append((Object)this.wall, (Object)floorPlanShapeDocument.wall).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.id).append((Object)this.siteId).append((Object)this.planId).append((Object)this.type).append((Object)this.device).append((Object)this.map).append((Object)this.scale).append((Object)this.status).append((Object)this.uuid).append((Object)this.wall).toHashCode();
    }

    public static if builder() {
        return new if();
    }

    public static class _o {
        static final String \u00d500000 = "plan_id";
        static final String null = "type";
        static final String o00000 = "status";
        static final String \u00d200000 = "device";
        static final String String = "map";
        static final String \u00d600000 = "scale";
        static final String \u00d800000 = "uuid";
        static final String \u00d300000 = "wall";

        private _o() {
        }
    }
}

