/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.processor.reports.multithread.writer;

import java.io.PrintWriter;
import java.util.logging.Logger;
import org.verapdf.processor.reports.ResultStructure;
import org.verapdf.processor.reports.multithread.writer.ReportWriter;

public class JsonReportWriter
extends ReportWriter {
    private static final Logger LOGGER = Logger.getLogger(JsonReportWriter.class.getCanonicalName());
    protected boolean isFirstReport;

    protected JsonReportWriter(PrintWriter outputStreamWriter, PrintWriter errorStreamWriter) {
        super(outputStreamWriter, errorStreamWriter);
    }

    @Override
    public void write(ResultStructure result) {
        if (this.isFirstReport) {
            this.isFirstReport = false;
        } else {
            this.outputStreamWriter.write(",");
        }
        this.merge(result.getReportFile(), this.outputStreamWriter);
        this.deleteTemp(result);
    }

    @Override
    public void startDocument() {
        this.outputStreamWriter.write("{\"reports\":[");
        this.isFirstReport = true;
    }

    @Override
    public void endDocument() {
        this.outputStreamWriter.write("]}");
    }
}

