/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.configuration.ClientboundFinishConfigurationPacket;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryAnswerPacket;
import net.minecraftforge.common.util.HexDumper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PacketLogger {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Marker MARKER = MarkerManager.getMarker((String)"PACKETLOG");
    private final Connection connection;
    public boolean enabled = false;

    public PacketLogger(Connection connection) {
        this.connection = connection;
    }

    public void send(Packet<?> packet) {
        this.common(this.connection.getReceiving(), this.connection.getSending(), this.connection.getOutputboundProtocolInfo(), packet);
    }

    public void recv(Packet<?> packet) {
        this.common(this.connection.getReceiving(), this.connection.getReceiving(), this.connection.getInboundProtocolInfo(), packet);
    }

    private void common(PacketFlow side, PacketFlow flow, ProtocolInfo<?> protocol, Packet<?> packet) {
        if (!this.enabled) {
            return;
        }
        if (packet instanceof ClientboundFinishConfigurationPacket) {
            this.enabled = false;
        }
        Object channel = null;
        String hex = null;
        Packet<?> packet2 = packet;
        Objects.requireNonNull(packet2);
        Packet<?> packet3 = packet2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ClientboundCustomPayloadPacket.class, ServerboundCustomPayloadPacket.class, ClientboundCustomQueryPacket.class, ServerboundCustomQueryAnswerPacket.class}, packet3, n)) {
            case 0: {
                ClientboundCustomPayloadPacket custom = (ClientboundCustomPayloadPacket)packet3;
                channel = custom.payload().type().id().toString();
                hex = PacketLogger.hex(protocol, packet);
                break;
            }
            case 1: {
                ServerboundCustomPayloadPacket custom = (ServerboundCustomPayloadPacket)packet3;
                channel = custom.payload().type().id().toString();
                hex = PacketLogger.hex(protocol, packet);
                break;
            }
            case 2: {
                ClientboundCustomQueryPacket custom = (ClientboundCustomQueryPacket)packet3;
                channel = custom.payload().id().toString() + " id " + custom.transactionId();
                hex = PacketLogger.hex(protocol, packet);
                break;
            }
            case 3: {
                ServerboundCustomQueryAnswerPacket custom = (ServerboundCustomQueryAnswerPacket)packet3;
                channel = packet.getClass().getName() + " id " + custom.transactionId();
                hex = PacketLogger.hex(protocol, packet);
                break;
            }
        }
        if (channel != null && hex != null) {
            LOGGER.info(MARKER, "{} {} {} {}\n{}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName(), channel, (Object)hex);
        } else if (channel != null) {
            LOGGER.info(MARKER, "{} {} {} {}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName(), channel);
        } else {
            LOGGER.info(MARKER, "{} {} {}", (Object)PacketLogger.side(side), (Object)PacketLogger.dir(flow), (Object)packet.getClass().getName());
        }
    }

    private static String side(PacketFlow side) {
        return side == PacketFlow.CLIENTBOUND ? "CLIENT" : "SERVER";
    }

    private static String dir(PacketFlow flow) {
        return flow == PacketFlow.CLIENTBOUND ? "S->C" : "C->S";
    }

    private static <T extends PacketListener> String hex(ProtocolInfo protocol, Packet packet) {
        ByteBuf buf = Unpooled.buffer();
        protocol.codec().encode((Object)buf, (Object)packet);
        return HexDumper.dump(buf);
    }
}

