/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class Main {
    private static final Logger a = LogUtils.getLogger();

    /*
     * WARNING - void declaration
     */
    @ad(a="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] $$0) {
        ac.a();
        OptionParser $$1 = new OptionParser();
        OptionSpecBuilder $$2 = $$1.accepts("nogui");
        OptionSpecBuilder $$3 = $$1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder $$4 = $$1.accepts("demo");
        OptionSpecBuilder $$5 = $$1.accepts("bonusChest");
        OptionSpecBuilder $$6 = $$1.accepts("forceUpgrade");
        OptionSpecBuilder $$7 = $$1.accepts("eraseCache");
        OptionSpecBuilder $$8 = $$1.accepts("recreateRegionFiles");
        OptionSpecBuilder $$9 = $$1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec $$10 = $$1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec $$11 = $$1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec $$12 = $$1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec $$13 = $$1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec $$14 = $$1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder $$15 = $$1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec $$16 = $$1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec $$17 = $$1.nonOptions();
        try {
            void $$45;
            Dynamic $$38;
            OptionSet $$18 = $$1.parse($$0);
            if ($$18.has((OptionSpec)$$10)) {
                $$1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path $$19 = (Path)$$18.valueOf((OptionSpec)$$16);
            if ($$19 != null) {
                Main.a($$19);
            }
            p.g();
            if ($$18.has((OptionSpec)$$15)) {
                bub.f.a(btz.b);
            }
            amg.a();
            amg.c();
            ag.q();
            Path $$20 = Paths.get("server.properties", new String[0]);
            ark $$21 = new ark($$20);
            $$21.b();
            ehq.a($$21.a().M);
            Path $$22 = Paths.get("eula.txt", new String[0]);
            amk $$23 = new amk($$22);
            if ($$18.has((OptionSpec)$$3)) {
                a.info("Initialized '{}' and '{}'", (Object)$$20.toAbsolutePath(), (Object)$$22.toAbsolutePath());
                return;
            }
            if (!$$23.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File $$24 = new File((String)$$18.valueOf((OptionSpec)$$11));
            amz $$25 = amz.a(new YggdrasilAuthenticationService(Proxy.NO_PROXY), $$24);
            String $$26 = Optional.ofNullable((String)$$18.valueOf((OptionSpec)$$12)).orElse($$21.a().l);
            fcs $$27 = fcs.b($$24.toPath());
            fcs.c $$28 = $$27.d($$26);
            if ($$28.m()) {
                void $$37;
                try {
                    Dynamic<?> $$29 = $$28.h();
                    fct $$30 = $$28.a($$29);
                }
                catch (IOException | ut | va $$31) {
                    fcs.b $$32 = $$28.e();
                    a.warn("Failed to load world data from {}", (Object)$$32.b(), (Object)$$31);
                    a.info("Attempting to use fallback");
                    try {
                        Dynamic<?> $$33 = $$28.i();
                        fct $$34 = $$28.a($$33);
                    }
                    catch (IOException | ut | va $$35) {
                        a.error("Failed to load world data from {}", (Object)$$32.c(), (Object)$$35);
                        a.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)$$32.b(), (Object)$$32.c());
                        return;
                    }
                    $$28.n();
                }
                if ($$37.d()) {
                    a.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!$$37.r()) {
                    a.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                $$38 = null;
            }
            Dynamic $$39 = $$38;
            boolean $$40 = $$18.has((OptionSpec)$$9);
            if ($$40) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            awz $$41 = axc.a($$28);
            try {
                anc.c $$42 = Main.a($$21.a(), $$39, $$40, $$41);
                and $$43 = (and)ag.c(arg_0 -> Main.a($$42, $$39, $$18, (OptionSpec)$$4, $$21, (OptionSpec)$$5, arg_0)).get();
            }
            catch (Exception $$44) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)$$44);
                return;
            }
            jz.b $$46 = $$45.c().a();
            fdd $$47 = $$45.d();
            boolean $$48 = $$18.has((OptionSpec)$$8);
            if ($$18.has((OptionSpec)$$6) || $$48) {
                Main.a($$28, $$47, bds.a(), $$18.has((OptionSpec)$$7), () -> true, $$46, $$48);
            }
            $$28.a($$46, $$47);
            final ari $$49 = MinecraftServer.a(arg_0 -> Main.a($$28, $$41, (and)$$45, $$21, $$25, $$18, (OptionSpec)$$13, (OptionSpec)$$4, (OptionSpec)$$14, (OptionSpec)$$2, (OptionSpec)$$17, arg_0));
            Thread $$50 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    $$49.a(true);
                }
            };
            $$50.setUncaughtExceptionHandler(new s(a));
            Runtime.getRuntime().addShutdownHook($$50);
        }
        catch (Exception $$51) {
            a.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)$$51);
        }
    }

    private static void a(Path $$0) {
        try {
            long $$1 = ProcessHandle.current().pid();
            Files.writeString($$0, (CharSequence)Long.toString($$1), new OpenOption[0]);
        }
        catch (IOException $$2) {
            throw new UncheckedIOException($$2);
        }
    }

    private static anc.c a(arj $$0, @Nullable Dynamic<?> $$1, boolean $$2, awz $$3) {
        dns $$8;
        boolean $$7;
        if ($$1 != null) {
            dns $$4 = fcs.a($$1);
            boolean $$5 = false;
            dns $$6 = $$4;
        } else {
            $$7 = true;
            $$8 = new dns($$0.U, cyf.h);
        }
        anc.d $$9 = new anc.d($$3, $$8, $$2, $$7);
        return new anc.c($$9, el.a.b, $$0.A);
    }

    private static void a(fcs.c $$0, fdd $$1, DataFixer $$2, boolean $$3, BooleanSupplier $$4, jz $$5, boolean $$6) {
        a.info("Forcing world upgrade!");
        try (bwx $$7 = new bwx($$0, $$2, $$1, $$5, $$3, $$6);){
            xo $$8 = null;
            while (!$$7.b()) {
                int $$10;
                xo $$9 = $$7.h();
                if ($$8 != $$9) {
                    $$8 = $$9;
                    a.info($$7.h().getString());
                }
                if (($$10 = $$7.e()) > 0) {
                    int $$11 = $$7.f() + $$7.g();
                    a.info("{}% completed ({} / {} chunks)...", new Object[]{bcb.d((float)$$11 / (float)$$10 * 100.0f), $$11, $$10});
                }
                if (!$$4.getAsBoolean()) {
                    $$7.a();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static /* synthetic */ ari a(fcs.c $$0, awz $$1, and $$2, ark $$3, amz $$4, OptionSet $$5, OptionSpec $$6, OptionSpec $$7, OptionSpec $$8, OptionSpec $$9, OptionSpec $$10, Thread $$11) {
        boolean $$13;
        ari $$12 = new ari($$11, $$0, $$1, $$2, $$3, bds.a(), $$4, aun::b);
        $$12.a((Integer)$$5.valueOf($$6));
        $$12.c($$5.has($$7));
        $$12.b((String)$$5.valueOf($$8));
        boolean bl2 = $$13 = !$$5.has($$9) && !$$5.valuesOf($$10).contains("nogui");
        if ($$13 && !GraphicsEnvironment.isHeadless()) {
            $$12.bt();
        }
        th.a.b();
        return $$12;
    }

    private static /* synthetic */ CompletableFuture a(anc.c $$0, Dynamic $$1, OptionSet $$2, OptionSpec $$3, ark $$4, OptionSpec $$52, Executor $$6) {
        return anc.a($$0, $$5 -> {
            ekv $$14;
            eky $$13;
            dmy $$12;
            jy<ehz> $$6 = $$5.d().f(mn.bv);
            if ($$1 != null) {
                fcp $$7 = fcs.a($$1, $$5.b(), $$6, $$5.c());
                return new anc.b<fdd>($$7.a(), $$7.b().b());
            }
            a.info("No existing world data, creating new world");
            if ($$2.has($$3)) {
                dmy $$8 = MinecraftServer.d;
                eky $$9 = eky.b;
                ekv $$10 = euo.a($$5.c());
            } else {
                arj $$11 = $$4.a();
                $$12 = new dmy($$11.l, $$11.k, $$11.t, $$11.j, false, new dmq($$5.b().b()), $$5.b());
                $$13 = $$2.has($$52) ? $$11.aa.a(true) : $$11.aa;
                $$14 = $$11.a($$5.c());
            }
            ekv.b $$15 = $$14.a($$6);
            Lifecycle $$16 = $$15.a().add($$5.c().d());
            return new anc.b<fcw>(new fcw($$12, $$13, $$15.d(), $$16), $$15.b());
        }, and::new, ag.h(), $$6);
    }
}

