/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.ice.harvest;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.Transport;
import org.ice4j.TransportAddress;
import org.ice4j.ice.harvest.MappingCandidateHarvester;

public class AwsCandidateHarvester
extends MappingCandidateHarvester {
    private static final Logger logger = Logger.getLogger(AwsCandidateHarvester.class.getName());
    private static final HttpClient httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofMillis(500L)).build();
    private static final String PUBLIC_IP_URL = "http://169.254.169.254/latest/meta-data/public-ipv4";
    private static final String LOCAL_IP_URL = "http://169.254.169.254/latest/meta-data/local-ipv4";
    private static final String IMDS_API_TOKEN_URL = "http://169.254.169.254/latest/api/token";
    private static final String EC2_METADATA_TOKEN_HEADER = "X-aws-ec2-metadata-token";
    private static final String EC2_METADATA_TOKEN_TTL_HEADER = "X-aws-ec2-metadata-token-ttl-seconds";
    private static final String EC2_METADATA_TOKEN_DEFAULT_TTL = "21600";
    private static Boolean RUNNING_ON_EC2 = null;
    private static TransportAddress mask;
    private static TransportAddress face;
    private static boolean addressChecked;

    public AwsCandidateHarvester() {
        super("aws");
    }

    private static synchronized void obtainEC2Addresses() {
        if (addressChecked) {
            return;
        }
        addressChecked = true;
        String localIPStr = null;
        String publicIPStr = null;
        try {
            String metaDataToken = AwsCandidateHarvester.fetch(IMDS_API_TOKEN_URL, Collections.singletonMap(EC2_METADATA_TOKEN_TTL_HEADER, EC2_METADATA_TOKEN_DEFAULT_TTL), "PUT");
            Map<String, String> tokenHeader = Collections.singletonMap(EC2_METADATA_TOKEN_HEADER, metaDataToken);
            localIPStr = AwsCandidateHarvester.fetch(LOCAL_IP_URL, tokenHeader);
            publicIPStr = AwsCandidateHarvester.fetch(PUBLIC_IP_URL, tokenHeader);
            face = new TransportAddress(localIPStr, 9, Transport.UDP);
            mask = new TransportAddress(publicIPStr, 9, Transport.UDP);
            logger.info("Detected AWS local IP: " + String.valueOf(face));
            logger.info("Detected AWS public IP: " + String.valueOf(mask));
        }
        catch (Exception exc) {
            logger.log(Level.INFO, "We failed to obtain EC2 instance addresses for the following reason: ", exc);
            logger.info("String for local IP: " + localIPStr);
            logger.info("String for public IP: " + publicIPStr);
        }
    }

    @Override
    public TransportAddress getMask() {
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            AwsCandidateHarvester.obtainEC2Addresses();
            return mask;
        }
        return null;
    }

    @Override
    public TransportAddress getFace() {
        if (AwsCandidateHarvester.smellsLikeAnEC2()) {
            AwsCandidateHarvester.obtainEC2Addresses();
            return face;
        }
        return null;
    }

    public static synchronized boolean smellsLikeAnEC2() {
        if (RUNNING_ON_EC2 == null) {
            RUNNING_ON_EC2 = AwsCandidateHarvester.doTestEc2();
        }
        return RUNNING_ON_EC2;
    }

    private static boolean doTestEc2() {
        try {
            String metaDataToken = AwsCandidateHarvester.fetch(IMDS_API_TOKEN_URL, Collections.singletonMap(EC2_METADATA_TOKEN_TTL_HEADER, EC2_METADATA_TOKEN_DEFAULT_TTL), "PUT");
            return metaDataToken != null;
        }
        catch (Exception exc) {
            return false;
        }
    }

    private static String fetch(String url, Map<String, String> headers) throws Exception {
        return AwsCandidateHarvester.fetch(url, headers, "GET");
    }

    private static String fetch(String url, Map<String, String> headers, String method) throws Exception {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(new URI(url)).method(method, HttpRequest.BodyPublishers.noBody());
        for (Map.Entry<String, String> header : headers.entrySet()) {
            builder.setHeader(header.getKey(), header.getValue());
        }
        HttpResponse<String> response = httpClient.send(builder.build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new Exception("Failed to fetch " + url + ". Response code: " + response.statusCode());
        }
        return response.body();
    }

    static {
        addressChecked = false;
    }
}

